/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.gson.JsonObject;
import java.util.Collection;
import net.minecraft.util.ResourceLocation;
import xiroc.dungeoncrawl.dungeon.generator.layer.LayerGeneratorSettings;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.ModelPools;
import xiroc.dungeoncrawl.exception.DatapackLoadException;
import xiroc.dungeoncrawl.util.JSONUtils;
import xiroc.dungeoncrawl.util.WeightedRandom;

public class ModelSelector {
    public WeightedRandom<DungeonModel> rooms;
    public WeightedRandom<DungeonModel> fullNodes;
    public WeightedRandom<DungeonModel> forkNodes;
    public WeightedRandom<DungeonModel> straightNodes;
    public WeightedRandom<DungeonModel> turnNodes;
    public WeightedRandom<DungeonModel> deadEndNodes;
    public WeightedRandom<DungeonModel> corridors;
    public WeightedRandom<DungeonModel> corridorLinkers;
    public WeightedRandom<DungeonModel> nodeConnectors;

    public ModelSelector(WeightedRandom<DungeonModel> rooms, WeightedRandom<DungeonModel> fullNodes, WeightedRandom<DungeonModel> forkNodes, WeightedRandom<DungeonModel> straightNodes, WeightedRandom<DungeonModel> turnNodes, WeightedRandom<DungeonModel> deadEndNodes, WeightedRandom<DungeonModel> corridors, WeightedRandom<DungeonModel> corridorLinkers, WeightedRandom<DungeonModel> nodeConnectors) {
        this.rooms = rooms;
        this.fullNodes = fullNodes;
        this.forkNodes = forkNodes;
        this.straightNodes = straightNodes;
        this.turnNodes = turnNodes;
        this.deadEndNodes = deadEndNodes;
        this.nodeConnectors = nodeConnectors;
        this.corridors = corridors;
        this.corridorLinkers = corridorLinkers;
    }

    public static ModelSelector fromJson(JsonObject object, ResourceLocation resource) {
        return new ModelSelector(ModelSelector.loadRandom("rooms", object, resource), ModelSelector.loadRandom("full_nodes", object, resource), ModelSelector.loadRandom("fork_nodes", object, resource), ModelSelector.loadRandom("straight_nodes", object, resource), ModelSelector.loadRandom("turn_nodes", object, resource), ModelSelector.loadRandom("dead_end_nodes", object, resource), ModelSelector.loadRandom("corridors", object, resource), ModelSelector.loadRandom("corridor_linkers", object, resource), ModelSelector.loadRandom("node_connectors", object, resource));
    }

    public static WeightedRandom<DungeonModel> loadRandom(String name, JsonObject object, ResourceLocation resource) {
        WeightedRandom.Builder builder = new WeightedRandom.Builder();
        JsonObject models = object.getAsJsonObject(name);
        if (models.has("inherit")) {
            models.getAsJsonArray("inherit").forEach(element -> {
                String key = element.getAsString();
                if (!ModelPools.POOLS.containsKey(key)) {
                    throw new DatapackLoadException("Unknown model pool " + key + " in " + resource);
                }
                builder.addAll((Collection)ModelPools.POOLS.get(key));
            });
        }
        if (models.has("models")) {
            models.getAsJsonArray("models").forEach(element -> {
                JsonObject entry = element.getAsJsonObject();
                ResourceLocation key = new ResourceLocation(entry.get("key").getAsString());
                if (!DungeonModels.KEY_TO_MODEL.containsKey(key)) {
                    throw new DatapackLoadException("Unknown model key " + key + " in " + resource);
                }
                builder.add(DungeonModels.KEY_TO_MODEL.get(key), JSONUtils.getWeight(entry));
            });
        }
        if (builder.entries.isEmpty()) {
            throw new DatapackLoadException("Empty model list " + name + " in " + resource);
        }
        return builder.build();
    }

    public boolean verify(LayerGeneratorSettings settings) {
        if (settings.maxRooms > 0 && this.rooms.isEmpty()) {
            return false;
        }
        if (settings.maxNodes > 0 && (this.deadEndNodes.isEmpty() || this.forkNodes.isEmpty() || this.straightNodes.isEmpty() || this.turnNodes.isEmpty() || this.fullNodes.isEmpty() || this.nodeConnectors.isEmpty())) {
            return false;
        }
        return !this.corridors.isEmpty() && !this.corridorLinkers.isEmpty();
    }
}

