/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.generator;

import java.util.Random;
import net.minecraft.util.math.ChunkPos;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.DungeonLayer;
import xiroc.dungeoncrawl.dungeon.DungeonType;
import xiroc.dungeoncrawl.dungeon.generator.DungeonGenerator;
import xiroc.dungeoncrawl.dungeon.generator.layer.LayerGenerator;
import xiroc.dungeoncrawl.dungeon.generator.layer.LayerGeneratorSettings;
import xiroc.dungeoncrawl.util.Position2D;

public class DefaultDungeonGenerator
extends DungeonGenerator {
    private int secretRoomLayer;
    private LayerGenerator layerGenerator;

    @Override
    public void initializeDungeon(DungeonType type, DungeonBuilder dungeonBuilder, ChunkPos chunkPos, Random rand) {
        super.initializeDungeon(type, dungeonBuilder, chunkPos, rand);
        this.secretRoomLayer = rand.nextInt(2);
    }

    @Override
    public void initializeLayer(LayerGeneratorSettings settings, DungeonBuilder dungeonBuilder, Random rand, int layer, boolean isLastLayer) {
        this.layerGenerator = this.type.getLayer((int)layer).layerType.layerGenerator;
        this.layerGenerator.initializeLayer(settings, dungeonBuilder, rand, layer, isLastLayer);
    }

    @Override
    public int layerCount(Random rand, int height) {
        return Math.min(this.type.dungeonSettings.maxLayers, height / 9);
    }

    @Override
    public void generateLayer(DungeonBuilder dungeonBuilder, DungeonLayer dungeonLayer, int layer, Random rand, Position2D start) {
        DungeonCrawl.LOGGER.debug("Generating layout for layer {}", (Object)layer);
        if (((Boolean)Config.SECRET_ROOMS.get()).booleanValue() && layer == this.secretRoomLayer) {
            this.layerGenerator.enableSecretRoom();
        }
        this.layerGenerator.generateLayer(dungeonBuilder, dungeonLayer, layer, rand, start);
    }
}

