/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.util;

import dev.rlnt.lazierae2.util.IOUtil;
import dev.rlnt.lazierae2.util.TypeEnums;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class TextUtil {
    private static final Locale LOCALE = Locale.getDefault();
    private static final DecimalFormat DF = (DecimalFormat)NumberFormat.getInstance(LOCALE).clone();
    private static final String[] UNITS = new String[]{"", "k", "M", "G", "T", "P"};
    private static final EnumMap<TypeEnums.TRANSLATE_TYPE, String> TRANSLATION_TYPES = new EnumMap(TypeEnums.TRANSLATE_TYPE.class);

    private TextUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static ResourceLocation getRL(String key) {
        return new ResourceLocation("lazierae2", key);
    }

    public static String formatEnergy(Number number, boolean advanced) {
        if (!advanced) {
            int numberOfDigits = number.intValue() == 0 ? 0 : (int)(1.0 + Math.floor(Math.log10(Math.abs(number.doubleValue()))));
            int base10Exponent = numberOfDigits < 4 ? 0 : 3 * ((numberOfDigits - 1) / 3);
            double normalized = number.doubleValue() / Math.pow(10.0, base10Exponent);
            return String.format(LOCALE, "%s %sFE", TextUtil.formatNumber(normalized, 1, 2), UNITS[base10Exponent / 3]);
        }
        return String.format(LOCALE, "%s FE", TextUtil.formatNumber(number, 1, 3));
    }

    public static String formatNumber(Number input, int minFraction, int maxFraction) {
        DF.setMinimumFractionDigits(minFraction);
        DF.setMaximumFractionDigits(maxFraction);
        return DF.format(input);
    }

    public static TranslationTextComponent translate(TypeEnums.TRANSLATE_TYPE type, String key, TextFormatting ... color) {
        TranslationTextComponent output = new TranslationTextComponent(TextUtil.getTranslationKey(type, key));
        return color.length == 0 ? output : (TranslationTextComponent)output.func_240699_a_(color[0]);
    }

    public static StringTextComponent colorize(String input, TextFormatting color) {
        return (StringTextComponent)new StringTextComponent(input).func_240699_a_(color);
    }

    private static String getTranslationKey(TypeEnums.TRANSLATE_TYPE type, String key) {
        return String.format("%s.%s.%s", TRANSLATION_TYPES.get((Object)type), "lazierae2", key);
    }

    public static String translateIOSide(TypeEnums.IO_SIDE side) {
        return IOUtil.getIoSideTranslations().get((Object)side);
    }

    public static String translateIOSetting(TypeEnums.IO_SETTING setting) {
        return IOUtil.getIoSettingsTranslations().get((Object)setting);
    }

    public static TranslationTextComponent translateIOSetting(boolean mode) {
        return TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, mode ? "extract_activated" : "extract_deactivated", new TextFormatting[0]);
    }

    static {
        TRANSLATION_TYPES.put(TypeEnums.TRANSLATE_TYPE.CONTAINER, "container");
        TRANSLATION_TYPES.put(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "tooltip");
        TRANSLATION_TYPES.put(TypeEnums.TRANSLATE_TYPE.BUTTON, "button");
        TRANSLATION_TYPES.put(TypeEnums.TRANSLATE_TYPE.IO_SIDE, "io_side");
        TRANSLATION_TYPES.put(TypeEnums.TRANSLATE_TYPE.IO_SETTING, "io_setting");
        TRANSLATION_TYPES.put(TypeEnums.TRANSLATE_TYPE.EXTRACT_SETTING, "extract_setting");
        TRANSLATION_TYPES.put(TypeEnums.TRANSLATE_TYPE.JEI, "jei");
        DF.setRoundingMode(RoundingMode.DOWN);
    }
}

