/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.tile;

import dev.rlnt.lazierae2.container.EtcherContainer;
import dev.rlnt.lazierae2.inventory.EtcherItemHandler;
import dev.rlnt.lazierae2.inventory.base.MultiItemHandler;
import dev.rlnt.lazierae2.recipe.type.EtcherRecipe;
import dev.rlnt.lazierae2.setup.ModBlocks;
import dev.rlnt.lazierae2.setup.ModConfig;
import dev.rlnt.lazierae2.setup.ModRecipes;
import dev.rlnt.lazierae2.setup.ModTiles;
import dev.rlnt.lazierae2.tile.base.ProcessorTile;
import dev.rlnt.lazierae2.util.TypeEnums;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;

public class EtcherTile
extends ProcessorTile<MultiItemHandler, EtcherRecipe> {
    private static final int SLOT_AMOUNT = 5;
    private static final int[] SLOT_INPUTS = new int[]{2, 3, 4};

    public EtcherTile() {
        super((TileEntityType)ModTiles.ETCHER.get(), "circuit_etcher", SLOT_INPUTS);
        this.itemHandler = new EtcherItemHandler(5, this);
    }

    @Nullable
    public Container createMenu(int windowID, PlayerInventory inventory, PlayerEntity player) {
        return new EtcherContainer(windowID, inventory, this, this.info);
    }

    @Override
    protected IItemProvider getItemProvider() {
        return (IItemProvider)ModBlocks.ETCHER.get();
    }

    @Override
    protected IRecipeType<EtcherRecipe> getRecipeType() {
        return ModRecipes.Types.ETCHER;
    }

    @Override
    protected int getEffectiveEnergyCapacity() {
        int baseBuffer = (Integer)ModConfig.PROCESSING.etcherEnergyBuffer.get();
        double upgradeBuffer = ((Integer)ModConfig.PROCESSING.etcherEnergyBufferUpgrade.get()).intValue();
        return this.getUpgradedValue(baseBuffer, upgradeBuffer, TypeEnums.OPERATION_TYPE.ADD);
    }

    @Override
    public int getEffectiveEnergy() {
        int baseEnergy = (Integer)ModConfig.PROCESSING.etcherEnergyCostBase.get();
        double upgradeEnergy = (Double)ModConfig.PROCESSING.etcherEnergyCostUpgrade.get();
        return this.getUpgradedValue(baseEnergy, upgradeEnergy, TypeEnums.OPERATION_TYPE.MULTI);
    }

    @Override
    public int getEffectiveProcessTime(int baseProcessingTime) {
        double upgradProcessingTime = (Double)ModConfig.PROCESSING.etcherWorkTicksUpgrade.get();
        return this.getUpgradedValue(baseProcessingTime, upgradProcessingTime, TypeEnums.OPERATION_TYPE.DIV);
    }

    public int func_70302_i_() {
        return 5;
    }
}

