/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.tile;

import dev.rlnt.lazierae2.container.EnergizerContainer;
import dev.rlnt.lazierae2.inventory.EnergizerItemHandler;
import dev.rlnt.lazierae2.inventory.base.SingleItemHandler;
import dev.rlnt.lazierae2.recipe.type.EnergizerRecipe;
import dev.rlnt.lazierae2.setup.ModBlocks;
import dev.rlnt.lazierae2.setup.ModConfig;
import dev.rlnt.lazierae2.setup.ModRecipes;
import dev.rlnt.lazierae2.setup.ModTiles;
import dev.rlnt.lazierae2.tile.base.ProcessorTile;
import dev.rlnt.lazierae2.util.TypeEnums;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;

public class EnergizerTile
extends ProcessorTile<SingleItemHandler, EnergizerRecipe> {
    private static final int SLOT_AMOUNT = 3;
    private static final int[] SLOT_INPUTS = new int[]{2};

    public EnergizerTile() {
        super((TileEntityType)ModTiles.ENERGIZER.get(), "crystal_energizer", SLOT_INPUTS);
        this.itemHandler = new EnergizerItemHandler(3, this);
    }

    @Nullable
    public Container createMenu(int windowID, PlayerInventory inventory, PlayerEntity player) {
        return new EnergizerContainer(windowID, inventory, this, this.info);
    }

    @Override
    protected IItemProvider getItemProvider() {
        return (IItemProvider)ModBlocks.ENERGIZER.get();
    }

    @Override
    protected IRecipeType<EnergizerRecipe> getRecipeType() {
        return ModRecipes.Types.ENERGIZER;
    }

    @Override
    protected int getEffectiveEnergyCapacity() {
        int baseBuffer = (Integer)ModConfig.PROCESSING.energizerEnergyBuffer.get();
        double upgradeBuffer = ((Integer)ModConfig.PROCESSING.energizerEnergyBufferUpgrade.get()).intValue();
        return this.getUpgradedValue(baseBuffer, upgradeBuffer, TypeEnums.OPERATION_TYPE.ADD);
    }

    @Override
    public int getEffectiveEnergy() {
        int baseEnergy = (Integer)ModConfig.PROCESSING.energizerEnergyCostBase.get();
        double upgradeEnergy = (Double)ModConfig.PROCESSING.energizerEnergyCostUpgrade.get();
        return this.getUpgradedValue(baseEnergy, upgradeEnergy, TypeEnums.OPERATION_TYPE.MULTI);
    }

    @Override
    public int getEffectiveProcessTime(int baseProcessingTime) {
        double upgradProcessingTime = (Double)ModConfig.PROCESSING.energizerWorkTicksUpgrade.get();
        return this.getUpgradedValue(baseProcessingTime, upgradProcessingTime, TypeEnums.OPERATION_TYPE.DIV);
    }

    public int func_70302_i_() {
        return 3;
    }
}

