/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.tile;

import dev.rlnt.lazierae2.container.AggregatorContainer;
import dev.rlnt.lazierae2.inventory.AggregatorItemHandler;
import dev.rlnt.lazierae2.inventory.base.MultiItemHandler;
import dev.rlnt.lazierae2.recipe.type.AggregatorRecipe;
import dev.rlnt.lazierae2.setup.ModBlocks;
import dev.rlnt.lazierae2.setup.ModConfig;
import dev.rlnt.lazierae2.setup.ModRecipes;
import dev.rlnt.lazierae2.setup.ModTiles;
import dev.rlnt.lazierae2.tile.base.ProcessorTile;
import dev.rlnt.lazierae2.util.TypeEnums;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;

public class AggregatorTile
extends ProcessorTile<MultiItemHandler, AggregatorRecipe> {
    private static final int SLOT_AMOUNT = 5;
    private static final int[] SLOT_INPUTS = new int[]{2, 3, 4};

    public AggregatorTile() {
        super((TileEntityType)ModTiles.AGGREGATOR.get(), "fluix_aggregator", SLOT_INPUTS);
        this.itemHandler = new AggregatorItemHandler(5, this);
    }

    @Nullable
    public Container createMenu(int windowID, PlayerInventory inventory, PlayerEntity player) {
        return new AggregatorContainer(windowID, inventory, this, this.info);
    }

    public int func_70302_i_() {
        return 5;
    }

    @Override
    protected IItemProvider getItemProvider() {
        return (IItemProvider)ModBlocks.AGGREGATOR.get();
    }

    @Override
    protected IRecipeType<AggregatorRecipe> getRecipeType() {
        return ModRecipes.Types.AGGREGATOR;
    }

    @Override
    protected int getEffectiveEnergyCapacity() {
        int baseBuffer = (Integer)ModConfig.PROCESSING.aggregatorEnergyBuffer.get();
        double upgradeBuffer = ((Integer)ModConfig.PROCESSING.aggregatorEnergyBufferUpgrade.get()).intValue();
        return this.getUpgradedValue(baseBuffer, upgradeBuffer, TypeEnums.OPERATION_TYPE.ADD);
    }

    @Override
    public int getEffectiveEnergy() {
        int baseEnergy = (Integer)ModConfig.PROCESSING.aggregatorEnergyCostBase.get();
        double upgradeEnergy = (Double)ModConfig.PROCESSING.aggregatorEnergyCostUpgrade.get();
        return this.getUpgradedValue(baseEnergy, upgradeEnergy, TypeEnums.OPERATION_TYPE.MULTI);
    }

    @Override
    public int getEffectiveProcessTime(int baseProcessingTime) {
        double upgradProcessingTime = (Double)ModConfig.PROCESSING.aggregatorWorkTicksUpgrade.get();
        return this.getUpgradedValue(baseProcessingTime, upgradProcessingTime, TypeEnums.OPERATION_TYPE.DIV);
    }
}

