/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.recipe.builder;

import dev.rlnt.lazierae2.recipe.builder.base.FinishedSingleRecipe;
import dev.rlnt.lazierae2.recipe.builder.base.SingleRecipeBuilder;
import dev.rlnt.lazierae2.setup.ModConfig;
import dev.rlnt.lazierae2.setup.ModRecipes;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class EnergizerRecipeBuilder
extends SingleRecipeBuilder {
    private EnergizerRecipeBuilder(IItemProvider output, int outputCount) {
        super(output, outputCount);
    }

    public static EnergizerRecipeBuilder builder(IItemProvider output, int outputCount) {
        return new EnergizerRecipeBuilder(output, outputCount);
    }

    public EnergizerRecipeBuilder input(Ingredient input) {
        this.input = input;
        return this;
    }

    public EnergizerRecipeBuilder input(ITag<Item> tag) {
        return this.input(Ingredient.func_199805_a(tag));
    }

    public EnergizerRecipeBuilder input(IItemProvider item) {
        return this.input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
    }

    public EnergizerRecipeBuilder processingTime(int ticks) {
        this.processingTime = ticks;
        return this;
    }

    @Override
    protected void build(Consumer<IFinishedRecipe> consumer, ResourceLocation recipeID) {
        consumer.accept(new Recipe(recipeID, this));
    }

    @Override
    protected String getId() {
        return "crystal_energizer";
    }

    @Override
    protected void checkProcessingTime() {
        if (this.processingTime == 0) {
            this.processingTime = (Integer)ModConfig.PROCESSING.energizerWorkTicksBase.get();
        }
    }

    private static class Recipe
    extends FinishedSingleRecipe<EnergizerRecipeBuilder> {
        Recipe(ResourceLocation recipeID, EnergizerRecipeBuilder builder) {
            super(recipeID, builder, "crystal_energizer");
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)ModRecipes.Serializers.ENERGIZER.get();
        }
    }
}

