/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.recipe.builder;

import dev.rlnt.lazierae2.recipe.builder.base.FinishedMultiRecipe;
import dev.rlnt.lazierae2.recipe.builder.base.MultiRecipeBuilder;
import dev.rlnt.lazierae2.setup.ModConfig;
import dev.rlnt.lazierae2.setup.ModRecipes;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class AggregatorRecipeBuilder
extends MultiRecipeBuilder {
    private AggregatorRecipeBuilder(IItemProvider output, int outputCount) {
        super(output, outputCount);
    }

    public static AggregatorRecipeBuilder builder(IItemProvider output, int outputCount) {
        return new AggregatorRecipeBuilder(output, outputCount);
    }

    public AggregatorRecipeBuilder input(Ingredient input) {
        if (this.inputs.size() < 3) {
            this.inputs.add((Object)input);
        }
        return this;
    }

    public AggregatorRecipeBuilder input(ITag<Item> tag) {
        return this.input(Ingredient.func_199805_a(tag));
    }

    public AggregatorRecipeBuilder input(IItemProvider item) {
        return this.input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
    }

    public AggregatorRecipeBuilder processingTime(int ticks) {
        this.processingTime = ticks;
        return this;
    }

    @Override
    protected void build(Consumer<IFinishedRecipe> consumer, ResourceLocation recipeID) {
        consumer.accept(new Recipe(recipeID, this));
    }

    @Override
    protected String getId() {
        return "fluix_aggregator";
    }

    @Override
    protected void checkProcessingTime() {
        if (this.processingTime == 0) {
            this.processingTime = (Integer)ModConfig.PROCESSING.aggregatorWorkTicksBase.get();
        }
    }

    private static class Recipe
    extends FinishedMultiRecipe<AggregatorRecipeBuilder> {
        private Recipe(ResourceLocation recipeID, AggregatorRecipeBuilder builder) {
            super(recipeID, builder, "fluix_aggregator");
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)ModRecipes.Serializers.AGGREGATOR.get();
        }
    }
}

