/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.integration.jei.category.base;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.rlnt.lazierae2.recipe.type.base.AbstractRecipe;
import dev.rlnt.lazierae2.recipe.type.base.MultiRecipe;
import dev.rlnt.lazierae2.recipe.type.base.SingleRecipe;
import dev.rlnt.lazierae2.util.TextUtil;
import dev.rlnt.lazierae2.util.TypeEnums;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public abstract class ModRecipeCategory<R extends AbstractRecipe>
implements IRecipeCategory<R> {
    protected static final int ATLAS_HEIGHT = 166;
    protected final ResourceLocation texture;
    private final String localizedName;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated progressBar;

    protected ModRecipeCategory(IGuiHelper guiHelper, String id) {
        this.texture = new ResourceLocation("lazierae2", "textures/gui/" + id + ".png");
        this.localizedName = I18n.func_135052_a((String)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.JEI, id, new TextFormatting[0]).func_150268_i(), (Object[])new Object[0]);
        this.background = guiHelper.drawableBuilder(this.texture, this.getTextureOffsetU(), this.getTextureOffsetV(), this.getTextureWidth(), this.getTextureHeight()).setTextureSize(this.getAtlasWidth(), 166).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(this.getIconProvider()));
        IDrawableStatic progressBarTexture = guiHelper.drawableBuilder(this.texture, 178, 0, this.getProgressBarWidth(), this.getProgressBarHeight()).setTextureSize(this.getAtlasWidth(), 166).build();
        this.progressBar = guiHelper.createAnimatedDrawable(progressBarTexture, 60, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(R recipe, IIngredients ingredients) {
        ingredients.setOutput(VanillaTypes.ITEM, (Object)((AbstractRecipe)recipe).func_77571_b());
        if (recipe instanceof SingleRecipe) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)((SingleRecipe)recipe).getInput().func_193365_a()[0]);
        } else if (recipe instanceof MultiRecipe) {
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
            for (Ingredient input : ((MultiRecipe)recipe).getInputs()) {
                inputs.add(input.func_193365_a()[0]);
            }
            ingredients.setInputs(VanillaTypes.ITEM, inputs);
        }
    }

    public void draw(R recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.progressBar.draw(matrixStack, this.getProgressBarOffsetU(), this.getProgressBarOffsetV());
    }

    protected void initSlot(IGuiItemStackGroup itemStackGroup, int slotIndex, boolean input, int xPos, int yPos) {
        itemStackGroup.init(slotIndex, input, xPos - 1, yPos - 1);
    }

    protected abstract int getAtlasWidth();

    protected abstract int getTextureWidth();

    protected abstract int getTextureHeight();

    protected abstract int getTextureOffsetU();

    protected abstract int getTextureOffsetV();

    protected abstract int getProgressBarWidth();

    protected abstract int getProgressBarHeight();

    protected abstract int getProgressBarOffsetU();

    protected abstract int getProgressBarOffsetV();

    protected abstract IItemProvider getIconProvider();
}

