/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.integration.jei;

import dev.rlnt.lazierae2.container.AggregatorContainer;
import dev.rlnt.lazierae2.container.CentrifugeContainer;
import dev.rlnt.lazierae2.container.EnergizerContainer;
import dev.rlnt.lazierae2.container.EtcherContainer;
import dev.rlnt.lazierae2.integration.jei.category.AggregatorCategory;
import dev.rlnt.lazierae2.integration.jei.category.CentrifugeCategory;
import dev.rlnt.lazierae2.integration.jei.category.EnergizerCategory;
import dev.rlnt.lazierae2.integration.jei.category.EtcherCategory;
import dev.rlnt.lazierae2.screen.AggregatorScreen;
import dev.rlnt.lazierae2.screen.CentrifugeScreen;
import dev.rlnt.lazierae2.screen.EnergizerScreen;
import dev.rlnt.lazierae2.screen.EtcherScreen;
import dev.rlnt.lazierae2.setup.ModBlocks;
import dev.rlnt.lazierae2.setup.ModRecipes;
import dev.rlnt.lazierae2.util.GameUtil;
import java.util.Collection;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class ModJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("lazierae2", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new AggregatorCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CentrifugeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new EnergizerCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new EtcherCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = GameUtil.getRecipeManager(null);
        registration.addRecipes((Collection)recipeManager.func_241447_a_(ModRecipes.Types.AGGREGATOR), AggregatorCategory.UID);
        registration.addRecipes((Collection)recipeManager.func_241447_a_(ModRecipes.Types.CENTRIFUGE), CentrifugeCategory.UID);
        registration.addRecipes((Collection)recipeManager.func_241447_a_(ModRecipes.Types.ENERGIZER), EnergizerCategory.UID);
        registration.addRecipes((Collection)recipeManager.func_241447_a_(ModRecipes.Types.ETCHER), EtcherCategory.UID);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(AggregatorContainer.class, AggregatorCategory.UID, 2, 3, 5, 36);
        registration.addRecipeTransferHandler(CentrifugeContainer.class, CentrifugeCategory.UID, 2, 1, 3, 36);
        registration.addRecipeTransferHandler(EnergizerContainer.class, EnergizerCategory.UID, 2, 1, 3, 36);
        registration.addRecipeTransferHandler(EtcherContainer.class, EtcherCategory.UID, 2, 3, 5, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.AGGREGATOR.get()), new ResourceLocation[]{AggregatorCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.CENTRIFUGE.get()), new ResourceLocation[]{CentrifugeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.ENERGIZER.get()), new ResourceLocation[]{EnergizerCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.ETCHER.get()), new ResourceLocation[]{EtcherCategory.UID});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(AggregatorScreen.class, 84, 36, 24, 13, new ResourceLocation[]{AggregatorCategory.UID});
        registration.addRecipeClickArea(CentrifugeScreen.class, 80, 36, 22, 13, new ResourceLocation[]{CentrifugeCategory.UID});
        registration.addRecipeClickArea(EnergizerScreen.class, 81, 29, 22, 28, new ResourceLocation[]{EnergizerCategory.UID});
        registration.addRecipeClickArea(EtcherScreen.class, 84, 36, 22, 13, new ResourceLocation[]{EtcherCategory.UID});
    }
}

