/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.block.base;

import dev.rlnt.lazierae2.block.base.MachineBlock;
import dev.rlnt.lazierae2.screen.base.ProcessorScreen;
import dev.rlnt.lazierae2.tile.base.ProcessorTile;
import dev.rlnt.lazierae2.util.IOUtil;
import dev.rlnt.lazierae2.util.TextUtil;
import dev.rlnt.lazierae2.util.TypeEnums;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import org.apache.commons.lang3.ArrayUtils;

public abstract class ProcessorBlock
extends MachineBlock {
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;

    protected ProcessorBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(5.0f).harvestTool(ToolType.PICKAXE).func_200947_a(SoundType.field_185852_e).func_235838_a_(state -> ((Boolean)state.func_177229_b((Property)LIT)).equals(true) ? 5 : 0));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{LIT});
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        ProcessorTile tile;
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && (tile = (ProcessorTile)world.func_175625_s(pos)) != null) {
            if (nbt.func_74764_b("upgrade")) {
                tile.getItemHandler().setStackInSlot(0, ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("upgrade")));
            }
            tile.refreshEnergyCapacity();
            if (nbt.func_74764_b("energy")) {
                tile.getEnergyStorage().deserializeNBT(nbt.func_74775_l("energy"));
            }
            if (nbt.func_74764_b("io_config")) {
                tile.setSideConfig(IOUtil.getSideConfigFromArray(nbt.func_74759_k("io_config")));
            }
            if (nbt.func_74764_b("auto_extract")) {
                tile.toggleAutoExtract();
            }
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        ProcessorTile tile;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ProcessorTile && (tile = (ProcessorTile)world.func_175625_s(pos)) != null && !world.field_72995_K) {
            int[] dropSlots;
            Object itemHandler = tile.getItemHandler();
            int[] inputSlots = tile.getInputSlots();
            int[] outputSlots = new int[]{1};
            for (int slot : dropSlots = ArrayUtils.addAll((int[])inputSlots, (int[])outputSlots)) {
                ItemStack stack = itemHandler.getStackInSlot(slot);
                if (stack.func_190926_b()) continue;
                world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
            }
            if (!player.func_184812_l_()) {
                ItemStack blockStack = tile.getBlockItem();
                world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), blockStack));
            }
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT nbt = stack.func_77978_p();
        int upgrades = 0;
        int energy = 0;
        if (nbt != null) {
            if (nbt.func_74764_b("upgrade")) {
                upgrades = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("upgrade")).func_190916_E();
            }
            if (nbt.func_74764_b("energy")) {
                energy = nbt.func_74775_l("energy").func_74762_e("energy");
            }
        }
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "item_upgrade", TextFormatting.YELLOW).func_230529_a_((ITextComponent)TextUtil.colorize(String.format(" %s", upgrades), TextFormatting.WHITE)));
            tooltip.add((ITextComponent)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "item_energy", TextFormatting.YELLOW).func_230529_a_((ITextComponent)TextUtil.colorize(String.format(" %s", TextUtil.formatEnergy(energy, false)), TextFormatting.WHITE)));
        } else {
            tooltip.add((ITextComponent)ProcessorScreen.getDetailsTooltip());
        }
        super.func_190948_a(stack, world, tooltip, flagIn);
    }
}

