/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.util;

import com.yungnickyoung.minecraft.betterdungeons.util.BannerPattern;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.WallBannerBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.TranslationTextComponent;

public class Banner {
    private List<BannerPattern> patterns;
    private BlockState state;
    private CompoundNBT nbt;
    private boolean isWallBanner;

    public Banner(List<BannerPattern> _patterns, BlockState _state, CompoundNBT _nbt) {
        this.patterns = _patterns;
        this.state = _state;
        this.nbt = _nbt;
        this.isWallBanner = this.state.func_177230_c() instanceof WallBannerBlock;
    }

    public Banner(List<BannerPattern> _patterns, BlockState _state, CompoundNBT _nbt, boolean _isWallBanner) {
        this.patterns = _patterns;
        this.state = _state;
        this.nbt = _nbt;
        this.isWallBanner = _isWallBanner;
    }

    public List<BannerPattern> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(List<BannerPattern> patterns) {
        this.patterns = patterns;
    }

    public BlockState getState() {
        return this.state;
    }

    public void setState(BlockState state) {
        this.state = state;
    }

    public CompoundNBT getNbt() {
        return this.nbt;
    }

    public void setNbt(CompoundNBT nbt) {
        this.nbt = nbt;
    }

    public boolean isWallBanner() {
        return this.isWallBanner;
    }

    public void setWallBanner(boolean wallBanner) {
        this.isWallBanner = wallBanner;
    }

    public static class Builder {
        private final List<BannerPattern> patterns = new ArrayList<BannerPattern>();
        private TranslationTextComponent customNameTranslate;
        private String customColor;
        private BlockState state = Blocks.field_196873_hy.func_176223_P();

        public Builder blockState(BlockState state) {
            this.state = state;
            return this;
        }

        public Builder pattern(BannerPattern pattern) {
            this.patterns.add(pattern);
            return this;
        }

        public Builder pattern(String pattern, int color) {
            this.patterns.add(new BannerPattern(pattern, color));
            return this;
        }

        public Builder customName(String translatableNamePath) {
            this.customNameTranslate = new TranslationTextComponent(translatableNamePath);
            return this;
        }

        public Builder customColor(String colorString) {
            this.customColor = colorString;
            return this;
        }

        public Banner build() {
            CompoundNBT nbt = this.createBannerNBT();
            return new Banner(this.patterns, this.state, nbt);
        }

        private CompoundNBT createBannerNBT() {
            CompoundNBT nbt = new CompoundNBT();
            ListNBT patternList = new ListNBT();
            for (BannerPattern pattern : this.patterns) {
                CompoundNBT patternNBT = new CompoundNBT();
                patternNBT.func_74778_a("Pattern", pattern.getPattern());
                patternNBT.func_74768_a("Color", pattern.getColor());
                patternList.add((Object)patternNBT);
            }
            if (this.customColor != null || this.customNameTranslate != null) {
                String name;
                String color = this.customColor == null ? "" : String.format("\"color\":\"%s\"", this.customColor);
                String string = name = this.customNameTranslate == null ? "" : String.format("\"translate\":\"%s\"", this.customNameTranslate.func_150268_i());
                if (this.customColor != null && this.customNameTranslate != null) {
                    name = "," + name;
                }
                String customNameString = "{" + color + name + "}";
                nbt.func_74778_a("CustomName", customNameString);
            }
            nbt.func_218657_a("Patterns", (INBT)patternList);
            nbt.func_74778_a("id", "minecraft:banner");
            return nbt;
        }
    }
}

