/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.misc.BiomeSourceChecks;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.Lazy;

public class GenericJigsawStructure
extends AbstractBaseStructure<NoFeatureConfig> {
    protected final ResourceLocation startPool;
    protected final Lazy<Integer> structureSize;
    protected final int centerOffset;
    protected final int biomeRange;
    protected final int structureBlacklistRange;
    protected final Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet;
    protected final int allowTerrainHeightRange;
    protected final int terrainHeightRadius;
    protected final int minHeightLimit;
    protected int fixedYSpawn;
    protected boolean useHeightmap;
    protected boolean cannotSpawnInWater;

    public GenericJigsawStructure(ResourceLocation poolID, Lazy<Integer> structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet, int allowTerrainHeightRange, int terrainHeightRadius, int minHeightLimit, int fixedYSpawn, boolean useHeightmap, boolean cannotSpawnInWater) {
        super(NoFeatureConfig.field_236558_a_);
        this.startPool = poolID;
        this.structureSize = structureSize;
        this.centerOffset = centerOffset;
        this.biomeRange = biomeRange;
        this.structureBlacklistRange = structureBlacklistRange;
        this.avoidStructuresSet = avoidStructuresSet;
        this.allowTerrainHeightRange = allowTerrainHeightRange;
        this.terrainHeightRadius = terrainHeightRadius;
        this.minHeightLimit = minHeightLimit;
        this.fixedYSpawn = fixedYSpawn;
        this.useHeightmap = useHeightmap;
        this.cannotSpawnInWater = cannotSpawnInWater;
        RSStructures.RS_STRUCTURE_START_PIECES.add(this.startPool);
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig defaultFeatureConfig) {
        int curChunkZ;
        int curChunkX;
        if (!BiomeSourceChecks.isCheckeredBiomeSource(biomeSource) && !BiomeSourceChecks.isHexlandBiomeSource(biomeSource)) {
            for (curChunkX = chunkX - this.biomeRange; curChunkX <= chunkX + this.biomeRange; ++curChunkX) {
                for (curChunkZ = chunkZ - this.biomeRange; curChunkZ <= chunkZ + this.biomeRange; ++curChunkZ) {
                    if (biomeSource.func_225526_b_(curChunkX << 2, 64, curChunkZ << 2).func_242440_e().func_242493_a((Structure)this)) continue;
                    return false;
                }
            }
        }
        for (curChunkX = chunkX - this.structureBlacklistRange; curChunkX <= chunkX + this.structureBlacklistRange; ++curChunkX) {
            for (curChunkZ = chunkZ - this.structureBlacklistRange; curChunkZ <= chunkZ + this.structureBlacklistRange; ++curChunkZ) {
                for (RSStructureTagMap.STRUCTURE_TAGS tag : this.avoidStructuresSet) {
                    for (Structure<?> structureFeature : RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)tag)) {
                        StructureSeparationSettings structureConfig;
                        if (structureFeature == this || (structureConfig = chunkGenerator.func_235957_b_().func_236197_a_(structureFeature)) == null || structureConfig.func_236668_a_() <= 8) continue;
                        ChunkPos chunkPos2 = structureFeature.func_236392_a_(structureConfig, seed, chunkRandom, curChunkX, curChunkZ);
                        if (curChunkX != chunkPos2.field_77276_a || curChunkZ != chunkPos2.field_77275_b) continue;
                        return false;
                    }
                }
            }
        }
        if (this.allowTerrainHeightRange != -1) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            for (int curChunkX2 = chunkX - this.terrainHeightRadius; curChunkX2 <= chunkX + this.terrainHeightRadius; ++curChunkX2) {
                for (int curChunkZ2 = chunkZ - this.terrainHeightRadius; curChunkZ2 <= chunkZ + this.terrainHeightRadius; ++curChunkZ2) {
                    int height = chunkGenerator.func_222529_a(curChunkX2 * 16, curChunkZ2 * 16, Heightmap.Type.WORLD_SURFACE_WG);
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    if ((minTerrainHeight = Math.min(minTerrainHeight, height)) >= this.minHeightLimit) continue;
                    return false;
                }
            }
            return maxTerrainHeight - minTerrainHeight <= this.allowTerrainHeightRange;
        }
        if (this.cannotSpawnInWater) {
            BlockPos centerOfChunk = new BlockPos(chunkX * 16, 0, chunkZ * 16);
            int landHeight = chunkGenerator.func_222531_c(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
            IBlockReader columnOfBlocks = chunkGenerator.func_230348_a_(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p());
            BlockState topBlock = columnOfBlocks.func_180495_p(centerOfChunk.func_177981_b(landHeight));
            return topBlock.func_204520_s().func_206888_e();
        }
        return true;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new MainStart((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public static class Builder<T extends Builder<T>> {
        protected final ResourceLocation startPool;
        protected Lazy<Integer> structureSize = Lazy.of(() -> 1);
        protected int centerOffset = 0;
        protected int biomeRange = 0;
        protected int structureBlacklistRange = 0;
        protected Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet = new HashSet<RSStructureTagMap.STRUCTURE_TAGS>();
        protected int allowTerrainHeightRange = -1;
        protected int terrainHeightRadius = 0;
        protected int minHeightLimit = Integer.MIN_VALUE;
        protected int fixedYSpawn = 0;
        protected boolean useHeightmap = true;
        protected boolean cannotSpawnInWater = false;

        public Builder(ResourceLocation startPool) {
            this.startPool = startPool;
        }

        protected T getThis() {
            return (T)this;
        }

        public T setStructureSize(ForgeConfigSpec.IntValue structureSize) {
            this.structureSize = Lazy.of(() -> ((ForgeConfigSpec.IntValue)structureSize).get());
            return this.getThis();
        }

        public T setStructureSize(int structureSize) {
            this.structureSize = Lazy.of(() -> structureSize);
            return this.getThis();
        }

        public T setCenterOffset(int centerOffset) {
            this.centerOffset = centerOffset;
            return this.getThis();
        }

        public T setBiomeRange(int biomeRange) {
            this.biomeRange = biomeRange;
            return this.getThis();
        }

        public T setStructureBlacklistRange(int structureBlacklistRange) {
            this.structureBlacklistRange = structureBlacklistRange;
            return this.getThis();
        }

        public T setAvoidStructuresSet(Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet) {
            this.avoidStructuresSet = avoidStructuresSet;
            return this.getThis();
        }

        public T setAllowTerrainHeightRange(int allowTerrainHeightRange) {
            this.allowTerrainHeightRange = allowTerrainHeightRange;
            return this.getThis();
        }

        public T setTerrainHeightRadius(int terrainHeightRadius) {
            this.terrainHeightRadius = terrainHeightRadius;
            return this.getThis();
        }

        public T setMinHeightLimit(int minHeightLimit) {
            this.minHeightLimit = minHeightLimit;
            return this.getThis();
        }

        public T setFixedYSpawn(int fixedYSpawn) {
            this.fixedYSpawn = fixedYSpawn;
            return this.getThis();
        }

        public T doNotUseHeightmap() {
            this.useHeightmap = false;
            return this.getThis();
        }

        public T cannotSpawnInWater() {
            this.cannotSpawnInWater = true;
            return this.getThis();
        }

        public GenericJigsawStructure build() {
            return new GenericJigsawStructure(this.startPool, this.structureSize, this.centerOffset, this.biomeRange, this.structureBlacklistRange, this.avoidStructuresSet, this.allowTerrainHeightRange, this.terrainHeightRadius, this.minHeightLimit, this.fixedYSpawn, this.useHeightmap, this.cannotSpawnInWater);
        }
    }

    public class MainStart
    extends MarginedStructureStart<NoFeatureConfig> {
        private final ResourceLocation structureID;

        public MainStart(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox box, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, box, referenceIn, seedIn);
            this.structureID = Registry.field_218361_B.func_177774_c(structureIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig defaultFeatureConfig) {
            BlockPos blockpos = new BlockPos(chunkX * 16, GenericJigsawStructure.this.fixedYSpawn, chunkZ * 16);
            PieceLimitedJigsawManager.assembleJigsawStructure(dynamicRegistryManager, new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(GenericJigsawStructure.this.startPool), ((Integer)GenericJigsawStructure.this.structureSize.get()).intValue()), chunkGenerator, structureManager, blockpos, this.field_75075_a, (Random)this.field_214631_d, GenericJigsawStructure.this.useHeightmap, GenericJigsawStructure.this.useHeightmap, this.structureID, Integer.MAX_VALUE, Integer.MIN_VALUE);
            GeneralUtils.centerAllPieces(blockpos, this.field_75075_a);
            this.func_202500_a();
            ((StructurePiece)this.field_75075_a.get(0)).func_181138_a(0, GenericJigsawStructure.this.centerOffset, 0);
        }
    }
}

