/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.mixin.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.telepathicgrunt.repurposedstructures.mixin.datagen.LootPoolAccessor;
import java.lang.reflect.Type;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.RandomRanges;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={LootPool.Serializer.class})
public class LootPoolMixin {
    @Overwrite
    public JsonElement serialize(LootPool lootPool, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonobject = new JsonObject();
        LootPoolAccessor lootPoolAccessor = (LootPoolAccessor)lootPool;
        if (lootPoolAccessor.getName() != null && !lootPoolAccessor.getName().startsWith("custom#")) {
            jsonobject.add("name", jsonSerializationContext.serialize((Object)lootPoolAccessor.getName()));
        }
        jsonobject.add("rolls", RandomRanges.func_216131_a((IRandomRange)lootPoolAccessor.getRolls(), (JsonSerializationContext)jsonSerializationContext));
        if (lootPoolAccessor.getBonusRolls().func_186509_a() != 0.0f && lootPoolAccessor.getBonusRolls().func_186512_b() != 0.0f) {
            jsonobject.add("bonus_rolls", jsonSerializationContext.serialize((Object)lootPoolAccessor.getBonusRolls()));
        }
        jsonobject.add("entries", jsonSerializationContext.serialize(lootPoolAccessor.getEntries()));
        if (!lootPoolAccessor.getConditions().isEmpty()) {
            jsonobject.add("conditions", jsonSerializationContext.serialize(lootPoolAccessor.getConditions()));
        }
        if (!ArrayUtils.isEmpty((Object[])lootPoolAccessor.getFunctions())) {
            jsonobject.add("functions", jsonSerializationContext.serialize((Object)lootPoolAccessor.getFunctions()));
        }
        return jsonobject;
    }
}

