/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.biomeinjection;

import com.telepathicgrunt.repurposedstructures.configs.RSWellsConfig;
import com.telepathicgrunt.repurposedstructures.modinit.RSConfiguredFeatures;
import com.telepathicgrunt.repurposedstructures.utils.BiomeSelection;
import java.util.function.Supplier;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public final class Wells {
    private Wells() {
    }

    public static void addWells(BiomeLoadingEvent event) {
        if ((Integer)RSWellsConfig.wellBadlandsRarityPerChunk.get() != 10000 && Wells.genericWellCheck(event, RSConfiguredFeatures.BADLANDS_WELL, () -> BiomeSelection.haveCategories(event, Biome.Category.MESA))) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.SURFACE_STRUCTURES).add(() -> RSConfiguredFeatures.BADLANDS_WELL);
        }
        if ((Integer)RSWellsConfig.wellNetherRarityPerChunk.get() != 10000 && Wells.genericWellCheck(event, RSConfiguredFeatures.NETHER_WELL, () -> BiomeSelection.haveCategories(event, Biome.Category.NETHER))) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.SURFACE_STRUCTURES).add(() -> RSConfiguredFeatures.NETHER_WELL);
        }
        if ((Integer)RSWellsConfig.wellSnowRarityPerChunk.get() != 10000 && Wells.genericWellCheck(event, RSConfiguredFeatures.SNOW_WELL, () -> BiomeSelection.haveCategories(event, Biome.Category.ICY) || BiomeSelection.hasName(event, "snow"))) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.SURFACE_STRUCTURES).add(() -> RSConfiguredFeatures.SNOW_WELL);
        }
        if ((Integer)RSWellsConfig.wellMossyStoneRarityPerChunk.get() != 10000 && Wells.genericWellCheck(event, RSConfiguredFeatures.MOSSY_STONE_WELL, () -> BiomeSelection.haveCategories(event, Biome.Category.SWAMP, Biome.Category.JUNGLE) || BiomeSelection.haveCategories(event, Biome.Category.FOREST) && BiomeSelection.hasName(event, "dark", "spooky", "dead", "haunted"))) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.SURFACE_STRUCTURES).add(() -> RSConfiguredFeatures.MOSSY_STONE_WELL);
        }
        if ((Integer)RSWellsConfig.wellForestRarityPerChunk.get() != 10000 && Wells.genericWellCheck(event, RSConfiguredFeatures.FOREST_WELL, () -> BiomeSelection.haveCategories(event, Biome.Category.FOREST) && !BiomeSelection.hasName(event, "dark", "spooky", "dead", "haunted"))) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.SURFACE_STRUCTURES).add(() -> RSConfiguredFeatures.FOREST_WELL);
        }
        if ((Integer)RSWellsConfig.wellMushroomRarityPerChunk.get() != 10000 && Wells.genericWellCheck(event, RSConfiguredFeatures.MUSHROOM_WELL, () -> BiomeSelection.haveCategories(event, Biome.Category.MUSHROOM))) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.SURFACE_STRUCTURES).add(() -> RSConfiguredFeatures.MUSHROOM_WELL);
        }
    }

    private static boolean genericWellCheck(BiomeLoadingEvent context, ConfiguredFeature<?, ?> configuredFeature, Supplier<Boolean> condition) {
        return BiomeSelection.isBiomeAllowed(context, configuredFeature, () -> RSConfiguredFeatures.RS_WELLS.stream().noneMatch(cf -> BiomeSelection.hasFeature(context, cf)) && (Boolean)condition.get() != false);
    }
}

