/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.tunnels;

import com.robotgryphon.compactmachines.api.tunnels.EnumTunnelSide;
import com.robotgryphon.compactmachines.api.tunnels.ITunnelConnectionInfo;
import com.robotgryphon.compactmachines.block.tiles.TunnelWallTile;
import com.robotgryphon.compactmachines.teleportation.DimensionalPosition;
import com.robotgryphon.compactmachines.tunnels.TunnelHelper;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.world.IWorldReader;

public class TunnelConnectionInfo
implements ITunnelConnectionInfo {
    private TunnelWallTile tunnel;

    TunnelConnectionInfo(TunnelWallTile tile) {
        this.tunnel = tile;
    }

    @Override
    @Nonnull
    public Optional<DimensionalPosition> getConnectedPosition(EnumTunnelSide side) {
        return TunnelHelper.getTunnelConnectedPosition(this.tunnel, side);
    }

    @Override
    public Optional<BlockState> getConnectedState(EnumTunnelSide side) {
        return TunnelHelper.getConnectedState(this.tunnel, side);
    }

    @Override
    public Optional<? extends IWorldReader> getConnectedWorld(EnumTunnelSide side) {
        switch (side) {
            case INSIDE: {
                return Optional.ofNullable(this.tunnel.func_145831_w());
            }
            case OUTSIDE: {
                return this.tunnel.getConnectedWorld();
            }
        }
        return Optional.empty();
    }

    @Override
    public Direction getConnectedSide(EnumTunnelSide side) {
        switch (side) {
            case INSIDE: {
                return this.tunnel.getTunnelSide();
            }
            case OUTSIDE: {
                return this.tunnel.getConnectedSide();
            }
        }
        return Direction.UP;
    }
}

