/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.teleportation;

import com.robotgryphon.compactmachines.data.NbtDataUtil;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.INBTSerializable;

public class DimensionalPosition
implements INBTSerializable<CompoundNBT> {
    private RegistryKey<World> dimension;
    private Vector3d position;

    private DimensionalPosition() {
    }

    public DimensionalPosition(RegistryKey<World> dim, Vector3d pos) {
        this.dimension = dim;
        this.position = pos;
    }

    public DimensionalPosition(RegistryKey<World> world, BlockPos positionBlock) {
        this.dimension = world;
        this.position = new Vector3d((double)positionBlock.func_177958_n(), (double)positionBlock.func_177956_o(), (double)positionBlock.func_177952_p());
    }

    public Optional<ServerWorld> getWorld(@Nonnull MinecraftServer server) {
        return Optional.ofNullable(server.func_71218_a(this.dimension));
    }

    public static DimensionalPosition fromNBT(CompoundNBT nbt) {
        DimensionalPosition dp = new DimensionalPosition();
        dp.deserializeNBT(nbt);
        return dp;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("dim", this.dimension.func_240901_a_().toString());
        CompoundNBT posNbt = NbtDataUtil.writeVectorCompound(this.position);
        nbt.func_218657_a("pos", (INBT)posNbt);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("dim")) {
            ResourceLocation dim = new ResourceLocation(nbt.func_74779_i("dim"));
            this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dim);
        }
        if (nbt.func_74764_b("pos")) {
            Vector3d bPos;
            CompoundNBT bPosNbt = nbt.func_74775_l("pos");
            this.position = bPos = NbtDataUtil.readVectorCompound(bPosNbt);
        }
    }

    public RegistryKey<World> getDimension() {
        return this.dimension;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public BlockPos getBlockPosition() {
        return new BlockPos(this.position.field_72450_a, this.position.field_72448_b, this.position.field_72449_c);
    }

    public String toString() {
        return "DimensionalPosition{dimension=" + this.dimension + ", position=" + this.position + '}';
    }
}

