/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.network;

import com.robotgryphon.compactmachines.client.ClientTunnelHandler;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class TunnelAddedPacket {
    private BlockPos position;
    private ResourceLocation type;

    private TunnelAddedPacket() {
    }

    public TunnelAddedPacket(BlockPos tunnelPos, ResourceLocation tunnelType) {
        this.position = tunnelPos;
        this.type = tunnelType;
    }

    public static void handle(TunnelAddedPacket message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientTunnelHandler.updateTunnelData(message.position, message.type);
            return null;
        }));
        ctx.setPacketHandled(true);
    }

    public static void encode(TunnelAddedPacket pkt, PacketBuffer buf) {
        buf.func_179255_a(pkt.position);
        buf.func_192572_a(pkt.type);
    }

    public static TunnelAddedPacket decode(PacketBuffer buf) {
        TunnelAddedPacket pkt = new TunnelAddedPacket();
        pkt.position = buf.func_179259_c();
        pkt.type = buf.func_192575_l();
        return pkt;
    }
}

