/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.data.machines;

import com.robotgryphon.compactmachines.data.machines.CompactMachineBaseData;
import com.robotgryphon.compactmachines.reference.EnumMachineSize;
import com.robotgryphon.compactmachines.teleportation.DimensionalPosition;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CompactMachineRegistrationData
extends CompactMachineBaseData {
    private BlockPos center;
    private BlockPos spawnPoint;
    private UUID owner;
    private EnumMachineSize size;
    private boolean inPlayerInventory;
    private UUID playerUUID;
    private DimensionalPosition outsidePosition;

    private CompactMachineRegistrationData() {
        super(0);
    }

    public CompactMachineRegistrationData(int id, BlockPos center, UUID owner, EnumMachineSize size) {
        super(id);
        this.center = center;
        this.owner = owner;
        this.size = size;
    }

    public static CompactMachineRegistrationData fromNBT(INBT machine) {
        if (machine instanceof CompoundNBT) {
            CompactMachineRegistrationData d = new CompactMachineRegistrationData();
            d.deserializeNBT((CompoundNBT)machine);
            return d;
        }
        return null;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        CompoundNBT centerNbt = NBTUtil.func_186859_a((BlockPos)this.center);
        nbt.func_218657_a("center", (INBT)centerNbt);
        if (this.spawnPoint != null) {
            CompoundNBT spawnNbt = NBTUtil.func_186859_a((BlockPos)this.spawnPoint);
            nbt.func_218657_a("spawn", (INBT)spawnNbt);
        }
        IntArrayNBT ownerNbt = NBTUtil.func_240626_a_((UUID)this.owner);
        nbt.func_218657_a("owner", (INBT)ownerNbt);
        if (this.outsidePosition != null) {
            CompoundNBT pos = this.outsidePosition.serializeNBT();
            nbt.func_218657_a("outside", (INBT)pos);
        }
        nbt.func_74778_a("size", this.size.getName());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        INBT ownerNbt;
        super.deserializeNBT(nbt);
        if (nbt.func_74764_b("size")) {
            this.size = EnumMachineSize.getFromSize(nbt.func_74779_i("size"));
        }
        if (nbt.func_74764_b("owner") && (ownerNbt = nbt.func_74781_a("owner")) != null) {
            this.owner = NBTUtil.func_186860_b((INBT)ownerNbt);
        }
        if (nbt.func_74764_b("center")) {
            this.center = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("center"));
        }
        if (nbt.func_74764_b("spawn")) {
            this.spawnPoint = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("spawn"));
        }
        if (nbt.func_74764_b("outside")) {
            this.outsidePosition = DimensionalPosition.fromNBT(nbt.func_74775_l("outside"));
        }
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public Optional<BlockPos> getSpawnPoint() {
        return Optional.ofNullable(this.spawnPoint);
    }

    public UUID getOwner() {
        return this.owner;
    }

    public EnumMachineSize getSize() {
        return this.size;
    }

    public void setSpawnPoint(BlockPos position) {
        this.spawnPoint = position;
    }

    public DimensionalPosition getOutsidePosition(MinecraftServer server) {
        if (this.inPlayerInventory) {
            ServerPlayerEntity player = server.func_184103_al().func_177451_a(this.playerUUID);
            Vector3d positionVec = player.func_213303_ch();
            RegistryKey dimensionKey = player.field_70170_p.func_234923_W_();
            return new DimensionalPosition((RegistryKey<World>)dimensionKey, positionVec);
        }
        return this.outsidePosition;
    }

    public boolean isPlacedInWorld() {
        return !this.inPlayerInventory;
    }

    public void setWorldPosition(ServerWorld world, BlockPos pos) {
        this.outsidePosition = new DimensionalPosition((RegistryKey<World>)world.func_234923_W_(), new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
    }

    public void addToPlayerInventory(UUID player) {
        this.playerUUID = player;
        this.inPlayerInventory = true;
        this.outsidePosition = null;
    }

    public void removeFromPlayerInventory() {
        this.playerUUID = null;
        this.inPlayerInventory = false;
    }
}

