/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.data.machines;

import com.robotgryphon.compactmachines.data.NbtListCollector;
import com.robotgryphon.compactmachines.data.machines.CompactMachineBaseData;
import com.robotgryphon.compactmachines.teleportation.DimensionalPosition;
import com.robotgryphon.compactmachines.util.PlayerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;

public class CompactMachinePlayerData
extends CompactMachineBaseData {
    private HashSet<UUID> internalPlayers = new HashSet(0);
    private HashMap<UUID, DimensionalPosition> externalSpawns = new HashMap(0);

    protected CompactMachinePlayerData() {
    }

    public CompactMachinePlayerData(int id) {
        super(id);
    }

    public static CompactMachinePlayerData fromNBT(INBT nbt) {
        if (nbt instanceof CompoundNBT) {
            Optional<Integer> id = CompactMachinePlayerData.getIdFromNbt(nbt);
            return id.map(i -> {
                CompactMachinePlayerData d = new CompactMachinePlayerData((int)i);
                d.deserializeNBT((CompoundNBT)nbt);
                return d;
            }).orElse(null);
        }
        return null;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        ListNBT ids = this.internalPlayers.stream().map(u -> {
            IntArrayNBT intNBTS = NBTUtil.func_240626_a_((UUID)u);
            CompoundNBT pnbt = new CompoundNBT();
            pnbt.func_218657_a("id", (INBT)intNBTS);
            return pnbt;
        }).collect(NbtListCollector.toNbtList());
        nbt.func_218657_a("players", (INBT)ids);
        ListNBT spawns = this.externalSpawns.entrySet().stream().map(pSpawn -> {
            CompoundNBT spawn = new CompoundNBT();
            UUID playerId = (UUID)pSpawn.getKey();
            DimensionalPosition pSpawnPos = (DimensionalPosition)pSpawn.getValue();
            spawn.func_218657_a("id", (INBT)NBTUtil.func_240626_a_((UUID)playerId));
            spawn.func_218657_a("spawn", (INBT)pSpawnPos.serializeNBT());
            return spawn;
        }).collect(NbtListCollector.toNbtList());
        nbt.func_218657_a("spawns", (INBT)spawns);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        if (nbt.func_74764_b("players")) {
            ListNBT players = nbt.func_150295_c("players", 10);
            players.forEach(playerData -> {
                CompoundNBT pd = (CompoundNBT)playerData;
                UUID id = pd.func_186857_a("id");
                this.internalPlayers.add(id);
            });
        }
        if (nbt.func_74764_b("spawns")) {
            ListNBT spawns = nbt.func_150295_c("spawns", 10);
            spawns.forEach(spawnData -> {
                CompoundNBT spawn = (CompoundNBT)spawnData;
                UUID playerId = spawn.func_186857_a("id");
                DimensionalPosition pos = DimensionalPosition.fromNBT(spawn.func_74775_l("spawn"));
                this.externalSpawns.put(playerId, pos);
            });
        }
    }

    public boolean hasPlayers() {
        return !this.internalPlayers.isEmpty();
    }

    public void addPlayer(UUID playerID) {
        if (!this.internalPlayers.contains(playerID)) {
            this.internalPlayers.add(playerID);
        }
    }

    public void addPlayer(ServerPlayerEntity serverPlayer) {
        UUID playerUUID = serverPlayer.func_146103_bH().getId();
        this.addPlayer(playerUUID);
        if (!this.externalSpawns.containsKey(playerUUID)) {
            DimensionalPosition pos = PlayerUtil.getPlayerDimensionalPosition((PlayerEntity)serverPlayer);
            this.externalSpawns.put(playerUUID, pos);
        }
    }

    public void removePlayer(UUID playerID) {
        if (this.internalPlayers.contains(playerID)) {
            this.internalPlayers.remove(playerID);
            this.externalSpawns.remove(playerID);
        }
    }

    public void removePlayer(ServerPlayerEntity serverPlayer) {
        UUID playerUUID = serverPlayer.func_146103_bH().getId();
        this.removePlayer(playerUUID);
    }

    public Optional<DimensionalPosition> getExternalSpawn(ServerPlayerEntity serverPlayer) {
        UUID playerUUID = serverPlayer.func_146103_bH().getId();
        if (!this.internalPlayers.contains(playerUUID)) {
            return Optional.empty();
        }
        if (!this.externalSpawns.containsKey(playerUUID)) {
            return Optional.empty();
        }
        return Optional.of(this.externalSpawns.get(playerUUID));
    }
}

