/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.block.tiles;

import com.robotgryphon.compactmachines.api.tunnels.ICapableTunnel;
import com.robotgryphon.compactmachines.api.tunnels.TunnelDefinition;
import com.robotgryphon.compactmachines.block.walls.TunnelWallBlock;
import com.robotgryphon.compactmachines.core.Registration;
import com.robotgryphon.compactmachines.data.machines.CompactMachineRegistrationData;
import com.robotgryphon.compactmachines.network.NetworkHandler;
import com.robotgryphon.compactmachines.network.TunnelAddedPacket;
import com.robotgryphon.compactmachines.teleportation.DimensionalPosition;
import com.robotgryphon.compactmachines.util.CompactMachineUtil;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.network.PacketDistributor;

public class TunnelWallTile
extends TileEntity {
    private ResourceLocation tunnelType;

    public TunnelWallTile() {
        super((TileEntityType)Registration.TUNNEL_WALL_TILE.get());
    }

    public Optional<CompactMachineRegistrationData> getMachineInfo() {
        if (this.field_145850_b instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
            return CompactMachineUtil.getMachineInfoByInternalPosition(serverWorld, this.field_174879_c);
        }
        return Optional.empty();
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_74764_b("tunnel_type")) {
            ResourceLocation type;
            this.tunnelType = type = new ResourceLocation(nbt.func_74779_i("tunnel_type"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        compound.func_74778_a("tunnel_type", this.tunnelType.toString());
        return compound;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_74778_a("tunnel_type", this.tunnelType.toString());
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        if (tag.func_74764_b("tunnel_type")) {
            this.tunnelType = new ResourceLocation(tag.func_74779_i("tunnel_type"));
        }
    }

    public Optional<? extends IWorldReader> getConnectedWorld() {
        if (this.field_145850_b == null || this.field_145850_b.func_201670_d()) {
            return Optional.empty();
        }
        ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
        Optional<CompactMachineRegistrationData> machineInfo = this.getMachineInfo();
        if (!machineInfo.isPresent()) {
            return Optional.empty();
        }
        Direction outsideDir = this.getConnectedSide();
        CompactMachineRegistrationData regData = machineInfo.get();
        if (!regData.isPlacedInWorld()) {
            return Optional.empty();
        }
        DimensionalPosition machinePosition = regData.getOutsidePosition(serverWorld.func_73046_m());
        if (machinePosition != null) {
            return machinePosition.getWorld(serverWorld.func_73046_m());
        }
        return Optional.empty();
    }

    public Optional<DimensionalPosition> getConnectedPosition() {
        if (this.field_145850_b == null || this.field_145850_b.func_201670_d()) {
            return Optional.empty();
        }
        ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
        Optional<CompactMachineRegistrationData> machineInfo = this.getMachineInfo();
        if (!machineInfo.isPresent()) {
            return Optional.empty();
        }
        Direction outsideDir = this.getConnectedSide();
        CompactMachineRegistrationData regData = machineInfo.get();
        if (!regData.isPlacedInWorld()) {
            return Optional.empty();
        }
        DimensionalPosition machinePosition = regData.getOutsidePosition(serverWorld.func_73046_m());
        if (machinePosition != null) {
            Vector3d o = machinePosition.getPosition();
            BlockPos machineOutPos = new BlockPos(o.field_72450_a, o.field_72448_b, o.field_72449_c);
            BlockPos connectedBlock = machineOutPos.func_177972_a(outsideDir);
            Vector3d connectedBlockVec = new Vector3d((double)connectedBlock.func_177958_n(), (double)connectedBlock.func_177956_o(), (double)connectedBlock.func_177952_p());
            DimensionalPosition connectedPosition = new DimensionalPosition(machinePosition.getDimension(), connectedBlockVec);
            return Optional.of(connectedPosition);
        }
        return Optional.empty();
    }

    public Direction getTunnelSide() {
        BlockState state = this.func_195044_w();
        return (Direction)state.func_177229_b((Property)TunnelWallBlock.TUNNEL_SIDE);
    }

    public Direction getConnectedSide() {
        BlockState blockState = this.func_195044_w();
        return (Direction)blockState.func_177229_b((Property)TunnelWallBlock.CONNECTED_SIDE);
    }

    public Optional<ResourceLocation> getTunnelDefinitionId() {
        return Optional.ofNullable(this.tunnelType);
    }

    public Optional<TunnelDefinition> getTunnelDefinition() {
        if (this.tunnelType == null) {
            return Optional.empty();
        }
        TunnelDefinition definition = (TunnelDefinition)GameRegistry.findRegistry(TunnelDefinition.class).getValue(this.tunnelType);
        return Optional.ofNullable(definition);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        Direction tunnelInDir = this.getConnectedSide();
        Optional<TunnelDefinition> tunnelDef = this.getTunnelDefinition();
        if (!tunnelDef.isPresent()) {
            return super.getCapability(cap, side);
        }
        TunnelDefinition definition = tunnelDef.get();
        if (definition instanceof ICapableTunnel && !this.field_145850_b.func_201670_d()) {
            ServerWorld sw = (ServerWorld)this.field_145850_b;
            return ((ICapableTunnel)((Object)definition)).getExternalCapability(sw, this.field_174879_c, cap, side);
        }
        return super.getCapability(cap, side);
    }

    public void setTunnelType(ResourceLocation registryName) {
        this.tunnelType = registryName;
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d()) {
            this.func_70296_d();
            TunnelAddedPacket pkt = new TunnelAddedPacket(this.field_174879_c, registryName);
            Chunk chunkAt = this.field_145850_b.func_175726_f(this.field_174879_c);
            NetworkHandler.MAIN_CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunkAt), (Object)pkt);
        }
    }
}

