/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.registration;

import com.thenatekirby.babel.api.IBlockProvider;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;

public class DeferredBlock<T extends Block>
implements IItemProvider,
IBlockProvider {
    private final String name;
    private final RegistryObject<T> block;
    private final RegistryObject<Item> item;

    private DeferredBlock(String name, Supplier<T> blockSupplier, @Nullable Item.Properties properties, DeferredRegister<Block> blockRegister, DeferredRegister<Item> itemRegister) {
        this.name = name;
        this.block = blockRegister.register(name, blockSupplier);
        this.item = properties != null ? itemRegister.register(name, () -> new BlockItem((Block)this.block.get(), properties)) : null;
    }

    public static <T extends Block> DeferredBlock<T> create(String name, Supplier<T> blockSupplier, Item.Properties itemProperties, DeferredRegister<Block> blockRegister, DeferredRegister<Item> itemRegister) {
        return new DeferredBlock<T>(name, blockSupplier, itemProperties, blockRegister, itemRegister);
    }

    public static <T extends Block> DeferredBlock<T> createHidden(String name, Supplier<T> blockSupplier, DeferredRegister<Block> blockRegister, DeferredRegister<Item> itemRegister) {
        return new DeferredBlock<T>(name, blockSupplier, null, blockRegister, itemRegister);
    }

    public String getName() {
        return this.name;
    }

    @Nonnull
    public T asBlock() {
        return (T)((Block)this.block.get());
    }

    @Nonnull
    public Item func_199767_j() {
        return (Item)this.item.get();
    }
}

