/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.integration.mekanism;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.thenatekirby.babel.condition.IRecipeCondition;
import com.thenatekirby.babel.condition.ModLoadedCondition;
import com.thenatekirby.babel.integration.Mods;
import com.thenatekirby.babel.recipe.IExternalRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class MekanismEnrichingRecipeBuilder {
    private final ResourceLocation recipeId;
    private String input;
    private String output;
    private int count;
    private List<JsonObject> conditions = new ArrayList<JsonObject>();

    private MekanismEnrichingRecipeBuilder(@Nonnull ResourceLocation recipeId) {
        this.recipeId = recipeId;
        this.conditions.add(new ModLoadedCondition("mekanism").serializeJson());
    }

    public static MekanismEnrichingRecipeBuilder builder(@Nonnull ResourceLocation recipeId) {
        return new MekanismEnrichingRecipeBuilder(recipeId);
    }

    public MekanismEnrichingRecipeBuilder withInput(@Nonnull String input) {
        this.input = input;
        return this;
    }

    public MekanismEnrichingRecipeBuilder withOutput(@Nonnull ItemStack output) {
        this.output = output.func_77973_b().getRegistryName().toString();
        this.count = output.func_190916_E();
        return this;
    }

    public MekanismEnrichingRecipeBuilder withOutput(@Nonnull String id, int count) {
        this.output = id;
        this.count = count;
        return this;
    }

    public MekanismEnrichingRecipeBuilder withCondition(@Nonnull IRecipeCondition condition) {
        this.conditions.add(condition.serializeJson());
        return this;
    }

    public void build(Consumer<IExternalRecipe> consumer) {
        consumer.accept(new Result(this.recipeId, this.input, this.output, this.count, this.conditions));
    }

    public static class Result
    implements IExternalRecipe {
        private final ResourceLocation recipeId;
        private final String output;
        private final int count;
        private final String input;
        private final List<JsonObject> conditions;

        Result(@Nonnull ResourceLocation recipeId, @Nonnull String input, @Nonnull String output, int count, @Nonnull List<JsonObject> conditions) {
            this.recipeId = recipeId;
            this.input = input;
            this.output = output;
            this.count = count;
            this.conditions = conditions;
        }

        @Override
        public void serialize(@Nonnull JsonObject json) {
            if (!this.conditions.isEmpty()) {
                JsonArray conditions = new JsonArray();
                for (JsonObject condition : this.conditions) {
                    conditions.add((JsonElement)condition);
                }
                json.add("conditions", (JsonElement)conditions);
            }
            JsonObject inputJson = new JsonObject();
            JsonObject ingredientJson = new JsonObject();
            ingredientJson.addProperty("item", this.input);
            inputJson.add("ingredient", (JsonElement)ingredientJson);
            json.add("input", (JsonElement)inputJson);
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", this.output);
            if (this.count > 1) {
                resultJson.addProperty("count", (Number)this.count);
            }
            json.add("output", (JsonElement)resultJson);
        }

        @Override
        @Nonnull
        public ResourceLocation getId() {
            return this.recipeId;
        }

        @Override
        @Nonnull
        public ResourceLocation getType() {
            return Mods.MEKANISM.withPath("enriching");
        }
    }
}

