/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.core.slots;

import com.thenatekirby.babel.core.slots.ItemStackValidators;
import com.thenatekirby.babel.util.ItemStackUtil;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.items.IItemHandler;

public class ItemSlot
implements IItemHandler {
    @Nonnull
    private ItemStack itemStack = ItemStack.field_190927_a;
    private final Predicate<ItemStack> validator;
    private boolean enabled = true;
    private final int posX;
    private final int posY;
    private IOnSlotChangedListener listener;

    public ItemSlot(int posX, int posY) {
        this(posX, posY, ItemStackValidators.ALL);
    }

    public ItemSlot(int posX, int posY, Predicate<ItemStack> validator) {
        this.posX = posX;
        this.posY = posY;
        this.validator = validator;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setListener(IOnSlotChangedListener listener) {
        this.listener = listener;
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.itemStack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack insertStack, boolean simulate) {
        if (!this.enabled || insertStack.func_190926_b() || !this.validator.test(insertStack)) {
            return insertStack;
        }
        if (this.itemStack.func_190926_b()) {
            if (!simulate) {
                this.setItemStack(insertStack);
                this.onSlotChanged();
            }
            return ItemStack.field_190927_a;
        }
        if (ItemStackUtil.areItemStacksAndTagsEqual(this.itemStack, insertStack)) {
            int maxCapacity;
            int count = this.itemStack.func_190916_E() + insertStack.func_190916_E();
            if (count <= (maxCapacity = this.getSlotLimit(0))) {
                if (!simulate) {
                    this.itemStack.func_190920_e(count);
                    this.onSlotChanged();
                }
                return ItemStack.field_190927_a;
            }
            if (!simulate) {
                this.itemStack.func_190920_e(maxCapacity);
                this.onSlotChanged();
            }
            return ItemStackUtil.itemStackWithSize(insertStack, count - maxCapacity);
        }
        return insertStack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.enabled) {
            return ItemStack.field_190927_a;
        }
        int extracted = Math.min(this.itemStack.func_190916_E(), amount);
        ItemStack extractedStack = ItemStackUtil.itemStackWithSize(this.itemStack, extracted);
        if (!simulate) {
            this.itemStack.func_190918_g(extracted);
            if (this.itemStack.func_190926_b()) {
                this.setItemStack(ItemStack.field_190927_a);
            }
            this.onSlotChanged();
        }
        return extractedStack;
    }

    public int getSlotLimit(int slot) {
        return this.itemStack.func_77976_d();
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.enabled && this.validator.test(stack);
    }

    public void setItemStack(@Nonnull ItemStack itemStack) {
        if (this.itemStack.func_77973_b() != itemStack.func_77973_b() || this.itemStack.func_190916_E() != itemStack.func_190916_E()) {
            this.itemStack = itemStack;
            this.onSlotChanged();
        }
    }

    @Nonnull
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private void onSlotChanged() {
        if (this.listener != null) {
            this.listener.onSlotChanged(this);
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        this.itemStack.func_77955_b(nbt);
        return nbt;
    }

    public void deserializeNBT(@Nonnull CompoundNBT nbt) {
        this.itemStack = ItemStack.func_199557_a((CompoundNBT)nbt);
    }

    public static interface IOnSlotChangedListener {
        public void onSlotChanged(ItemSlot var1);
    }
}

