/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.core.energy;

import com.thenatekirby.babel.api.IProgress;
import com.thenatekirby.babel.core.energy.EnergyBuffer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;

public class BabelEnergyStorage
implements IEnergyStorage,
INBTSerializable<CompoundNBT>,
IProgress {
    private int capacity;
    private int maxReceive;
    private int maxExtract;
    private int energyStored;
    private IEnergyStorageChangedObserver energyChangedObserver;

    public BabelEnergyStorage(int capacity, int maxReceive, int maxExtract, int current) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.energyStored = current;
    }

    public BabelEnergyStorage(EnergyBuffer buffer) {
        this.capacity = buffer.capacity;
        this.maxReceive = buffer.maxReceive;
        this.maxExtract = buffer.maxExtract;
        this.energyStored = buffer.current;
    }

    private void onEnergyChanged() {
        if (this.energyChangedObserver != null) {
            this.energyChangedObserver.onEnergyChanged(this);
        }
    }

    public void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
    }

    public void setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setEnergyStored(int energyStored) {
        this.energyStored = energyStored;
        this.onEnergyChanged();
    }

    public void setEnergyChangedObserver(IEnergyStorageChangedObserver energyChangedObserver) {
        this.energyChangedObserver = energyChangedObserver;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int received = Math.min(this.capacity - this.energyStored, Math.min(maxReceive, this.maxReceive));
        if (!simulate) {
            this.energyStored += received;
            this.onEnergyChanged();
        }
        return received;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int extracted = Math.min(this.energyStored, Math.min(maxExtract, this.maxExtract));
        if (!simulate) {
            this.energyStored -= extracted;
            this.onEnergyChanged();
        }
        return extracted;
    }

    public int getEnergyStored() {
        return this.energyStored;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    public boolean canReceive() {
        return this.maxReceive > 0;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("energyStored", this.energyStored);
        nbt.func_74768_a("capacity", this.capacity);
        nbt.func_74768_a("maxExtract", this.maxExtract);
        nbt.func_74768_a("maxReceive", this.maxReceive);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setEnergyStored(nbt.func_74762_e("energyStored"));
        this.setCapacity(nbt.func_74762_e("capacity"));
        this.setMaxExtract(nbt.func_74762_e("maxExtract"));
        this.setMaxReceive(nbt.func_74762_e("maxReceive"));
    }

    public void write(@Nonnull PacketBuffer buffer) {
        buffer.writeInt(this.getEnergyStored());
    }

    public void read(@Nonnull PacketBuffer buffer) {
        this.setEnergyStored(buffer.readInt());
    }

    @Override
    public int getProgressMin() {
        return 0;
    }

    @Override
    public int getProgressMax() {
        return this.capacity;
    }

    @Override
    public int getProgressCurrent() {
        return this.energyStored;
    }

    public static interface IEnergyStorageChangedObserver {
        public void onEnergyChanged(BabelEnergyStorage var1);
    }
}

