/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.core;

import javax.annotation.Nonnull;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class RecipeOutput {
    private boolean tag;
    private String resultId;
    private int count;
    private float chance = 1.0f;

    private RecipeOutput(boolean tag, String resultId, int count) {
        this.tag = tag;
        this.resultId = resultId;
        this.count = count;
    }

    public RecipeOutput withChance(float chance) {
        this.chance = chance;
        return this;
    }

    public static RecipeOutput fromTag(@Nonnull String resultId) {
        return new RecipeOutput(true, resultId, 1);
    }

    public static RecipeOutput fromTag(@Nonnull String resultId, int count) {
        return new RecipeOutput(true, resultId, count);
    }

    public static RecipeOutput fromTag(@Nonnull ResourceLocation resultId) {
        return new RecipeOutput(true, resultId.toString(), 1);
    }

    public static RecipeOutput fromTag(@Nonnull ResourceLocation resultId, int count) {
        return new RecipeOutput(true, resultId.toString(), count);
    }

    public static RecipeOutput fromItem(@Nonnull String resultId) {
        return new RecipeOutput(false, resultId, 1);
    }

    public static RecipeOutput fromItem(@Nonnull String resultId, int count) {
        return new RecipeOutput(false, resultId, count);
    }

    public static RecipeOutput fromItem(@Nonnull ResourceLocation resultId) {
        return new RecipeOutput(false, resultId.toString(), 1);
    }

    public static RecipeOutput fromItem(@Nonnull ResourceLocation resultId, int count) {
        return new RecipeOutput(false, resultId.toString(), count);
    }

    public static RecipeOutput fromItem(@Nonnull IItemProvider item) {
        return new RecipeOutput(false, item.func_199767_j().getRegistryName().toString(), 1);
    }

    public static RecipeOutput fromItem(@Nonnull IItemProvider item, int count) {
        return new RecipeOutput(false, item.func_199767_j().getRegistryName().toString(), count);
    }

    public boolean isTag() {
        return this.tag;
    }

    public String getResultId() {
        return this.resultId;
    }

    public int getCount() {
        return this.count;
    }

    public float getChance() {
        return this.chance;
    }
}

