/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.core;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;

public class ChanceItemStack {
    @Nonnull
    private final ItemStack itemStack;
    private final float chance;

    public ChanceItemStack(@Nonnull ItemStack itemStack, float chance) {
        this.itemStack = itemStack;
        this.chance = chance;
    }

    @Nonnull
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public float getChance() {
        return this.chance;
    }

    public void write(@Nonnull PacketBuffer buffer) {
        buffer.func_150788_a(this.itemStack);
        buffer.writeFloat(this.chance);
    }

    public static ChanceItemStack read(@Nonnull PacketBuffer buffer) {
        ItemStack itemStack = buffer.func_150791_c();
        float chance = buffer.readFloat();
        return new ChanceItemStack(itemStack, chance);
    }

    @Nullable
    public static ChanceItemStack from(JsonObject json) {
        if (!JSONUtils.func_151204_g((JsonObject)json, (String)"item")) {
            return null;
        }
        ItemStack itemStack = ShapedRecipe.func_199798_a((JsonObject)json);
        float chance = JSONUtils.func_151204_g((JsonObject)json, (String)"chance") ? JSONUtils.func_151217_k((JsonObject)json, (String)"chance") : 1.0f;
        return new ChanceItemStack(itemStack, chance);
    }
}

