/*
 * Decompiled with CFR 0.152.
 */
package commoble.bagofyurting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import commoble.bagofyurting.BagOfYurtingData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.math.BlockPos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompressedBagOfYurtingData {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Codec<CompressedBagOfYurtingData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockState.field_235877_b_.listOf().fieldOf("states").forGetter(CompressedBagOfYurtingData::getStates), (App)CompressedStateData.CODEC.listOf().fieldOf("data").forGetter(CompressedBagOfYurtingData::getData)).apply((Applicative)builder, CompressedBagOfYurtingData::new));
    private final List<BlockState> states;
    private final List<CompressedStateData> data;

    public List<BlockState> getStates() {
        return this.states;
    }

    public List<CompressedStateData> getData() {
        return this.data;
    }

    public CompressedBagOfYurtingData(List<BlockState> states, List<CompressedStateData> data) {
        this.states = states;
        this.data = data;
    }

    public BagOfYurtingData uncompress() {
        HashMap<BlockPos, BagOfYurtingData.StateData> map = new HashMap<BlockPos, BagOfYurtingData.StateData>();
        this.data.forEach(compressedData -> {
            BlockPos pos = ((CompressedStateData)compressedData).pos;
            int index = ((CompressedStateData)compressedData).stateIndex;
            BlockState state = this.states.get(index);
            CompoundNBT nbt = compressedData.getNBT().orElseGet(CompoundNBT::new);
            BagOfYurtingData.StateData data = new BagOfYurtingData.StateData(state, nbt);
            map.put(pos, data);
        });
        return new BagOfYurtingData(map);
    }

    public CompoundNBT toNBT() {
        return (CompoundNBT)CODEC.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseGet(CompoundNBT::new);
    }

    public static CompressedBagOfYurtingData fromNBT(CompoundNBT nbt) {
        return CODEC.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nbt).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseGet(() -> new CompressedBagOfYurtingData(new ArrayList<BlockState>(), new ArrayList<CompressedStateData>()));
    }

    public static class CompressedStateData {
        public static final Codec<CompressedStateData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockPos.field_239578_a_.fieldOf("pos").forGetter(CompressedStateData::getPos), (App)Codec.INT.fieldOf("state").forGetter(CompressedStateData::getStateIndex), (App)CompoundNBT.field_240597_a_.optionalFieldOf("nbt").forGetter(CompressedStateData::getNBT)).apply((Applicative)builder, CompressedStateData::new));
        private final BlockPos pos;
        private final int stateIndex;
        private final Optional<CompoundNBT> nbt;

        public BlockPos getPos() {
            return this.pos;
        }

        public int getStateIndex() {
            return this.stateIndex;
        }

        public Optional<CompoundNBT> getNBT() {
            return this.nbt;
        }

        public CompressedStateData(BlockPos pos, int stateIndex, Optional<CompoundNBT> nbt) {
            this.pos = pos;
            this.stateIndex = stateIndex;
            this.nbt = nbt;
        }
    }
}

