/*
 * Decompiled with CFR 0.152.
 */
package commoble.bagofyurting;

import commoble.bagofyurting.BagOfYurtingData;
import commoble.bagofyurting.BagOfYurtingMod;
import commoble.bagofyurting.storage.DataIdNBTHelper;
import commoble.bagofyurting.storage.StorageManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BagOfYurtingItem
extends Item
implements IDyeableArmorItem {
    public static final String RADIUS_KEY = "radius";
    public static final int UNDYED_COLOR = 0xFFFFFF;

    public BagOfYurtingItem(Item.Properties properties) {
        super(properties);
    }

    public boolean func_77636_d(ItemStack stack) {
        return BagOfYurtingItem.getDataReader(stack) != null;
    }

    public int getRadius(ItemStack stack) {
        return stack.func_196082_o().func_74762_e(RADIUS_KEY);
    }

    public int getDiameter(ItemStack stack) {
        return this.getRadius(stack) * 2 + 1;
    }

    public ItemStack withRadius(ItemStack stack, int radius) {
        ItemStack newStack = stack.func_77946_l();
        newStack.func_196082_o().func_74768_a(RADIUS_KEY, radius);
        return newStack;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (int i = 0; i < 7; ++i) {
                items.add((Object)this.withRadius(new ItemStack((IItemProvider)this), i));
            }
        }
    }

    @Nullable
    public static Function<MinecraftServer, BagOfYurtingData> getDataReader(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (DataIdNBTHelper.contains(nbt)) {
            return server -> {
                String dataId = DataIdNBTHelper.get(nbt);
                return StorageManager.load(server, dataId);
            };
        }
        if (BagOfYurtingData.doesNBTContainYurtData(nbt)) {
            return server -> BagOfYurtingData.read(nbt);
        }
        return null;
    }

    public int func_200886_f(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_179543_a("display");
        return compoundnbt != null && compoundnbt.func_150297_b("color", 99) ? compoundnbt.func_74762_e("color") : 0xFFFFFF;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (world instanceof ServerWorld) {
            Function<MinecraftServer, BagOfYurtingData> dataGetter = BagOfYurtingItem.getDataReader(context.func_195996_i());
            MinecraftServer server = ((ServerWorld)world).func_73046_m();
            if (dataGetter == null) {
                this.loadBag(server, context);
            } else {
                this.unloadBag(context, dataGetter.apply(server));
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void loadBag(MinecraftServer server, ItemUseContext context) {
        Hand hand = context.func_221531_n();
        ItemStack oldStack = context.func_195999_j().func_184586_b(hand);
        BagOfYurtingData data = BagOfYurtingData.yurtBlocksAndConvertToData(context, this.getRadius(oldStack));
        if (!data.isEmpty()) {
            String id = DataIdNBTHelper.generate(server);
            StorageManager.save(id, data);
            ItemStack newStack = oldStack.func_77946_l();
            DataIdNBTHelper.set(newStack.func_196082_o(), id);
            context.func_195999_j().func_184611_a(context.func_221531_n(), newStack);
        } else {
            context.func_195999_j().func_146105_b((ITextComponent)new TranslationTextComponent("bagofyurting.failure.load"), true);
        }
    }

    public void unloadBag(ItemUseContext context, BagOfYurtingData data) {
        Hand hand = context.func_221531_n();
        ItemStack oldStack = context.func_195999_j().func_184586_b(hand);
        boolean success = data.attemptUnloadIntoWorld(context, this.getRadius(oldStack));
        if (success) {
            ItemStack newStack = oldStack.func_77946_l();
            CompoundNBT tag = newStack.func_196082_o();
            tag.func_218657_a("yurtdata", (INBT)new CompoundNBT());
            String id = DataIdNBTHelper.remove(tag);
            if (id != null) {
                StorageManager.remove(id);
            }
            context.func_195999_j().func_184611_a(context.func_221531_n(), newStack);
        } else {
            context.func_195999_j().func_146105_b((ITextComponent)new TranslationTextComponent("bagofyurting.failure.unload"), true);
        }
    }

    public static ItemStack getUpgradeRecipeResult(List<ItemStack> inputs, ItemStack baseOutput) {
        ItemStack output = baseOutput.func_77946_l();
        int bagRadius = Integer.MAX_VALUE;
        boolean foundBag = false;
        ArrayList<Integer> dyes = new ArrayList<Integer>();
        for (ItemStack stack : inputs) {
            Item item = stack.func_77973_b();
            if (!(item instanceof BagOfYurtingItem)) continue;
            foundBag = true;
            int newRadius = ((BagOfYurtingItem)BagOfYurtingMod.INSTANCE.bagOfYurtingItem.get()).getRadius(stack);
            if (((BagOfYurtingItem)BagOfYurtingMod.INSTANCE.bagOfYurtingItem.get()).func_200883_f_(stack)) {
                dyes.add(((BagOfYurtingItem)BagOfYurtingMod.INSTANCE.bagOfYurtingItem.get()).func_200886_f(stack));
            }
            if (newRadius >= bagRadius) continue;
            bagRadius = newRadius;
        }
        if (!foundBag) {
            bagRadius = 0;
        }
        ItemStack actualOutput = ((BagOfYurtingItem)BagOfYurtingMod.INSTANCE.bagOfYurtingItem.get()).withRadius(output, bagRadius + 1);
        int colors = dyes.size();
        if (colors > 0) {
            int redSum = 0;
            int greenSum = 0;
            int blueSum = 0;
            Iterator iterator = dyes.iterator();
            while (iterator.hasNext()) {
                int color = (Integer)iterator.next();
                redSum += color >> 16 & 0xFF;
                greenSum += color >> 8 & 0xFF;
                blueSum += color & 0xFF;
            }
            int finalRed = redSum / colors << 16;
            int finalGreen = greenSum / colors << 8;
            int finalBlue = blueSum / colors & 0xFF;
            int finalColor = finalRed + finalGreen + finalBlue;
            ((BagOfYurtingItem)BagOfYurtingMod.INSTANCE.bagOfYurtingItem.get()).func_200885_a(actualOutput, finalColor);
        }
        return actualOutput;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int diameter = this.getDiameter(stack);
        String sizeText = String.format("%sx%sx%s", diameter, diameter, diameter);
        StringTextComponent text = new StringTextComponent(sizeText);
        tooltip.add((ITextComponent)new StringTextComponent(sizeText).func_230530_a_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true)).func_240721_b_(TextFormatting.GRAY)));
    }
}

