/*
 * Decompiled with CFR 0.152.
 */
package snownee.drawer;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import snownee.drawer.ModTags;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public final class Tooltip {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###,###");
    private static boolean tagsUpdated;

    private Tooltip() {
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        tagsUpdated = true;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onTooltip(ItemTooltipEvent event) {
        if (!tagsUpdated) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (ModTags.DRAWERS.func_230235_a_((Object)stack.func_77973_b())) {
            Tooltip.normalDrawer(event, stack);
        } else if (ModTags.COMPACTING_DRAWERS.func_230235_a_((Object)stack.func_77973_b())) {
            Tooltip.compactingDrawer(event, stack);
        }
    }

    private static void normalDrawer(ItemTooltipEvent event, ItemStack stack) {
        try {
            CompoundNBT tile = stack.func_179543_a("tile");
            if (tile == null || !tile.func_74764_b("Drawers")) {
                return;
            }
            ArrayList lines = Lists.newArrayList();
            for (INBT nbt : tile.func_150295_c("Drawers", 10)) {
                CompoundNBT tag = (CompoundNBT)nbt;
                ItemStack content = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Item"));
                if (content.func_190926_b()) continue;
                int amount = tag.func_74762_e("Count");
                lines.add(new StringTextComponent(content.func_200301_q().getString() + " x" + DECIMAL_FORMAT.format(amount)));
            }
            event.getToolTip().addAll(3, lines);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void compactingDrawer(ItemTooltipEvent event, ItemStack stack) {
        try {
            CompoundNBT tile = stack.func_179543_a("tile");
            if (tile == null || !tile.func_74764_b("Drawers")) {
                return;
            }
            CompoundNBT drawersTag = tile.func_74775_l("Drawers");
            int count = drawersTag.func_74762_e("Count");
            ArrayList lines = Lists.newArrayList();
            for (INBT nbt : drawersTag.func_150295_c("Items", 10)) {
                int amount;
                int conv;
                CompoundNBT tag = (CompoundNBT)nbt;
                ItemStack content = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Item"));
                if (content.func_190926_b() || (conv = tag.func_74762_e("Conv")) <= 0 || (amount = count / conv) <= 0) continue;
                lines.add(new StringTextComponent(content.func_200301_q().getString() + " x" + DECIMAL_FORMAT.format(amount)));
            }
            event.getToolTip().addAll(3, lines);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

