/*
 * Decompiled with CFR 0.152.
 */
package snownee.drawer;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.drawer.ModTags;

public class DrawerIngredient
extends Ingredient {
    private final Ingredient ingredient;
    private final int amount;

    private DrawerIngredient(Ingredient ingredient, int amount) {
        super(Stream.of(new DrawerList(ingredient, amount)));
        this.ingredient = ingredient;
        this.amount = amount;
    }

    public boolean isSimple() {
        return false;
    }

    public Serializer getSerializer() {
        return Serializer.INSTANCE;
    }

    public boolean test(ItemStack stack) {
        if (!ModTags.DRAWERS.func_230235_a_((Object)stack.func_77973_b())) {
            return false;
        }
        try {
            CompoundNBT tile = stack.func_179543_a("tile");
            if (tile == null || !tile.func_74764_b("Drawers")) {
                return false;
            }
            for (INBT nbt : tile.func_150295_c("Drawers", 10)) {
                ItemStack content;
                CompoundNBT tag = (CompoundNBT)nbt;
                int amount = tag.func_74762_e("Count");
                if (amount < this.amount || !this.ingredient.test(content = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Item")))) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static class DrawerList
    implements Ingredient.IItemList {
        public static final Item ITEM = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("storagedrawers", "oak_full_drawers_1"));
        private final Ingredient ingredient;
        private final int amount;

        private DrawerList(Ingredient ingredient, int amount) {
            this.ingredient = ingredient;
            this.amount = amount;
        }

        public Collection<ItemStack> func_199799_a() {
            CompoundNBT itemTag = new CompoundNBT();
            ItemStack[] stacks = this.ingredient.func_193365_a();
            if (stacks.length > 0) {
                itemTag.func_74768_a("Count", this.amount);
                itemTag.func_218657_a("Item", (INBT)stacks[0].serializeNBT());
            }
            CompoundNBT tag = new CompoundNBT();
            tag.func_218657_a("tile", (INBT)new CompoundNBT());
            tag.func_74775_l("tile").func_218657_a("Drawers", (INBT)new ListNBT());
            tag.func_74775_l("tile").func_150295_c("Drawers", 10).add((Object)itemTag);
            ArrayList list = Lists.newArrayList();
            ItemStack stack = new ItemStack((IItemProvider)ITEM);
            stack.func_77982_d(tag);
            list.add(stack);
            if (list.size() == 0 && !((Boolean)ForgeConfig.SERVER.treatEmptyTagsAsAir.get()).booleanValue()) {
                list.add(new ItemStack((IItemProvider)Blocks.field_180401_cv).func_200302_a((ITextComponent)new StringTextComponent("Empty Tag: " + ModTags.DRAWERS.func_230234_a_().toString())));
            }
            return list;
        }

        public JsonObject func_200303_b() {
            return new JsonObject();
        }
    }

    public static enum Serializer implements IIngredientSerializer<DrawerIngredient>
    {
        INSTANCE;


        public DrawerIngredient parse(PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            int amount = buffer.func_150792_a();
            return new DrawerIngredient(ingredient, amount);
        }

        public DrawerIngredient parse(JsonObject json) {
            Ingredient ingredient = CraftingHelper.getIngredient((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"content"));
            int amount = JSONUtils.func_151203_m((JsonObject)json, (String)"amount");
            return new DrawerIngredient(ingredient, amount);
        }

        public void write(PacketBuffer buffer, DrawerIngredient ingredient) {
            ingredient.ingredient.func_199564_a(buffer);
            buffer.func_150787_b(ingredient.amount);
        }
    }
}

