/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.tiles;

import com.refinedmods.refinedstorage.tile.NetworkNodeTile;
import com.refinedmods.refinedstorage.tile.data.TileDataParameter;
import edivad.extrastorage.blocks.CrafterTier;
import edivad.extrastorage.client.screen.dataparameter.AdvancedCrafterTileDataParameterClientListener;
import edivad.extrastorage.nodes.AdvancedCrafterNetworkNode;
import edivad.extrastorage.setup.Registration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class AdvancedCrafterTile
extends NetworkNodeTile<AdvancedCrafterNetworkNode> {
    public static final TileDataParameter<Integer, AdvancedCrafterTile> MODE = new TileDataParameter(DataSerializers.field_187192_b, (Object)AdvancedCrafterNetworkNode.CrafterMode.IGNORE.ordinal(), t -> ((AdvancedCrafterNetworkNode)t.getNode()).getMode().ordinal(), (t, v) -> ((AdvancedCrafterNetworkNode)t.getNode()).setMode(AdvancedCrafterNetworkNode.CrafterMode.getById(v)));
    private static final TileDataParameter<Boolean, AdvancedCrafterTile> HAS_ROOT = new TileDataParameter(DataSerializers.field_187198_h, (Object)false, t -> ((AdvancedCrafterNetworkNode)t.getNode()).getRootContainerNotSelf().isPresent(), null, (t, v) -> new AdvancedCrafterTileDataParameterClientListener().onChanged(t, (Boolean)v));
    private final LazyOptional<IItemHandler> patternsCapability = LazyOptional.of(() -> ((AdvancedCrafterNetworkNode)this.getNode()).getPatternItems());
    private final CrafterTier tier;

    public AdvancedCrafterTile(CrafterTier tier) {
        super((TileEntityType)Registration.CRAFTER_TILE.get((Object)tier).get());
        this.tier = tier;
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addParameter(HAS_ROOT);
    }

    public AdvancedCrafterNetworkNode createNode(World world, BlockPos blockPos) {
        return new AdvancedCrafterNetworkNode(world, blockPos, this.tier);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && direction != null && !direction.equals((Object)((AdvancedCrafterNetworkNode)this.getNode()).getDirection())) {
            return this.patternsCapability.cast();
        }
        return super.getCapability(cap, direction);
    }

    public CrafterTier getTier() {
        return this.tier;
    }
}

