/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.nodes;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.tile.DiskDriveTile;
import com.refinedmods.refinedstorage.tile.config.IComparable;
import com.refinedmods.refinedstorage.tile.config.IType;
import com.refinedmods.refinedstorage.tile.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.refinedmods.refinedstorage.util.WorldUtils;
import edivad.extrastorage.tiles.AdvancedImporterTile;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class AdvancedImporterNetworkNode
extends NetworkNode
implements IComparable,
IWhitelistBlacklist,
IType {
    public static final ResourceLocation ID = new ResourceLocation("extrastorage", "advanced_importer");
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private final BaseItemHandler itemFilters = new BaseItemHandler(18).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private final FluidInventory fluidFilters = new FluidInventory(18).addListener((InventoryListener)new NetworkNodeFluidInventoryListener((INetworkNode)this));
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, new UpgradeItem.Type[]{UpgradeItem.Type.SPEED, UpgradeItem.Type.STACK}).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private int compare = 1;
    private int mode = 1;
    private int type = 0;
    private int currentSlot;

    public AdvancedImporterNetworkNode(World world, BlockPos pos) {
        super(world, pos);
    }

    public int getEnergyUsage() {
        return 4 * (RS.SERVER_CONFIG.getImporter().getUsage() + this.upgrades.getEnergyUsage());
    }

    public void update() {
        FluidStack toDrain;
        FluidStack stack;
        IFluidHandler handler;
        super.update();
        if (!this.canUpdate() || !this.world.func_195588_v(this.pos)) {
            return;
        }
        if (this.type == 0) {
            TileEntity facing = this.getFacingTile();
            IItemHandler handler2 = WorldUtils.getItemHandler((TileEntity)facing, (Direction)this.getDirection().func_176734_d());
            if (facing instanceof DiskDriveTile || handler2 == null) {
                return;
            }
            if (this.currentSlot >= handler2.getSlots()) {
                this.currentSlot = 0;
            }
            if (handler2.getSlots() > 0) {
                while (this.currentSlot + 1 < handler2.getSlots() && handler2.getStackInSlot(this.currentSlot).func_190926_b()) {
                    ++this.currentSlot;
                }
                ItemStack stack2 = handler2.getStackInSlot(this.currentSlot);
                if (!IWhitelistBlacklist.acceptsItem((IItemHandler)this.itemFilters, (int)this.mode, (int)this.compare, (ItemStack)stack2)) {
                    ++this.currentSlot;
                } else if (this.ticks % this.upgrades.getSpeed() == 0) {
                    ItemStack result = handler2.extractItem(this.currentSlot, this.upgrades.getStackInteractCount(), true);
                    if (!result.func_190926_b() && this.network.insertItem(result, result.func_190916_E(), Action.SIMULATE).func_190926_b()) {
                        result = handler2.extractItem(this.currentSlot, this.upgrades.getStackInteractCount(), false);
                        this.network.insertItemTracked(result, result.func_190916_E());
                    } else {
                        ++this.currentSlot;
                    }
                }
            }
        } else if (this.type == 1 && this.ticks % this.upgrades.getSpeed() == 0 && (handler = WorldUtils.getFluidHandler((TileEntity)this.getFacingTile(), (Direction)this.getDirection().func_176734_d())) != null && !(stack = handler.drain(1000, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && IWhitelistBlacklist.acceptsFluid((FluidInventory)this.fluidFilters, (int)this.mode, (int)this.compare, (FluidStack)stack) && this.network.insertFluid(stack, stack.getAmount(), Action.SIMULATE).isEmpty() && !(toDrain = handler.drain(1000 * this.upgrades.getStackInteractCount(), IFluidHandler.FluidAction.SIMULATE)).isEmpty()) {
            FluidStack remainder = this.network.insertFluidTracked(toDrain, toDrain.getAmount());
            if (!remainder.isEmpty()) {
                toDrain.shrink(remainder.getAmount());
            }
            handler.drain(toDrain, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public int getCompare() {
        return this.compare;
    }

    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    public int getWhitelistBlacklistMode() {
        return this.mode;
    }

    public void setWhitelistBlacklistMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    public ResourceLocation getId() {
        return ID;
    }

    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, (int)1, (CompoundNBT)tag);
        return tag;
    }

    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilters, (int)0, (CompoundNBT)tag);
        tag.func_218657_a(NBT_FLUID_FILTERS, (INBT)this.fluidFilters.writeToNbt());
        return tag;
    }

    public void read(CompoundNBT tag) {
        super.read(tag);
        StackUtils.readItems((BaseItemHandler)this.upgrades, (int)1, (CompoundNBT)tag);
    }

    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        StackUtils.readItems((BaseItemHandler)this.itemFilters, (int)0, (CompoundNBT)tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
    }

    public UpgradeItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IItemHandler getDrops() {
        return this.upgrades;
    }

    public int getType() {
        return this.world.field_72995_K ? (Integer)AdvancedImporterTile.TYPE.getValue() : this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }
}

