/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.container;

import com.refinedmods.refinedstorage.container.BaseContainer;
import com.refinedmods.refinedstorage.container.slot.filter.FilterSlot;
import com.refinedmods.refinedstorage.container.slot.filter.FluidFilterSlot;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.tile.BaseTile;
import edivad.extrastorage.nodes.AdvancedExporterNetworkNode;
import edivad.extrastorage.setup.Registration;
import edivad.extrastorage.tiles.AdvancedExporterTile;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class AdvancedExporterContainer
extends BaseContainer {
    private final AdvancedExporterTile tile;
    private boolean hasRegulatorMode;

    public AdvancedExporterContainer(int windowId, PlayerEntity player, AdvancedExporterTile tile) {
        super((ContainerType)Registration.ADVANCED_EXPORTER_CONTAINER.get(), (BaseTile)tile, player, windowId);
        this.tile = tile;
        this.hasRegulatorMode = this.hasRegulatorMode();
        this.initSlots();
    }

    private boolean hasRegulatorMode() {
        return ((AdvancedExporterNetworkNode)this.tile.getNode()).getUpgrades().hasUpgrade(UpgradeItem.Type.REGULATOR);
    }

    public void func_75142_b() {
        super.func_75142_b();
        boolean updatedHasRegulatorMode = this.hasRegulatorMode();
        if (this.hasRegulatorMode != updatedHasRegulatorMode) {
            this.hasRegulatorMode = updatedHasRegulatorMode;
            this.initSlots();
        }
    }

    public void initSlots() {
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.transferManager.clearTransfers();
        for (int i = 0; i < 4; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)((AdvancedExporterNetworkNode)this.tile.getNode()).getUpgrades(), i, 187, 6 + i * 18));
        }
        boolean hasRegulator = ((AdvancedExporterNetworkNode)this.tile.getNode()).getUpgrades().hasUpgrade(UpgradeItem.Type.REGULATOR);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 9; ++j) {
                int index = i * 9 + j;
                int x = 8 + 18 * j;
                int y = 20 + 18 * i;
                this.func_75146_a((Slot)new FilterSlot((IItemHandler)((AdvancedExporterNetworkNode)this.tile.getNode()).getItemFilters(), index, x, y, hasRegulator ? 1 : 0).setEnableHandler(() -> ((AdvancedExporterNetworkNode)this.tile.getNode()).getType() == 0));
                this.func_75146_a((Slot)new FluidFilterSlot(((AdvancedExporterNetworkNode)this.tile.getNode()).getFluidFilters(), index, x, y, hasRegulator ? 1 : 0).setEnableHandler(() -> ((AdvancedExporterNetworkNode)this.tile.getNode()).getType() == 1));
            }
        }
        this.addPlayerInventory(8, 73);
        this.transferManager.addBiTransfer((IInventory)this.getPlayer().field_71071_by, (IItemHandler)((AdvancedExporterNetworkNode)this.tile.getNode()).getUpgrades());
        this.transferManager.addFilterTransfer((IInventory)this.getPlayer().field_71071_by, ((AdvancedExporterNetworkNode)this.tile.getNode()).getItemFilters(), ((AdvancedExporterNetworkNode)this.tile.getNode()).getFluidFilters(), ((AdvancedExporterNetworkNode)this.tile.getNode())::getType);
    }

    public AdvancedExporterTile getTile() {
        return this.tile;
    }
}

