/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFlorist;
import com.minecolonies.coremod.entity.ai.citizen.miner.Level;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.tileentities.TileEntityCompostedDirt;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.GlazedTerracottaBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WorkerUtil {
    private static final double MIDDLE_BLOCK_OFFSET = 0.5;
    private static final String LEVEL_SIGN_TEXT = "{\"text\":\"level_placeholder\"}";
    private static final String LEVEL_SIGN_FIRST_ROW = "Text1";
    public static List<Tuple<com.minecolonies.api.util.constant.ToolType, ItemStack>> tools;

    private WorkerUtil() {
    }

    public static List<Tuple<com.minecolonies.api.util.constant.ToolType, ItemStack>> getOrInitTestTools() {
        if (tools == null) {
            tools = new ArrayList<Tuple<com.minecolonies.api.util.constant.ToolType, ItemStack>>();
            tools.add(new Tuple<com.minecolonies.api.util.constant.ToolType, ItemStack>(com.minecolonies.api.util.constant.ToolType.HOE, new ItemStack((IItemProvider)Items.field_151017_I)));
            tools.add(new Tuple<com.minecolonies.api.util.constant.ToolType, ItemStack>(com.minecolonies.api.util.constant.ToolType.SHOVEL, new ItemStack((IItemProvider)Items.field_151038_n)));
            tools.add(new Tuple<com.minecolonies.api.util.constant.ToolType, ItemStack>(com.minecolonies.api.util.constant.ToolType.AXE, new ItemStack((IItemProvider)Items.field_151053_p)));
            tools.add(new Tuple<com.minecolonies.api.util.constant.ToolType, ItemStack>(com.minecolonies.api.util.constant.ToolType.PICKAXE, new ItemStack((IItemProvider)Items.field_151039_o)));
        }
        return tools;
    }

    public static boolean isPathBlock(Block block) {
        return ModTags.pathingBlocks.func_230235_a_((Object)block);
    }

    public static boolean isWorkerAtSiteWithMove(@NotNull EntityCitizen worker, @NotNull BlockPos site, int range) {
        return WorkerUtil.isWorkerAtSiteWithMove(worker, site.func_177958_n(), site.func_177956_o(), site.func_177952_p(), range);
    }

    public static boolean isWorkerAtSiteWithMove(@NotNull AbstractEntityCitizen worker, int x, int y, int z, int range) {
        if (!EntityUtils.isLivingAtSiteWithMove((LivingEntity)worker, x, y, z, range)) {
            if (worker.getNavigation().func_75500_f() && !EntityUtils.tryMoveLivingToXYZ((MobEntity)worker, x, y, z)) {
                worker.getCitizenStatusHandler().setStatus(Status.PATHFINDING_ERROR);
            }
            return false;
        }
        return true;
    }

    public static boolean setSpawnPoint(@Nullable BlockPos spawnPoint, @NotNull AbstractEntityCitizen citizen) {
        if (spawnPoint == null) {
            return false;
        }
        citizen.func_70012_b((double)spawnPoint.func_177958_n() + 0.5, spawnPoint.func_177956_o(), (double)spawnPoint.func_177952_p() + 0.5, citizen.getRotationYaw(), citizen.getRotationPitch());
        citizen.getNavigation().func_75499_g();
        return true;
    }

    public static IToolType getBestToolForBlock(BlockState state, float blockHardness) {
        IToolType toolType;
        ToolType forgeTool = state.getHarvestTool();
        String toolName = "";
        if (forgeTool == null) {
            if (blockHardness > 0.0f) {
                for (Tuple<com.minecolonies.api.util.constant.ToolType, ItemStack> tool : WorkerUtil.getOrInitTestTools()) {
                    if (tool.getB() == null || !(tool.getB().func_77973_b() instanceof ToolItem)) continue;
                    ToolItem toolItem = (ToolItem)tool.getB().func_77973_b();
                    if (!(tool.getB().func_150997_a(state) >= toolItem.func_200891_e().func_200928_b())) continue;
                    toolName = tool.getA().getName();
                    break;
                }
            }
        } else {
            toolName = forgeTool.getName();
        }
        if ((toolType = com.minecolonies.api.util.constant.ToolType.getToolType(toolName)) == com.minecolonies.api.util.constant.ToolType.NONE && state.func_185904_a() == Material.field_151575_d) {
            return com.minecolonies.api.util.constant.ToolType.AXE;
        }
        if (state.func_177230_c() instanceof GlazedTerracottaBlock) {
            return com.minecolonies.api.util.constant.ToolType.PICKAXE;
        }
        return toolType;
    }

    public static int getCorrectHarvestLevelForBlock(BlockState target) {
        int required = target.getHarvestLevel();
        if (required < 0 && target.func_185904_a() == Material.field_151575_d || target.func_177230_c() instanceof GlazedTerracottaBlock) {
            return 0;
        }
        return required;
    }

    public static void faceBlock(@Nullable BlockPos block, AbstractEntityCitizen citizen) {
        if (block == null) {
            return;
        }
        double xDifference = block.func_177958_n() - citizen.func_233580_cy_().func_177958_n();
        double zDifference = block.func_177952_p() - citizen.func_233580_cy_().func_177952_p();
        double yDifference = (float)block.func_177956_o() - ((float)citizen.func_233580_cy_().func_177956_o() + citizen.func_70047_e());
        double squareDifference = Math.sqrt(xDifference * xDifference + zDifference * zDifference);
        double intendedRotationYaw = Math.atan2(zDifference, xDifference) * 180.0 / Math.PI - 90.0;
        double intendedRotationPitch = -(Math.atan2(yDifference, squareDifference) * 180.0 / Math.PI);
        citizen.setOwnRotation((float)EntityUtils.updateRotation(citizen.getRotationYaw(), intendedRotationYaw, 30.0), (float)EntityUtils.updateRotation(citizen.getRotationPitch(), intendedRotationPitch, 30.0));
        double goToX = xDifference > 0.0 ? 0.001 : -0.001;
        double goToZ = zDifference > 0.0 ? 0.001 : -0.001;
        citizen.func_213315_a(MoverType.SELF, new Vector3d((double)((float)goToX), 0.0, (double)((float)goToZ)));
    }

    @Nullable
    public static BlockPos findFirstLevelSign(Blueprint structure, BlockPos pos) {
        for (int j = 0; j < structure.getSizeY(); ++j) {
            for (int k = 0; k < structure.getSizeZ(); ++k) {
                for (int i = 0; i < structure.getSizeX(); ++i) {
                    CompoundNBT teData;
                    @NotNull BlockPos localPos = new BlockPos(i, j, k);
                    BlockInfo te = (BlockInfo)structure.getBlockInfoAsMap().get(localPos);
                    if (te == null || (teData = te.getTileEntityData()) == null || !teData.func_74779_i(LEVEL_SIGN_FIRST_ROW).equals(LEVEL_SIGN_TEXT)) continue;
                    return pos.func_177973_b((Vector3i)structure.getPrimaryBlockOffset()).func_177971_a((Vector3i)localPos);
                }
            }
        }
        return null;
    }

    public static void updateLevelSign(World world, Level level, int levelId) {
        TileEntity te;
        @Nullable BlockPos levelSignPos = level.getLevelSign();
        if (levelSignPos != null && (te = world.func_175625_s(levelSignPos)) instanceof SignTileEntity) {
            BlockState BlockState2 = world.func_180495_p(levelSignPos);
            SignTileEntity teLevelSign = (SignTileEntity)te;
            teLevelSign.func_212365_a(0, (ITextComponent)new StringTextComponent(TextFormatting.func_110646_a((String)(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.minerMineNode", (Object[])new Object[0]) + ": " + levelId))));
            teLevelSign.func_212365_a(1, (ITextComponent)new StringTextComponent(TextFormatting.func_110646_a((String)("Y: " + (level.getDepth() + 1)))));
            teLevelSign.func_212365_a(2, (ITextComponent)new StringTextComponent(TextFormatting.func_110646_a((String)(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.minerNode", (Object[])new Object[0]) + ": " + level.getNumberOfBuiltNodes()))));
            teLevelSign.func_212365_a(3, (ITextComponent)new StringTextComponent(TextFormatting.func_110646_a((String)"")));
            teLevelSign.func_70296_d();
            world.func_184138_a(levelSignPos, BlockState2, BlockState2, 3);
        }
    }

    public static boolean isThereCompostedLand(BuildingFlorist buildingFlorist, World world) {
        for (BlockPos pos : buildingFlorist.getPlantGround()) {
            if (!WorldUtil.isBlockLoaded((IWorld)world, pos)) continue;
            TileEntity entity = world.func_175625_s(pos);
            if (entity instanceof TileEntityCompostedDirt) {
                if (!((TileEntityCompostedDirt)entity).isComposted()) continue;
                return true;
            }
            buildingFlorist.removePlantableGround(pos);
        }
        return false;
    }

    public static int getLastLadder(@NotNull BlockPos pos, World world) {
        if (world.func_180495_p(pos).func_177230_c().isLadder(world.func_180495_p(pos), (IWorldReader)world, pos, null)) {
            return WorkerUtil.getLastLadder(pos.func_177977_b(), world);
        }
        return pos.func_177956_o() + 1;
    }
}

