/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IChunkmanagerCapability;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.ChunkLoadStorage;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.IColonyManagerCapability;
import com.minecolonies.coremod.network.messages.client.UpdateChunkCapabilityMessage;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.jetbrains.annotations.NotNull;

public final class ChunkDataHelper {
    private ChunkDataHelper() {
    }

    public static void loadChunk(Chunk chunk, World world) {
        IColony colony;
        int closeColony;
        int distanceToDelete = (Integer)MineColonies.getConfig().getServer().maxColonySize.get() * 16 * 2 * 5;
        IChunkmanagerCapability chunkManager = world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return;
        }
        if (!chunkManager.getAllChunkStorages().isEmpty()) {
            IColonyManagerCapability cap = world.getCapability(MineColonies.COLONY_MANAGER_CAP, null).resolve().orElse(null);
            if (cap == null) {
                return;
            }
            ChunkLoadStorage existingStorage = chunkManager.getChunkStorage(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
            if (existingStorage != null) {
                ChunkDataHelper.addStorageToChunk(chunk, existingStorage);
            }
        }
        if ((closeColony = chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).map(IColonyTagCapability::getOwningColony).orElse(0).intValue()) != 0 && (colony = IColonyManager.getInstance().getColonyByDimension(closeColony, (RegistryKey<World>)world.func_234923_W_())) != null) {
            colony.addLoadedChunk(ChunkPos.func_77272_a((int)chunk.func_76632_l().field_77276_a, (int)chunk.func_76632_l().field_77275_b), chunk);
        }
    }

    public static void unloadChunk(Chunk chunk, World world) {
        IColony colony;
        int closeColony = chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).map(IColonyTagCapability::getOwningColony).orElse(0);
        if (closeColony != 0 && (colony = IColonyManager.getInstance().getColonyByDimension(closeColony, (RegistryKey<World>)world.func_234923_W_())) != null) {
            colony.removeLoadedChunk(ChunkPos.func_77272_a((int)chunk.func_76632_l().field_77276_a, (int)chunk.func_76632_l().field_77275_b));
        }
    }

    public static void addStorageToChunk(Chunk chunk, ChunkLoadStorage storage) {
        IColonyTagCapability cap = chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        storage.applyToCap(cap, chunk);
        if (cap != null) {
            Network.getNetwork().sendToEveryone(new UpdateChunkCapabilityMessage(cap, chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b));
        }
    }

    public static void claimColonyChunks(World world, boolean add, int id, BlockPos center, RegistryKey<World> dimension) {
        int range = (Integer)MineColonies.getConfig().getServer().initialColonySize.get();
        int buffer = (Integer)MineColonies.getConfig().getServer().minColonyDistance.get();
        ChunkDataHelper.claimChunksInRange(id, dimension, add, center, range, buffer, world);
    }

    public static void claimColonyChunks(IColony colony, boolean add, BlockPos center, int range) {
        ChunkDataHelper.claimChunksInRange(colony, add, range, center, false);
    }

    public static boolean canClaimChunksInRange(World w, BlockPos pos, int range) {
        IChunkmanagerCapability worldCapability = w.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (worldCapability == null) {
            return true;
        }
        Chunk centralChunk = w.func_175726_f(pos);
        int chunkX = centralChunk.func_76632_l().field_77276_a;
        int chunkZ = centralChunk.func_76632_l().field_77275_b;
        for (int i = chunkX - range; i <= chunkX + range; ++i) {
            for (int j = chunkZ - range; j <= chunkZ + range; ++j) {
                Chunk chunk = w.func_212866_a_(i, j);
                IColonyTagCapability colonyCap = chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).resolve().orElse(null);
                if (colonyCap == null) {
                    return true;
                }
                ChunkLoadStorage storage = worldCapability.getChunkStorage(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
                if (storage != null) {
                    storage.applyToCap(colonyCap, chunk);
                }
                if (colonyCap.getOwningColony() == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static void claimChunksInRange(IColony colony, boolean add, int range, BlockPos center, boolean force) {
        World world = colony.getWorld();
        int colonyId = colony.getID();
        RegistryKey<World> dimension = colony.getDimension();
        boolean areAllChunksAdded = true;
        IChunkmanagerCapability chunkManager = world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return;
        }
        int chunkColonyCenterX = colony.getCenter().func_177958_n() >> 4;
        int chunkColonyCenterZ = colony.getCenter().func_177952_p() >> 4;
        BlockPos colonyCenterCompare = new BlockPos(colony.getCenter().func_177958_n(), 0, colony.getCenter().func_177952_p());
        int chunkX = center.func_177958_n() >> 4;
        int chunkZ = center.func_177952_p() >> 4;
        int initialColonySize = (Integer)MineColonies.getConfig().getServer().initialColonySize.get();
        int maxColonySize = (Integer)MineColonies.getConfig().getServer().maxColonySize.get();
        for (int i = chunkX - range; i <= chunkX + range; ++i) {
            for (int j = chunkZ - range; j <= chunkZ + range; ++j) {
                if (!force && !add && Math.abs(chunkColonyCenterX - i) <= initialColonySize + 1 && Math.abs(chunkColonyCenterZ - j) <= initialColonySize + 1) {
                    Log.getLogger().debug("Unclaim of initial chunk prevented");
                    continue;
                }
                BlockPos pos = new BlockPos(i * 16, 0, j * 16);
                if (!force && maxColonySize != 0 && pos.func_177951_i((Vector3i)colonyCenterCompare) > Math.pow(maxColonySize * 16, 2.0)) {
                    Log.getLogger().debug("Tried to claim chunk at pos X:" + pos.func_177958_n() + " Z:" + pos.func_177952_p() + " too far away from the colony:" + colony.getID() + " center:" + colony.getCenter() + " max is config workingRangeTownHall ^2");
                    continue;
                }
                if (ChunkDataHelper.loadChunkAndAddData(world, pos, add, colonyId, center, chunkManager)) continue;
                areAllChunksAdded = false;
                @NotNull ChunkLoadStorage newStorage = new ChunkLoadStorage(colonyId, ChunkPos.func_77272_a((int)i, (int)j), dimension.func_240901_a_(), center);
                chunkManager.addChunkStorage(i, j, newStorage);
            }
        }
        if (areAllChunksAdded && add && range > 0) {
            IBuilding building = colony.getBuildingManager().getBuilding(center);
            LanguageHandler.sendPlayersMessage(colony.getImportantMessageEntityPlayers(), (String)"com.minecolonies.coremod.colonysizechange", (Object[])new Object[]{range, building.getSchematicName()});
        }
    }

    public static void claimChunksInRange(int colonyId, RegistryKey<World> dimension, boolean add, BlockPos center, int range, int buffer, World world) {
        IChunkmanagerCapability chunkManager = world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return;
        }
        Chunk centralChunk = world.func_175726_f(center);
        ChunkDataHelper.loadChunkAndAddData(world, center, add, colonyId, chunkManager);
        int chunkX = centralChunk.func_76632_l().field_77276_a;
        int chunkZ = centralChunk.func_76632_l().field_77275_b;
        int maxRange = range * 2 + buffer;
        for (int i = chunkX - maxRange; i <= chunkX + maxRange; ++i) {
            for (int j = chunkZ - maxRange; j <= chunkZ + maxRange; ++j) {
                if (i == chunkX && j == chunkZ || i >= chunkX - 5 && j >= chunkZ - 5 && i <= chunkX + 5 && j <= chunkZ + 5 && ChunkDataHelper.loadChunkAndAddData(world, new BlockPos(i * 16, 0, j * 16), add, colonyId, chunkManager)) continue;
                boolean owning = i >= chunkX - range && j >= chunkZ - range && i <= chunkX + range && j <= chunkZ + range;
                @NotNull ChunkLoadStorage newStorage = new ChunkLoadStorage(colonyId, ChunkPos.func_77272_a((int)i, (int)j), add, dimension.func_240901_a_(), owning);
                chunkManager.addChunkStorage(i, j, newStorage);
            }
        }
    }

    public static void debugChunksInRange(int chunkX, int chunkZ, int range, int buffer, World world) {
        IChunkmanagerCapability chunkManager = world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return;
        }
        int maxRange = range * 2 + buffer;
        for (int i = chunkX - maxRange; i <= chunkX + maxRange; ++i) {
            for (int j = chunkZ - maxRange; j <= chunkZ + maxRange; ++j) {
                BlockPos pos = new BlockPos(i * 16, 0, j * 16);
                Chunk chunk = world.func_175726_f(pos);
                if (chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).map(IColonyTagCapability::getOwningColony).orElse(0) == 0) continue;
                Log.getLogger().warn("Has owner: " + pos.toString());
            }
        }
    }

    public static boolean loadChunkAndAddData(World world, BlockPos pos, boolean add, int id, IChunkmanagerCapability chunkManager) {
        if (!WorldUtil.isBlockLoaded((IWorld)world, pos)) {
            return false;
        }
        Chunk chunk = (Chunk)world.func_217349_x(pos);
        IColonyTagCapability cap = chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        if (cap == null) {
            return false;
        }
        ChunkLoadStorage chunkLoadStorage = chunkManager.getChunkStorage(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
        if (chunkLoadStorage != null) {
            chunkLoadStorage.applyToCap(cap, chunk);
        }
        if (cap.getOwningColony() == id && add) {
            return true;
        }
        if (add) {
            IColony colony = IColonyManager.getInstance().getColonyByDimension(id, (RegistryKey<World>)world.func_234923_W_());
            if (colony != null) {
                colony.addLoadedChunk(ChunkPos.func_77272_a((int)chunk.func_76632_l().field_77276_a, (int)chunk.func_76632_l().field_77275_b), chunk);
            }
            cap.setOwningColony(id, chunk);
            cap.addColony(id, chunk);
        } else {
            cap.removeColony(id, chunk);
        }
        Network.getNetwork().sendToEveryone(new UpdateChunkCapabilityMessage(cap, chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b));
        return true;
    }

    public static boolean loadChunkAndAddData(World world, BlockPos pos, boolean add, int id, BlockPos buildingPos, IChunkmanagerCapability chunkManager) {
        if (!WorldUtil.isBlockLoaded((IWorld)world, pos)) {
            return false;
        }
        Chunk chunk = world.func_175726_f(pos);
        IColonyTagCapability cap = chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        if (cap == null) {
            return false;
        }
        ChunkLoadStorage chunkLoadStorage = chunkManager.getChunkStorage(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
        if (chunkLoadStorage != null) {
            chunkLoadStorage.applyToCap(cap, chunk);
        }
        if (add) {
            cap.addBuildingClaim(id, buildingPos, chunk);
        } else {
            cap.removeBuildingClaim(id, buildingPos, chunk);
        }
        Network.getNetwork().sendToEveryone(new UpdateChunkCapabilityMessage(cap, chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b));
        return true;
    }
}

