/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.AbstractTileEntityWareHouse;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityWareHouse
extends AbstractTileEntityWareHouse {
    private long lastNotification = 0L;

    public TileEntityWareHouse() {
        super(MinecoloniesTileEntities.WAREHOUSE);
    }

    @Override
    public boolean hasMatchingItemStackInWarehouse(@NotNull Predicate<ItemStack> itemStackSelectionPredicate, int count) {
        List<Tuple<ItemStack, BlockPos>> targetStacks = this.getMatchingItemStacksInWarehouse(itemStackSelectionPredicate);
        return targetStacks.stream().mapToInt(tuple -> ItemStackUtils.getSize((ItemStack)tuple.getA())).sum() >= count;
    }

    @Override
    public boolean hasMatchingItemStackInWarehouse(@NotNull ItemStack itemStack, int count, boolean ignoreNBT) {
        return this.hasMatchingItemStackInWarehouse(itemStack, count, ignoreNBT, 0);
    }

    @Override
    public boolean hasMatchingItemStackInWarehouse(@NotNull ItemStack itemStack, int count, boolean ignoreNBT, boolean ignoreDamage, int leftOver) {
        int totalCountFound = 0 - leftOver;
        for (BlockPos pos : this.getBuilding().getContainers()) {
            TileEntity entity;
            if (!WorldUtil.isBlockLoaded((IWorld)this.field_145850_b, pos) || !((entity = this.func_145831_w().func_175625_s(pos)) instanceof TileEntityRack) || ((AbstractTileEntityRack)entity).isEmpty() || (totalCountFound += ((AbstractTileEntityRack)entity).getCount(itemStack, ignoreDamage, ignoreNBT)) < count) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMatchingItemStackInWarehouse(@NotNull ItemStack itemStack, int count, boolean ignoreNBT, int leftOver) {
        return this.hasMatchingItemStackInWarehouse(itemStack, count, ignoreNBT, true, leftOver);
    }

    @Override
    @NotNull
    public List<Tuple<ItemStack, BlockPos>> getMatchingItemStacksInWarehouse(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        ArrayList<Tuple<ItemStack, BlockPos>> found = new ArrayList<Tuple<ItemStack, BlockPos>>();
        if (this.getBuilding() != null) {
            for (BlockPos pos : this.getBuilding().getContainers()) {
                TileEntity entity = this.func_145831_w().func_175625_s(pos);
                if (entity instanceof TileEntityRack && !((AbstractTileEntityRack)entity).isEmpty() && ((AbstractTileEntityRack)entity).getItemCount(itemStackSelectionPredicate) > 0) {
                    TileEntityRack rack = (TileEntityRack)entity;
                    for (ItemStack stack : InventoryUtils.filterItemHandler((IItemHandler)rack.getInventory(), itemStackSelectionPredicate)) {
                        found.add(new Tuple<ItemStack, BlockPos>(stack, pos));
                    }
                }
                if (!(entity instanceof ChestTileEntity) || !InventoryUtils.hasItemInItemHandler((IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseGet(null), itemStackSelectionPredicate)) continue;
                for (ItemStack stack : InventoryUtils.filterItemHandler((IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseGet(null), itemStackSelectionPredicate)) {
                    found.add(new Tuple<ItemStack, BlockPos>(stack, pos));
                }
            }
        }
        return found;
    }

    @Override
    public void dumpInventoryIntoWareHouse(@NotNull InventoryCitizen inventoryCitizen) {
        for (int i = 0; i < inventoryCitizen.getSlots(); ++i) {
            ItemStack stack = inventoryCitizen.getStackInSlot(i);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
            @Nullable TileEntity chest = this.getRackForStack(stack);
            if (chest == null) {
                if (this.field_145850_b.func_82737_E() - this.lastNotification > 6000L) {
                    this.lastNotification = this.field_145850_b.func_82737_E();
                    if (this.getBuilding().getBuildingLevel() == this.getBuilding().getMaxBuildingLevel()) {
                        LanguageHandler.sendPlayersMessage(this.getColony().getMessagePlayerEntities(), (String)"com.minecolonies.coremod.warehouse.full.max", (Object[])new Object[0]);
                    } else {
                        LanguageHandler.sendPlayersMessage(this.getColony().getMessagePlayerEntities(), (String)"com.minecolonies.coremod.warehouse.full", (Object[])new Object[0]);
                    }
                }
                return;
            }
            int index = i;
            chest.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(handler -> InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler((IItemHandler)inventoryCitizen, index, handler));
        }
    }

    public TileEntity getRackForStack(ItemStack stack) {
        TileEntity rack = this.getPositionOfChestWithItemStack(stack);
        if (rack == null && (rack = this.getPositionOfChestWithSimilarItemStack(stack)) == null) {
            rack = this.searchMostEmptyRack();
        }
        return rack;
    }

    @Nullable
    private TileEntity getPositionOfChestWithItemStack(@NotNull ItemStack stack) {
        for (BlockPos pos : this.getBuilding().getContainers()) {
            TileEntity entity;
            if (!WorldUtil.isBlockLoaded((IWorld)this.field_145850_b, pos) || !((entity = this.func_145831_w().func_175625_s(pos)) instanceof AbstractTileEntityRack) || ((AbstractTileEntityRack)entity).getFreeSlots() <= 0 || !((AbstractTileEntityRack)entity).hasItemStack(stack, 1, true)) continue;
            return entity;
        }
        return null;
    }

    @Nullable
    private TileEntity getPositionOfChestWithSimilarItemStack(ItemStack stack) {
        for (BlockPos pos : this.getBuilding().getContainers()) {
            TileEntity entity;
            if (!WorldUtil.isBlockLoaded((IWorld)this.field_145850_b, pos) || !((entity = this.func_145831_w().func_175625_s(pos)) instanceof AbstractTileEntityRack) || ((AbstractTileEntityRack)entity).getFreeSlots() <= 0 || !((AbstractTileEntityRack)entity).hasSimilarStack(stack)) continue;
            return entity;
        }
        return null;
    }

    @Nullable
    private TileEntity searchMostEmptyRack() {
        int freeSlots = 0;
        TileEntity emptiestChest = null;
        for (BlockPos pos : this.getBuilding().getContainers()) {
            TileEntity entity = this.func_145831_w().func_175625_s(pos);
            if (!(entity instanceof TileEntityRack)) continue;
            if (((AbstractTileEntityRack)entity).isEmpty()) {
                return entity;
            }
            int tempFreeSlots = ((AbstractTileEntityRack)entity).getFreeSlots();
            if (tempFreeSlots <= freeSlots) continue;
            freeSlots = tempFreeSlots;
            emptiestChest = entity;
        }
        return emptiestChest;
    }
}

