/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.ILocalResearchTree;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.effects.IResearchEffect;
import com.minecolonies.api.research.effects.IResearchEffectManager;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.research.LocalResearch;
import com.minecolonies.coremod.research.ResearchCompatMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class LocalResearchTree
implements ILocalResearchTree {
    private final Map<ResourceLocation, Map<ResourceLocation, ILocalResearch>> researchTree = new HashMap<ResourceLocation, Map<ResourceLocation, ILocalResearch>>();
    private final Map<ResourceLocation, ILocalResearch> inProgress = new HashMap<ResourceLocation, ILocalResearch>();
    private final Set<ResourceLocation> isComplete = new HashSet<ResourceLocation>();
    private final Set<ResourceLocation> maxLevelResearchCompleted = new HashSet<ResourceLocation>();

    @Override
    public ILocalResearch getResearch(ResourceLocation branch, ResourceLocation id) {
        if (!this.researchTree.containsKey(branch)) {
            return null;
        }
        return this.researchTree.get(branch).get(id);
    }

    @Override
    public boolean hasCompletedResearch(ResourceLocation researchId) {
        if (IGlobalResearchTree.getInstance().hasResearch(researchId)) {
            return this.isComplete.contains(researchId);
        }
        return true;
    }

    @Override
    public void addResearch(ResourceLocation branch, ILocalResearch research) {
        if (!this.researchTree.containsKey(branch)) {
            this.researchTree.put(branch, new HashMap());
        }
        if (!this.researchTree.get(branch).containsKey(research.getId())) {
            this.researchTree.get(branch).put(research.getId(), research);
        }
        if (research.getState() == ResearchState.IN_PROGRESS) {
            this.inProgress.put(research.getId(), research);
        } else if (research.getState() == ResearchState.FINISHED) {
            this.inProgress.remove(research.getId());
            this.isComplete.add(research.getId());
        }
        if (research.getDepth() == 6) {
            this.maxLevelResearchCompleted.add(branch);
        }
    }

    @Override
    public boolean branchFinishedHighestLevel(ResourceLocation branch) {
        return this.maxLevelResearchCompleted.contains(branch);
    }

    @Override
    public List<ILocalResearch> getResearchInProgress() {
        return ImmutableList.copyOf(this.inProgress.values());
    }

    @Override
    public void finishResearch(ResourceLocation id) {
        this.inProgress.remove(id);
        this.isComplete.add(id);
    }

    @Override
    public void attemptBeginResearch(PlayerEntity player, IColony colony, IGlobalResearch research) {
        if (colony.getResearchManager().getResearchTree().getResearch(research.getBranch(), research.getId()) == null) {
            if (player.func_184812_l_()) {
                research.startResearch(colony.getResearchManager().getResearchTree());
                if (((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().researchCreativeCompletion.get()).booleanValue()) {
                    colony.getResearchManager().getResearchTree().getResearch(research.getBranch(), research.getId()).setProgress(IGlobalResearchTree.getInstance().getBranchData(research.getBranch()).getBaseTime(research.getDepth()));
                }
                SoundUtils.playSuccessSound(player, player.func_233580_cy_());
                return;
            }
            InvWrapper playerInv = new InvWrapper((IInventory)player.field_71071_by);
            if (!research.hasEnoughResources((IItemHandler)playerInv)) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.costnotavailable", new Object[]{research.getName()}), player.func_110124_au());
                SoundUtils.playErrorSound(player, player.func_233580_cy_());
                return;
            }
            if (!research.getResearchRequirement().isEmpty()) {
                for (IResearchRequirement requirement : research.getResearchRequirement()) {
                    if (requirement.isFulfilled(colony)) continue;
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.requirementnotmet"), player.func_110124_au());
                    SoundUtils.playErrorSound(player, player.func_233580_cy_());
                    return;
                }
            }
            for (ItemStorage cost : research.getCostList()) {
                List<Integer> slotsWithMaterial = InventoryUtils.findAllSlotsInItemHandlerWith((IItemHandler)playerInv, stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, cost.getItemStack(), !cost.ignoreDamageValue(), !cost.ignoreNBT()));
                int amount = cost.getAmount();
                for (Integer slotNum : slotsWithMaterial) {
                    if ((amount -= playerInv.extractItem(slotNum.intValue(), amount, false).func_190916_E()) <= 0) break;
                }
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.started", new Object[]{research.getName()}), player.func_110124_au());
            research.startResearch(colony.getResearchManager().getResearchTree());
            SoundUtils.playSuccessSound(player, player.func_233580_cy_());
        } else if (player.func_184812_l_()) {
            if (((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().researchCreativeCompletion.get()).booleanValue()) {
                colony.getResearchManager().getResearchTree().getResearch(research.getBranch(), research.getId()).setProgress(IGlobalResearchTree.getInstance().getBranchData(research.getBranch()).getBaseTime(research.getDepth()));
            }
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.alreadystarted"), player.func_110124_au());
            SoundUtils.playErrorSound(player, player.func_233580_cy_());
        }
        colony.markDirty();
    }

    @Override
    public void attemptResetResearch(PlayerEntity player, IColony colony, ILocalResearch research) {
        if (research.getState() == ResearchState.IN_PROGRESS) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.stopped", new Object[]{IGlobalResearchTree.getInstance().getResearch(research.getBranch(), research.getId()).getName()}), player.func_110124_au());
            SoundUtils.playSuccessSound(player, player.func_233580_cy_());
            this.removeResearch(research.getBranch(), research.getId());
        } else if (research.getState() == ResearchState.FINISHED) {
            for (ResourceLocation childIds : IGlobalResearchTree.getInstance().getResearch(research.getBranch(), research.getId()).getChildren()) {
                if (this.researchTree.get(research.getBranch()).get(childIds) == null) continue;
                player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.undo.haschilds"), player.func_110124_au());
                SoundUtils.playErrorSound(player, player.func_233580_cy_());
                return;
            }
            if (!player.func_184812_l_()) {
                List<ItemStorage> costList = IGlobalResearchTree.getInstance().getResearchResetCosts();
                InvWrapper playerInv = new InvWrapper((IInventory)player.field_71071_by);
                for (ItemStorage cost : costList) {
                    int count = InventoryUtils.getItemCountInItemHandler((IItemHandler)playerInv, stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, cost.getItemStack(), !cost.ignoreDamageValue(), !cost.ignoreNBT()));
                    if (count >= cost.getAmount()) continue;
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.costnotavailable", new Object[]{IGlobalResearchTree.getInstance().getResearch(research.getBranch(), research.getId()).getName()}), player.func_110124_au());
                    SoundUtils.playErrorSound(player, player.func_233580_cy_());
                    return;
                }
                for (ItemStorage cost : costList) {
                    List<Integer> slotsWithMaterial = InventoryUtils.findAllSlotsInItemHandlerWith((IItemHandler)playerInv, stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, cost.getItemStack(), !cost.ignoreDamageValue(), !cost.ignoreNBT()));
                    int amount = cost.getAmount();
                    for (Integer slotNum : slotsWithMaterial) {
                        if ((amount -= playerInv.extractItem(slotNum.intValue(), amount, false).func_190916_E()) <= 0) break;
                    }
                }
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.undo", new Object[]{IGlobalResearchTree.getInstance().getResearch(research.getBranch(), research.getId()).getName()}), player.func_110124_au());
            SoundUtils.playSuccessSound(player, player.func_233580_cy_());
            this.removeResearch(research.getBranch(), research.getId());
            this.resetEffects(colony);
        }
        colony.markDirty();
    }

    private void removeResearch(ResourceLocation branch, ResourceLocation id) {
        if (!this.researchTree.get(branch).containsKey(id)) {
            Log.getLogger().warn("Something went wrong: player attempted to reset research that does not exist or is not started");
        }
        this.researchTree.get(branch).remove(id);
        this.inProgress.remove(id);
        this.isComplete.remove(id);
        if (IGlobalResearchTree.getInstance().getResearch(branch, id).getDepth() == 6) {
            this.maxLevelResearchCompleted.remove(branch);
        }
    }

    private void resetEffects(IColony colony) {
        if (colony != null) {
            colony.getResearchManager().getResearchEffects().removeAllEffects();
            for (Map.Entry<ResourceLocation, Map<ResourceLocation, ILocalResearch>> branch : this.researchTree.entrySet()) {
                for (Map.Entry<ResourceLocation, ILocalResearch> research : branch.getValue().entrySet()) {
                    if (research.getValue().getState() != ResearchState.FINISHED) continue;
                    for (IResearchEffect<?> effect : IGlobalResearchTree.getInstance().getResearch(branch.getKey(), research.getValue().getId()).getEffects()) {
                        colony.getResearchManager().getResearchEffects().applyEffect(effect);
                    }
                }
            }
        }
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        @NotNull ListNBT researchList = this.researchTree.values().stream().flatMap(map -> map.values().stream()).map(research -> StandardFactoryController.getInstance().serialize(research)).collect(NBTUtils.toListNBT());
        compound.func_218657_a("researchTree", (INBT)researchList);
    }

    @Override
    public void readFromNBT(CompoundNBT compound, IResearchEffectManager effects) {
        this.researchTree.clear();
        this.inProgress.clear();
        this.isComplete.clear();
        this.maxLevelResearchCompleted.clear();
        NBTUtils.streamCompound(compound.func_150295_c("researchTree", 10)).map(researchCompound -> (ILocalResearch)StandardFactoryController.getInstance().deserialize((CompoundNBT)researchCompound)).forEach(research -> {
            if (!MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().hasResearch(research.getBranch(), research.getId())) {
                int progress;
                ResearchState currentState;
                if (ResearchCompatMap.updateMap.containsKey(research.getId().func_110623_a())) {
                    currentState = research.getState();
                    progress = research.getProgress();
                    research = new LocalResearch(ResearchCompatMap.updateMap.get(research.getId().func_110623_a()), new ResourceLocation("minecolonies", research.getBranch().func_110623_a()), research.getDepth());
                    research.setState(currentState);
                    research.setProgress(progress);
                    Log.getLogger().warn("Research " + research.getId().func_110623_a() + " was in colony save file, and was updated to " + research.getId());
                } else if (research.getBranch().func_110624_b().contains("minecraft")) {
                    currentState = research.getState();
                    progress = research.getProgress();
                    research = new LocalResearch(new ResourceLocation("minecolonies", research.getId().func_110623_a()), new ResourceLocation("minecolonies", research.getBranch().func_110623_a()), research.getDepth());
                    research.setState(currentState);
                    research.setProgress(progress);
                } else if (((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().researchDebugLog.get()).booleanValue()) {
                    Log.getLogger().warn("Research " + research.getId() + " was in colony save file, but was not in CompatMap.");
                }
            }
            if (research.getState() == ResearchState.FINISHED) {
                if (MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().hasResearch(research.getBranch(), research.getId())) {
                    for (IResearchEffect<?> effect : MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().getResearch(research.getBranch(), research.getId()).getEffects()) {
                        effects.applyEffect(effect);
                    }
                } else if (((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().researchDebugLog.get()).booleanValue()) {
                    Log.getLogger().warn("Research " + research.getId() + " was in colony save file, but not found as valid current research.  Progress on this research may be reset.");
                }
            }
            this.addResearch(research.getBranch(), (ILocalResearch)research);
        });
    }
}

