/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.google.gson.JsonObject;
import com.minecolonies.api.research.IGlobalResearchBranch;
import com.minecolonies.api.research.ResearchBranchType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class GlobalResearchBranch
implements IGlobalResearchBranch {
    public static final String RESEARCH_BRANCH_NAME_PROP = "branch-name";
    private static final String RESEARCH_SUBTITLE_PROP = "subtitle";
    public static final String RESEARCH_BRANCH_TYPE_PROP = "branch-type";
    public static final String RESEARCH_BASE_TIME_PROP = "base-time";
    private static final String RESEARCH_HIDDEN_PROP = "hidden";
    private static final String RESEARCH_SORT_PROP = "sortOrder";
    private final TranslationTextComponent name;
    private final TranslationTextComponent subtitle;
    private final ResearchBranchType type;
    private final double baseTime;
    private final int sortOrder;
    private final boolean hidden;

    @Override
    public TranslationTextComponent getName() {
        return this.name;
    }

    @Override
    public TranslationTextComponent getSubtitle() {
        return this.subtitle;
    }

    @Override
    public int getBaseTime(int depth) {
        return (int)(144.0 * this.baseTime * Math.pow(2.0, depth - 1));
    }

    @Override
    public double getHoursTime(int depth) {
        return 144.0 * this.baseTime * Math.pow(2.0, depth - 1) / 288.0;
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public ResearchBranchType getType() {
        return this.type;
    }

    @Override
    public boolean getHidden() {
        return this.hidden;
    }

    public GlobalResearchBranch(ResourceLocation id) {
        this.name = id.func_110623_a().isEmpty() ? new TranslationTextComponent("") : new TranslationTextComponent(id.func_110623_a().substring(0, 1).toUpperCase() + id.func_110623_a().substring(1));
        this.subtitle = new TranslationTextComponent("");
        this.baseTime = 1.0;
        this.type = ResearchBranchType.DEFAULT;
        this.hidden = false;
        this.sortOrder = 1000;
    }

    public GlobalResearchBranch(ResourceLocation id, JsonObject researchJson) {
        this.name = researchJson.has(RESEARCH_BRANCH_NAME_PROP) && researchJson.get(RESEARCH_BRANCH_NAME_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_BRANCH_NAME_PROP).getAsJsonPrimitive().isString() ? new TranslationTextComponent(researchJson.get(RESEARCH_BRANCH_NAME_PROP).getAsJsonPrimitive().getAsString()) : (id.func_110623_a().isEmpty() ? new TranslationTextComponent("") : new TranslationTextComponent(id.func_110623_a().substring(0, 1).toUpperCase() + id.func_110623_a().substring(1)));
        this.subtitle = researchJson.has(RESEARCH_SUBTITLE_PROP) && researchJson.get(RESEARCH_SUBTITLE_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_SUBTITLE_PROP).getAsJsonPrimitive().isString() ? new TranslationTextComponent(researchJson.get(RESEARCH_SUBTITLE_PROP).getAsJsonPrimitive().getAsString()) : new TranslationTextComponent("");
        this.baseTime = researchJson.has(RESEARCH_BASE_TIME_PROP) && researchJson.get(RESEARCH_BASE_TIME_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_BASE_TIME_PROP).getAsJsonPrimitive().isNumber() ? researchJson.get(RESEARCH_BASE_TIME_PROP).getAsJsonPrimitive().getAsDouble() : 1.0;
        this.sortOrder = researchJson.has(RESEARCH_SORT_PROP) && researchJson.get(RESEARCH_SORT_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_SORT_PROP).getAsJsonPrimitive().isNumber() ? researchJson.get(RESEARCH_SORT_PROP).getAsJsonPrimitive().getAsInt() : 1000;
        this.type = researchJson.has(RESEARCH_BRANCH_TYPE_PROP) && researchJson.get(RESEARCH_BRANCH_TYPE_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_BRANCH_TYPE_PROP).getAsJsonPrimitive().isString() ? ResearchBranchType.valueOfTag(researchJson.get(RESEARCH_BRANCH_TYPE_PROP).getAsJsonPrimitive().getAsString()) : ResearchBranchType.DEFAULT;
        this.hidden = researchJson.has(RESEARCH_HIDDEN_PROP) && researchJson.get(RESEARCH_HIDDEN_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_HIDDEN_PROP).getAsJsonPrimitive().isBoolean() ? researchJson.get(RESEARCH_HIDDEN_PROP).getAsJsonPrimitive().getAsBoolean() : false;
    }

    public GlobalResearchBranch(CompoundNBT nbt) {
        this.name = new TranslationTextComponent(nbt.func_74779_i(RESEARCH_BRANCH_NAME_PROP));
        this.subtitle = new TranslationTextComponent(nbt.func_74779_i(RESEARCH_SUBTITLE_PROP));
        this.type = ResearchBranchType.valueOfTag(nbt.func_74779_i(RESEARCH_BRANCH_TYPE_PROP));
        this.baseTime = nbt.func_74769_h(RESEARCH_BASE_TIME_PROP);
        this.sortOrder = nbt.func_74762_e(RESEARCH_SORT_PROP);
        this.hidden = nbt.func_74767_n(RESEARCH_HIDDEN_PROP);
    }

    @Override
    public CompoundNBT writeToNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a(RESEARCH_BRANCH_NAME_PROP, this.name.func_150268_i());
        nbt.func_74778_a(RESEARCH_SUBTITLE_PROP, this.subtitle.func_150268_i());
        nbt.func_74778_a(RESEARCH_BRANCH_TYPE_PROP, this.type.tag);
        nbt.func_74780_a(RESEARCH_BASE_TIME_PROP, this.baseTime);
        nbt.func_74768_a(RESEARCH_SORT_PROP, this.sortOrder);
        nbt.func_74757_a(RESEARCH_HIDDEN_PROP, this.hidden);
        return nbt;
    }
}

