/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.citizen;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class RestartCitizenMessage
extends AbstractColonyServerMessage {
    private int citizenID;

    public RestartCitizenMessage() {
    }

    public RestartCitizenMessage(@NotNull AbstractBuildingView building, int citizenID) {
        super(building.getColony());
        this.citizenID = citizenID;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.citizenID = buf.readInt();
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.writeInt(this.citizenID);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        ServerPlayerEntity player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        ICitizenData citizen = colony.getCitizenManager().getCivilian(this.citizenID);
        citizen.scheduleRestart(player);
        LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.gui.hiring.restartMessage", (Object[])new Object[]{citizen.getName()});
    }
}

