/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.worker;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import com.minecolonies.coremod.util.TeleportHelper;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class RecallCitizenMessage
extends AbstractBuildingServerMessage<IBuilding> {
    public RecallCitizenMessage() {
    }

    @Override
    protected void toBytesOverride(PacketBuffer buf) {
    }

    @Override
    protected void fromBytesOverride(PacketBuffer buf) {
    }

    public RecallCitizenMessage(IBuildingView building) {
        super(building);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        ArrayList<ICitizenData> citizens = new ArrayList<ICitizenData>(building.getAllAssignedCitizen());
        int i = 0;
        while (i < building.getAllAssignedCitizen().size()) {
            Optional<AbstractEntityCitizen> optionalEntityCitizen = ((ICitizenData)citizens.get(i)).getEntity();
            ICitizenData citizenData = (ICitizenData)citizens.get(i);
            if (!optionalEntityCitizen.isPresent()) {
                if (citizenData == null) {
                    Log.getLogger().warn("Citizen is AWOL and citizenData is null!");
                    return;
                }
                Log.getLogger().warn(String.format("Citizen #%d:%d has gone AWOL, respawning them!", colony.getID(), citizenData.getId()));
                citizenData.setNextRespawnPosition(EntityUtils.getSpawnPoint(colony.getWorld(), building.getPosition()));
                citizenData.updateEntityIfNecessary();
            } else if (optionalEntityCitizen.get().getTicksExisted() == 0) {
                citizenData.getEntity().ifPresent(Entity::func_70106_y);
                citizenData.updateEntityIfNecessary();
            }
            BlockPos loc = building.getPosition();
            if (optionalEntityCitizen.isPresent() && !TeleportHelper.teleportCitizen(optionalEntityCitizen.get(), colony.getWorld(), loc)) {
                ServerPlayerEntity player = ctxIn.getSender();
                if (player == null) {
                    return;
                }
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.workerhuts.recallFail", (Object[])new Object[0]);
            }
            ++i;
        }
        return;
    }
}

