/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.guard;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class GuardSetMinePosMessage
extends AbstractBuildingServerMessage<AbstractBuildingGuards> {
    private BlockPos minePos;
    private Boolean hasMinePos = false;

    public GuardSetMinePosMessage() {
    }

    public GuardSetMinePosMessage(@NotNull AbstractBuildingGuards.View building, BlockPos minePos) {
        super(building);
        this.minePos = minePos;
        this.hasMinePos = true;
    }

    public GuardSetMinePosMessage(@NotNull AbstractBuildingGuards.View building) {
        super(building);
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.hasMinePos = buf.readBoolean();
        if (this.hasMinePos.booleanValue()) {
            this.minePos = buf.func_179259_c();
        }
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.writeBoolean(this.hasMinePos.booleanValue());
        if (this.hasMinePos.booleanValue()) {
            buf.func_179255_a(this.minePos);
        }
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, AbstractBuildingGuards building) {
        IBuilding miner = this.minePos == null ? building.getColony().getBuildingManager().getBuilding(building.getMinePos()) : building.getColony().getBuildingManager().getBuilding(this.minePos);
        if (miner instanceof BuildingMiner) {
            building.setMinePos(this.minePos);
        }
    }
}

