/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.api.inventory.container.ContainerCraftingFurnace;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class OpenCraftingGUIMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private String id;

    public OpenCraftingGUIMessage() {
    }

    public OpenCraftingGUIMessage(@NotNull AbstractBuildingView building, String id) {
        super(building);
        this.id = id;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.id = buf.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.func_180714_a(this.id);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, final IBuilding building) {
        ServerPlayerEntity player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        final AbstractCraftingBuildingModule module = building.getModuleMatching(AbstractCraftingBuildingModule.class, m -> m.getId().equals(this.id));
        if (module.canLearnFurnaceRecipes()) {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new INamedContainerProvider(){

                @NotNull
                public ITextComponent func_145748_c_() {
                    return new StringTextComponent("Furnace Crafting GUI");
                }

                @NotNull
                public Container createMenu(int id, @NotNull PlayerInventory inv, @NotNull PlayerEntity player) {
                    return new ContainerCraftingFurnace(id, inv, building.getID(), module.getId());
                }
            }, buffer -> new PacketBuffer((ByteBuf)buffer.func_179255_a(building.getID()).func_180714_a(module.getId())));
        } else {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new INamedContainerProvider(){

                @NotNull
                public ITextComponent func_145748_c_() {
                    return new StringTextComponent("Crafting GUI");
                }

                @NotNull
                public Container createMenu(int id, @NotNull PlayerInventory inv, @NotNull PlayerEntity player) {
                    return new ContainerCrafting(id, inv, module.canLearnLargeRecipes(), building.getID(), module.getId());
                }
            }, buffer -> new PacketBuffer(buffer.writeBoolean(module.canLearnLargeRecipes())).func_179255_a(building.getID()).func_180714_a(module.getId()));
        }
    }
}

