/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.minecolonies.api.network.IMessage;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class VanillaParticleMessage
implements IMessage {
    private double x;
    private double y;
    private double z;
    private BasicParticleType type;

    public VanillaParticleMessage() {
    }

    public VanillaParticleMessage(double x, double y, double z, BasicParticleType type) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = type;
    }

    @Override
    public void fromBytes(PacketBuffer byteBuf) {
        this.x = byteBuf.readDouble();
        this.y = byteBuf.readDouble();
        this.z = byteBuf.readDouble();
        this.type = (BasicParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(byteBuf.func_192575_l());
    }

    @Override
    public void toBytes(PacketBuffer byteBuf) {
        byteBuf.writeDouble(this.x);
        byteBuf.writeDouble(this.y);
        byteBuf.writeDouble(this.z);
        byteBuf.func_192572_a(this.type.getRegistryName());
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        this.spawnParticles(this.type, (World)world, this.x, this.y, this.z);
    }

    private void spawnParticles(BasicParticleType particleType, World world, double x, double y, double z) {
        Random rand = new Random();
        for (int i = 0; i < 5; ++i) {
            double d0 = rand.nextGaussian() * 0.02;
            double d1 = rand.nextGaussian() * 0.02;
            double d2 = rand.nextGaussian() * 0.02;
            world.func_195594_a((IParticleData)particleType, x + (double)rand.nextFloat() * 0.6 * 2.0 - 0.6, y + 1.0 + (double)rand.nextFloat() * 1.8, z + (double)rand.nextFloat() * 0.6 * 2.0 - 0.6, d0, d1, d2);
        }
    }
}

