/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.lib.BlueprintTagUtils;
import com.ldtteam.structurize.placement.handlers.placement.PlacementError;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.creativetab.ModCreativeTabs;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSupplyChestDeployer
extends AbstractItemMinecolonies {
    private static final String SUPPLY_SHIP_STRUCTURE_NAME = "supplyship";
    private static final String SUPPLY_SHIP_STRUCTURE_NAME_NETHER = "nethership";
    private static final int OFFSET_DISTANCE = 14;
    private static final int OFFSET_LEFT = 5;
    private static final int OFFSET_Y = 0;
    private static final int SCAN_HEIGHT = 7;
    private static final int DEFAULT_WATER_LEVELS = 3;

    public ItemSupplyChestDeployer(Item.Properties properties) {
        super("supplychestdeployer", properties.func_200917_a(1).func_200916_a(ModCreativeTabs.MINECOLONIES));
    }

    @NotNull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        if (ctx.func_195991_k().field_72995_K) {
            if (!((Boolean)MineColonies.getConfig().getServer().allowOtherDimColonies.get()).booleanValue() && !WorldUtil.isOverworldType(ctx.func_195991_k())) {
                return ActionResultType.FAIL;
            }
            this.placeSupplyShip(ctx.func_195991_k(), ctx.func_195995_a().func_177972_a(ctx.func_196000_l()), ctx.func_195999_j().func_174811_aO());
        }
        return ActionResultType.FAIL;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            if (!((Boolean)MineColonies.getConfig().getServer().allowOtherDimColonies.get()).booleanValue() && !WorldUtil.isOverworldType(worldIn)) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)playerIn, (String)"com.minecolonies.coremod.dimension.no", (Object[])new Object[0]);
                return new ActionResult(ActionResultType.FAIL, (Object)stack);
            }
            this.placeSupplyShip(worldIn, null, playerIn.func_174811_aO());
        }
        return new ActionResult(ActionResultType.FAIL, (Object)stack);
    }

    private void placeSupplyShip(World world, @Nullable BlockPos pos, @NotNull Direction direction) {
        int rotations;
        BlockPos tempPos;
        String name;
        String string = name = WorldUtil.isNetherType(world) ? SUPPLY_SHIP_STRUCTURE_NAME_NETHER : SUPPLY_SHIP_STRUCTURE_NAME;
        if (pos == null) {
            MineColonies.proxy.openBuildToolWindow(null, name, 0, 3);
            return;
        }
        switch (direction) {
            case SOUTH: {
                tempPos = pos.func_177982_a(5, 0, 14);
                rotations = 3;
                break;
            }
            case NORTH: {
                tempPos = pos.func_177982_a(-5, 0, -14);
                rotations = 1;
                break;
            }
            case EAST: {
                tempPos = pos.func_177982_a(14, 0, -5);
                rotations = 2;
                break;
            }
            default: {
                tempPos = pos.func_177982_a(-14, 0, 5);
                rotations = 0;
            }
        }
        MineColonies.proxy.openBuildToolWindow(tempPos, name, rotations, 3);
    }

    public static boolean canShipBePlaced(@NotNull World world, @NotNull BlockPos pos, Blueprint ship, @NotNull List<PlacementError> placementErrorList, PlayerEntity placer) {
        if (((Boolean)MineColonies.getConfig().getServer().noSupplyPlacementRestrictions.get()).booleanValue()) {
            return true;
        }
        short sizeX = ship.getSizeX();
        short sizeZ = ship.getSizeZ();
        int waterLevel = BlueprintTagUtils.getNumberOfGroundLevels((Blueprint)ship, (int)3);
        BlockPos zeroPos = pos.func_177973_b((Vector3i)ship.getPrimaryBlockOffset());
        for (int z = zeroPos.func_177952_p(); z < zeroPos.func_177952_p() + sizeZ; ++z) {
            for (int x = zeroPos.func_177958_n(); x < zeroPos.func_177958_n() + sizeX; ++x) {
                for (int y = zeroPos.func_177956_o(); y <= zeroPos.func_177956_o() + waterLevel + 7; ++y) {
                    if (y < zeroPos.func_177956_o() + waterLevel) {
                        ItemSupplyChestDeployer.checkFluidAndNotInColony(world, new BlockPos(x, y, z), placementErrorList, placer);
                        continue;
                    }
                    if (!world.func_180495_p(new BlockPos(x, y, z)).func_185904_a().func_76220_a()) continue;
                    PlacementError placementError = new PlacementError(PlacementError.PlacementErrorType.NEEDS_AIR_ABOVE, new BlockPos(x, y, z));
                    placementErrorList.add(placementError);
                }
            }
        }
        return placementErrorList.isEmpty();
    }

    private static void checkFluidAndNotInColony(World world, BlockPos pos, @NotNull List<PlacementError> placementErrorList, PlayerEntity placer) {
        PlacementError placementError;
        boolean isOverworld = WorldUtil.isOverworldType(world);
        boolean isWater = BlockUtils.isWater((BlockState)world.func_180495_p(pos));
        boolean notInAnyColony = ItemSupplyChestDeployer.hasPlacePermission(world, pos, placer);
        if (!isWater && isOverworld) {
            placementError = new PlacementError(PlacementError.PlacementErrorType.NOT_WATER, pos);
            placementErrorList.add(placementError);
        } else if (!world.func_180495_p(pos).func_204520_s().func_206886_c().func_207187_a((Fluid)Fluids.field_204547_b) && !isOverworld) {
            placementError = new PlacementError(PlacementError.PlacementErrorType.NOT_WATER, pos);
            placementErrorList.add(placementError);
        }
        if (!notInAnyColony) {
            placementError = new PlacementError(PlacementError.PlacementErrorType.INSIDE_COLONY, pos);
            placementErrorList.add(placementError);
        }
    }

    private static boolean hasPlacePermission(World world, BlockPos pos, PlayerEntity placer) {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, pos);
        return colony == null || colony.getPermissions().hasPermission(placer, Action.PLACE_BLOCKS);
    }
}

