/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.items.AbstractItemScroll;
import com.minecolonies.coremod.network.messages.client.VanillaParticleMessage;
import com.minecolonies.coremod.util.TeleportHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemScrollColonyAreaTP
extends AbstractItemScroll {
    public ItemScrollColonyAreaTP(Item.Properties properties) {
        super("scroll_area_tp", properties);
    }

    @Override
    public int func_77626_a(ItemStack itemStack) {
        return 64;
    }

    @Override
    protected ItemStack onItemUseSuccess(ItemStack itemStack, World world, ServerPlayerEntity player) {
        if (world.field_73012_v.nextInt(10) == 0) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("minecolonies.scroll.failed" + (world.field_73012_v.nextInt(10) + 1)).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD)), true);
            itemStack.func_190918_g(1);
            if (!ItemStackUtils.isEmpty(itemStack).booleanValue()) {
                player.func_146097_a(itemStack.func_77946_l(), true, false);
                itemStack.func_190920_e(0);
            }
            for (ServerPlayerEntity sPlayer : this.getAffectedPlayers(player)) {
                SoundUtils.playSoundForPlayer(sPlayer, SoundEvents.field_191248_br, 0.3f, 1.0f);
            }
        } else {
            for (ServerPlayerEntity sPlayer : this.getAffectedPlayers(player)) {
                this.doTeleport(sPlayer, this.getColony(itemStack), itemStack);
                SoundUtils.playSoundForPlayer(sPlayer, SoundEvents.field_194228_if, 0.1f, 1.0f);
            }
            itemStack.func_190918_g(1);
        }
        return itemStack;
    }

    @Override
    protected boolean needsColony() {
        return true;
    }

    protected void doTeleport(ServerPlayerEntity player, IColony colony, ItemStack stack) {
        TeleportHelper.colonyTeleport(player, colony);
    }

    public void func_219972_a(World worldIn, LivingEntity entity, ItemStack stack, int count) {
        if (!worldIn.field_72995_K && worldIn.func_82737_E() % 5L == 0L && entity instanceof PlayerEntity) {
            ServerPlayerEntity sPlayer = (ServerPlayerEntity)entity;
            for (Entity entity2 : this.getAffectedPlayers(sPlayer)) {
                Network.getNetwork().sendToTrackingEntity(new VanillaParticleMessage(entity2.func_226277_ct_(), entity2.func_226278_cu_(), entity2.func_226281_cx_(), ParticleTypes.field_197590_A), entity2);
            }
            Network.getNetwork().sendToPlayer(new VanillaParticleMessage(sPlayer.func_226277_ct_(), sPlayer.func_226278_cu_(), sPlayer.func_226281_cx_(), ParticleTypes.field_197590_A), sPlayer);
        }
    }

    private List<ServerPlayerEntity> getAffectedPlayers(ServerPlayerEntity user) {
        return user.field_70170_p.func_225317_b(ServerPlayerEntity.class, user.func_174813_aQ().func_72314_b(10.0, 2.0, 10.0));
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        IFormattableTextComponent guiHint = LanguageHandler.buildChatComponent((String)"item.minecolonies.scroll_area_tp.tip", (Object[])new Object[0]);
        guiHint.func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_GREEN));
        tooltip.add((ITextComponent)guiHint);
        String colonyDesc = new TranslationTextComponent("item.minecolonies.scroll.colony.none").getString();
        if (stack.func_196082_o().func_74764_b("desc")) {
            colonyDesc = stack.func_196082_o().func_74779_i("desc");
        } else {
            IColony colony = this.getColonyView(stack);
            if (colony != null) {
                colonyDesc = colony.getName();
                stack.func_196082_o().func_74778_a("desc", colonyDesc);
            }
        }
        TranslationTextComponent guiHint2 = new TranslationTextComponent("item.minecolonies.scroll.colony.tip", new Object[]{colonyDesc});
        guiHint2.func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD));
        tooltip.add((ITextComponent)guiHint2);
    }
}

