/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemScepterGuard
extends AbstractItemMinecolonies {
    private static final String TAG_LAST_POS = "lastPos";

    public ItemScepterGuard(Item.Properties properties) {
        super("scepterguard", properties.func_200917_a(1).func_200918_c(2));
    }

    @NotNull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        BlockPos lastPos;
        CompoundNBT compound;
        if (ctx.func_195991_k().field_72995_K) {
            return ActionResultType.FAIL;
        }
        ItemStack scepter = ctx.func_195999_j().func_184586_b(ctx.func_221531_n());
        if (!scepter.func_77942_o()) {
            scepter.func_77982_d(new CompoundNBT());
        }
        if ((compound = scepter.func_77978_p()).func_150296_c().contains(TAG_LAST_POS) && (lastPos = BlockPosUtil.read(compound, TAG_LAST_POS)).equals((Object)ctx.func_195995_a())) {
            ctx.func_195999_j().field_71071_by.func_70304_b(ctx.func_195999_j().field_71071_by.field_70461_c);
            LanguageHandler.sendPlayerMessage((PlayerEntity)ctx.func_195999_j(), (String)"com.minecolonies.coremod.job.guard.toolDoubleClick", (Object[])new Object[0]);
            return ActionResultType.FAIL;
        }
        return ItemScepterGuard.handleItemUsage(ctx.func_195991_k(), ctx.func_195995_a(), compound, ctx.func_195999_j());
    }

    @NotNull
    private static ActionResultType handleItemUsage(World worldIn, BlockPos pos, CompoundNBT compound, PlayerEntity playerIn) {
        if (!compound.func_150296_c().contains("id")) {
            return ActionResultType.FAIL;
        }
        IColony colony = IColonyManager.getInstance().getColonyByWorld(compound.func_74762_e("id"), worldIn);
        if (colony == null) {
            return ActionResultType.FAIL;
        }
        BlockPos guardTower = BlockPosUtil.read(compound, "pos");
        IBuilding hut = colony.getBuildingManager().getBuilding(guardTower);
        if (!(hut instanceof AbstractBuildingGuards)) {
            return ActionResultType.FAIL;
        }
        IGuardBuilding tower = (IGuardBuilding)hut;
        if (BlockPosUtil.getDistance2D(pos, guardTower) > (long)tower.getPatrolDistance()) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)playerIn, (String)"com.minecolonies.coremod.job.guard.toolClickGuardTooFar", (Object[])new Object[0]);
            return ActionResultType.FAIL;
        }
        if (hut.getSetting(AbstractBuildingGuards.GUARD_TASK).getValue().equals("com.minecolonies.core.guard.setting.guard")) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)playerIn, (String)"com.minecolonies.coremod.job.guard.toolclickguard", (Object[])new Object[]{pos});
            tower.setGuardPos(pos);
            playerIn.field_71071_by.func_70304_b(playerIn.field_71071_by.field_70461_c);
        } else {
            if (!compound.func_150296_c().contains(TAG_LAST_POS)) {
                tower.resetPatrolTargets();
            }
            tower.addPatrolTargets(pos);
            LanguageHandler.sendPlayerMessage((PlayerEntity)playerIn, (String)"com.minecolonies.coremod.job.guard.toolclickpatrol", (Object[])new Object[]{pos});
        }
        BlockPosUtil.write(compound, TAG_LAST_POS, pos);
        return ActionResultType.SUCCESS;
    }
}

