/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.creativetab.ModCreativeTabs;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemClipboard
extends AbstractItemMinecolonies {
    private static final String TAG_COLONY = "colony";

    public ItemClipboard(Item.Properties properties) {
        super("clipboard", properties.func_200917_a(64).func_200916_a(ModCreativeTabs.MINECOLONIES));
    }

    @NotNull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        ItemStack clipboard = ctx.func_195999_j().func_184586_b(ctx.func_221531_n());
        CompoundNBT compound = ItemClipboard.checkForCompound(clipboard);
        TileEntity entity = ctx.func_195991_k().func_175625_s(ctx.func_195995_a());
        if (entity instanceof TileEntityColonyBuilding) {
            compound.func_74768_a(TAG_COLONY, ((AbstractTileEntityColonyBuilding)entity).getColonyId());
            if (!ctx.func_195991_k().field_72995_K) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)ctx.func_195999_j(), (String)"com.minecolonies.coremod.item.clipboard.registered", (Object[])new Object[]{((AbstractTileEntityColonyBuilding)entity).getColony().getName()});
            }
        } else if (ctx.func_195991_k().field_72995_K) {
            ItemClipboard.openWindow(compound, ctx.func_195991_k(), ctx.func_195999_j());
        }
        return ActionResultType.SUCCESS;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack clipboard = playerIn.func_184586_b(hand);
        if (!worldIn.field_72995_K) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)clipboard);
        }
        ItemClipboard.openWindow(ItemClipboard.checkForCompound(clipboard), worldIn, playerIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)clipboard);
    }

    private static CompoundNBT checkForCompound(ItemStack clipboard) {
        if (!clipboard.func_77942_o()) {
            clipboard.func_77982_d(new CompoundNBT());
        }
        return clipboard.func_77978_p();
    }

    private static void openWindow(CompoundNBT compound, World world, PlayerEntity player) {
        if (compound.func_150296_c().contains(TAG_COLONY)) {
            IColonyView colonyView = IColonyManager.getInstance().getColonyView(compound.func_74762_e(TAG_COLONY), (RegistryKey<World>)world.func_234923_W_());
            if (colonyView != null) {
                MineColonies.proxy.openClipboardWindow(colonyView);
            }
        } else {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.item.clipboard.needcolony"), true);
        }
    }
}

