/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation.defaults;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.research.AbstractResearchProvider;
import com.minecolonies.api.research.ResearchBranchType;
import com.minecolonies.api.research.util.ResearchConstants;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;

public class DefaultResearchProvider
extends AbstractResearchProvider {
    private static final ResourceLocation CIVIL = new ResourceLocation("minecolonies", "civilian");
    private static final ResourceLocation COMBAT = new ResourceLocation("minecolonies", "combat");
    private static final ResourceLocation TECH = new ResourceLocation("minecolonies", "technology");
    private static final ResourceLocation UNLOCK = new ResourceLocation("minecolonies", "unlockable");

    public DefaultResearchProvider(DataGenerator generator) {
        super(generator);
    }

    @Override
    public Collection<AbstractResearchProvider.ResearchBranch> getResearchBranchCollection() {
        ArrayList<AbstractResearchProvider.ResearchBranch> branches = new ArrayList<AbstractResearchProvider.ResearchBranch>();
        branches.add(new AbstractResearchProvider.ResearchBranch(CIVIL).setTranslatedBranchName("Civilian").setBranchTimeMultiplier(1.0).setBranchSortOrder(50));
        branches.add(new AbstractResearchProvider.ResearchBranch(COMBAT).setTranslatedBranchName("Combat").setBranchTimeMultiplier(1.0).setBranchSortOrder(100));
        branches.add(new AbstractResearchProvider.ResearchBranch(TECH).setTranslatedBranchName("Technology").setBranchTimeMultiplier(1.0).setBranchSortOrder(150));
        branches.add(new AbstractResearchProvider.ResearchBranch(UNLOCK).setTranslatedBranchName("Unlockables").setBranchTimeMultiplier(0.0).setBranchSortOrder(200).setBranchType(ResearchBranchType.UNLOCKABLES).setHidden(true));
        return branches;
    }

    @Override
    public Collection<AbstractResearchProvider.ResearchEffect> getResearchEffectCollection() {
        ArrayList<AbstractResearchProvider.ResearchEffect> effects = new ArrayList<AbstractResearchProvider.ResearchEffect>();
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.ARCHER_ARMOR).setTranslatedName("Archer Armor +%3$s%%").setLevels(new double[]{0.05, 0.1, 0.25, 0.5, 1.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.ARCHER_DAMAGE).setTranslatedName("Archer Damage +%s").setLevels(new double[]{0.5, 1.0, 1.5, 2.0, 4.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.ARMOR_DURABILITY).setTranslatedName("Guard Armor +%3$s%% Durability").setLevels(new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 1.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.BLOCK_ATTACKS).setTranslatedName("Knight Shield Blocking Chance +%3$s%%").setLevels(new double[]{0.05, 0.1, 0.25, 0.5}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.BLOCK_BREAK_SPEED).setTranslatedName("Citizen Block Break Speed +%3$s%%").setLevels(new double[]{0.1, 0.25, 0.5, 1.0, 2.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.BLOCK_PLACE_SPEED).setTranslatedName("Citizen Block Place Speed +%3$s%%").setLevels(new double[]{0.1, 0.25, 0.5, 1.0, 2.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.CITIZEN_CAP).setTranslatedName("Increase Max Citizens +%s").setLevels(new double[]{25.0, 75.0, 125.0, 1000.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.CITIZEN_INV_SLOTS).setTranslatedName("Citizen Inventory +%s Slots").setLevels(new double[]{9.0, 18.0, 27.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.DOUBLE_ARROWS).setTranslatedName("Archer Multishot +%3$s%%").setLevels(new double[]{0.05, 0.1, 0.25, 0.5}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.MECHANIC_ENHANCED_GATES).setTranslatedName("Gates Gain +100% Raider Swarm Resistance").setLevels(new double[]{5.0, 15.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.FARMING).setTranslatedName("Farmers Harvest +%3$s%% Crops").setLevels(new double[]{0.1, 0.25, 0.5, 0.75, 2.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.FLEEING_DAMAGE).setTranslatedName("Guards Take -%3$s%% Damage When Fleeing").setLevels(new double[]{0.2, 0.3, 0.4, 1.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.FLEEING_SPEED).setTranslatedName("Fleeing Guards Gain Swiftness %2$s").setLevels(new double[]{1.0, 2.0, 3.0, 5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.GROWTH).setTranslatedName("Child Growth Rate +%3$s%%").setLevels(new double[]{0.05, 0.1, 0.25, 0.5, 1.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.HAPPINESS).setTranslatedName("Citizen Happiness +%3$s%%").setLevels(new double[]{0.05, 0.1, 0.15, 0.2, 0.5}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.SATLIMIT).setTranslatedName("Healing Saturation Min %s").setLevels(new double[]{-0.5, -1.0, -1.5, -2.0, -5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.HEALTH_BOOST).setTranslatedName("Citizen HP +%s").setLevels(new double[]{2.0, 4.0, 6.0, 8.0, 10.0, 20.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.LEVELING).setTranslatedName("Citizen XP Growth +%3$s%%").setLevels(new double[]{0.05, 0.1, 0.25, 0.5, 1.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.MELEE_ARMOR).setTranslatedName("Knights Armor +%3$s%%").setLevels(new double[]{0.05, 0.1, 0.25, 0.5, 1.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.MELEE_DAMAGE).setTranslatedName("Knight Damage +%s").setLevels(new double[]{0.5, 1.0, 1.5, 2.0, 4.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.MINIMUM_STOCK).setTranslatedName("Buildings Can Minimum Stock %3$s%% More").setLevels(new double[]{0.5, 1.0, 2.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.MORE_ORES).setTranslatedName("Miners Find +%3$s%% More Ores").setLevels(new double[]{0.1, 0.25, 0.5, 1.0, 2.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.PODZOL_CHANCE).setTranslatedName("Composters Get +%3$s%% More Podzol").setLevels(new double[]{1.0, 2.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.RECIPES).setTranslatedName("Workers Can Learn +%3$s%% More Recipes").setLevels(new double[]{0.25, 0.5, 1.0, 2.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.REGENERATION).setTranslatedName("Citizen Regeneration +%3$s%%").setLevels(new double[]{0.1, 0.25, 0.5, 1.0, 2.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.SATURATION).setTranslatedName("Citizen Saturation Per Meal +%3$s%%").setLevels(new double[]{0.1, 0.25, 0.5, 1.0, 2.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.TEACHING).setTranslatedName("XP Gain When Studying +%3$s%%").setLevels(new double[]{0.05, 0.1, 0.25, 0.5, 1.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.TOOL_DURABILITY).setTranslatedName("Citizen Tools +%3$s%% Durability").setLevels(new double[]{0.05, 0.1, 0.25, 0.5, 0.9}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.WALKING).setTranslatedName("Citizen Walk Speed +%3$s%%").setLevels(new double[]{0.05, 0.1, 0.15, 0.25}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.WORK_LONGER).setTranslatedName("Citizen Work Day +%sH").setLevels(new double[]{1.0, 2.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.RESURRECT_CHANCE).setTranslatedName("Improve Resurrection Chance by +%3$s%%").setLevels(new double[]{0.01, 0.03}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.GRAVE_DECAY_BONUS).setTranslatedName("Citizen Graves Take %s More Minutes to Decay").setLevels(new double[]{2.0, 5.0}));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.ARCHER_USE_ARROWS).setTranslatedName("Archers Use Arrows For +2 Damage"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.CRUSHING_11).setTranslatedName("Crusher Recipes Cost -50%"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.KNIGHT_TAUNT).setTranslatedName("Knights Force Mobs to Target Them"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.FIRE_RES).setTranslatedName("Miners Have Fire and Lava Immunity"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.ARROW_PIERCE).setTranslatedName("Archers Gain Piercing II"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.PLANT_2).setTranslatedName("Plantations Grow Two Crops at Once"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.BEEKEEP_2).setTranslatedName("Beekeepers Can Harvest Both Honey Bottles and Combs at Once"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.RAILS).setTranslatedName("Citizens use Rails"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.VINES).setTranslatedName("Citizens can climb Vines"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.RETREAT).setTranslatedName("Guards Flee Under 20% HP"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.SHIELD_USAGE).setTranslatedName("Knights Unlock Shield Use"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.SLEEP_LESS).setTranslatedName("Guards Need %3$s%% Less Sleep"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.KNIGHT_WHIRLWIND).setTranslatedName("Knights Learn Special Attack That Damages and Knocks Back Nearby Enemies"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.WORKING_IN_RAIN).setTranslatedName("Citizens Work in Rain"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.UNDERTAKER_RUN).setTranslatedName("Undertaker unlocks run ability").setTranslatedSubtitle("Teach Undertaker the ability to run towards graves"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.USE_TOTEM).setTranslatedName("Undertaker gains the ability to use Totems of Undying to assist in Resurrection"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.RECIPE_MODE).setTranslatedName("Add the option to select recipes based on Warehouse stock"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ResearchConstants.BUILDER_MODE).setTranslatedName("Add the option to select different build-modes for your builders"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.archery.getBuildingBlock()).setTranslatedName("Unlocks Archery"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.barracks.getBuildingBlock()).setTranslatedName("Unlocks Barracks"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.blacksmith.getBuildingBlock()).setTranslatedName("Unlocks Blacksmith's Hut"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.combatAcademy.getBuildingBlock()).setTranslatedName("Unlocks Combat Academy"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.composter.getBuildingBlock()).setTranslatedName("Unlocks Composter's Hut"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.concreteMixer.getBuildingBlock()).setTranslatedName("Unlocks Concrete Mixer's Hut"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.crusher.getBuildingBlock()).setTranslatedName("Unlocks Crusher's Hut"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.dyer.getBuildingBlock()).setTranslatedName("Unlocks Dyer's Hut"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.fletcher.getBuildingBlock()).setTranslatedName("Unlocks Fletcher's Hut"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.florist.getBuildingBlock()).setTranslatedName("Unlocks Flower Shop"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.graveyard.getBuildingBlock()).setTranslatedName("Unlocks Graveyard"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.glassblower.getBuildingBlock()).setTranslatedName("Unlocks Glassblower's Hut"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.hospital.getBuildingBlock()).setTranslatedName("Unlocks Hospital"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.library.getBuildingBlock()).setTranslatedName("Unlocks Library"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.mechanic.getBuildingBlock()).setTranslatedName("Unlocks Mechanic's Hut"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.mysticalSite.getBuildingBlock()).setTranslatedName("Unlocks Mystical Site"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.plantation.getBuildingBlock()).setTranslatedName("Unlocks Plantation"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.sawmill.getBuildingBlock()).setTranslatedName("Unlocks Sawmill"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.school.getBuildingBlock()).setTranslatedName("Unlocks School"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.sifter.getBuildingBlock()).setTranslatedName("Unlocks Sifter's Hut"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.smeltery.getBuildingBlock()).setTranslatedName("Unlocks Smeltery"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.stoneMason.getBuildingBlock()).setTranslatedName("Unlocks Stonemason's Hut"));
        effects.add(new AbstractResearchProvider.ResearchEffect(ModBuildings.stoneSmelter.getBuildingBlock()).setTranslatedName("Unlocks Stone Smeltery"));
        effects.add(new AbstractResearchProvider.ResearchEffect(new ResourceLocation("minecolonies", "effects/knowledgeoftheendunlock")).setTranslatedName("Stonemasons Learn Endstone Recipe and Bakers Learn Chorus Bread Recipe"));
        effects.add(new AbstractResearchProvider.ResearchEffect(new ResourceLocation("minecolonies", "effects/morescrollsunlock")).setTranslatedName("Enchanter Learns Scroll Recipes to Locate Workers and Summon Guards"));
        effects.add(new AbstractResearchProvider.ResearchEffect(new ResourceLocation("minecolonies", "effects/platearmorunlock")).setTranslatedName("Blacksmith Learns Plate Armor Recipes"));
        effects.add(new AbstractResearchProvider.ResearchEffect(new ResourceLocation("minecolonies", "effects/sifterstringunlock")).setTranslatedName("Fletcher Learns How to Make String Meshes for the Sifter"));
        effects.add(new AbstractResearchProvider.ResearchEffect(new ResourceLocation("minecolonies", "effects/sifterflintunlock")).setTranslatedName("Stonemason Learns How to Make Flint Meshes for the Sifter"));
        effects.add(new AbstractResearchProvider.ResearchEffect(new ResourceLocation("minecolonies", "effects/sifterironunlock")).setTranslatedName("Blacksmith Learns How to Make Iron Meshes for the Sifter"));
        effects.add(new AbstractResearchProvider.ResearchEffect(new ResourceLocation("minecolonies", "effects/sifterdiamondunlock")).setTranslatedName("Mechanic Learns How to Make Diamond Meshes for the Sifter"));
        return effects;
    }

    @Override
    public Collection<AbstractResearchProvider.Research> getResearchCollection() {
        ArrayList<AbstractResearchProvider.Research> researches = new ArrayList<AbstractResearchProvider.Research>();
        researches.addAll(this.getCivilResearch(researches));
        researches.addAll(this.getCombatResearch(researches));
        researches.addAll(this.getTechnologyResearch(researches));
        researches.addAll(this.getAchievementResearch(researches));
        return researches;
    }

    public Collection<AbstractResearchProvider.Research> getCivilResearch(Collection<AbstractResearchProvider.Research> r) {
        AbstractResearchProvider.Research stamina = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/stamina"), CIVIL).setTranslatedName("Stamina").setOnlyChild().setIcon(ModBlocks.blockHutHospital.func_199767_j()).addItemCost(Items.field_151172_bF, 1).addEffect(ModBuildings.hospital.getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research bandAid = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/bandaid"), CIVIL).setParentResearch(stamina).setTranslatedName("Band Aid").setIcon(new ResourceLocation("minecolonies:textures/icons/research/regeneration1.png")).addBuildingRequirement("library", 2).addItemCost(Items.field_151150_bK, 1).addEffect(ResearchConstants.REGENERATION, 1).addToList(r);
        AbstractResearchProvider.Research healingCream = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/healingcream"), CIVIL).setParentResearch(bandAid).setTranslatedName("Healing Cream").setTranslatedSubtitle("You missed a spot...").setIcon(new ResourceLocation("minecolonies:textures/icons/research/regeneration2.png")).addBuildingRequirement("library", 3).addItemCost(Items.field_151150_bK, 8).addEffect(ResearchConstants.REGENERATION, 2).addToList(r);
        AbstractResearchProvider.Research bandages = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/bandages"), CIVIL).setParentResearch(healingCream).setTranslatedName("Bandages").setIcon(new ResourceLocation("minecolonies:textures/icons/research/regeneration3.png")).addBuildingRequirement("library", 4).addItemCost(Items.field_151150_bK, 16).addEffect(ResearchConstants.REGENERATION, 3).addToList(r);
        AbstractResearchProvider.Research compress = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/compress"), CIVIL).setParentResearch(bandages).setTranslatedName("Compress").setIcon(new ResourceLocation("minecolonies:textures/icons/research/regeneration4.png")).addBuildingRequirement("library", 5).addItemCost(Items.field_151150_bK, 32).addEffect(ResearchConstants.REGENERATION, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/cast"), CIVIL).setParentResearch(compress).setTranslatedName("Cast").setIcon(new ResourceLocation("minecolonies:textures/icons/research/regeneration5.png")).addItemCost(Items.field_151150_bK, 64).addEffect(ResearchConstants.REGENERATION, 5).addToList(r);
        AbstractResearchProvider.Research resistance = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/resistance"), CIVIL).setParentResearch(stamina).setTranslatedName("Resistance").setSortOrder(2).setIcon(Items.field_151069_bo).addBuildingRequirement("cook", 2).addItemCost(Items.field_151153_ao, 1).addEffect(ResearchConstants.SATLIMIT, 1).addToList(r);
        AbstractResearchProvider.Research resilience = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/resilience"), CIVIL).setParentResearch(resistance).setTranslatedName("Resilience").setIcon(Items.field_151068_bn).addBuildingRequirement("cook", 3).addItemCost(Items.field_151153_ao, 8).addEffect(ResearchConstants.SATLIMIT, 2).addToList(r);
        AbstractResearchProvider.Research vitality = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/vitality"), CIVIL).setParentResearch(resilience).setTranslatedName("Vitality").setIcon(Items.field_185155_bH).addBuildingRequirement("cook", 4).addItemCost(Items.field_151153_ao, 16).addEffect(ResearchConstants.SATLIMIT, 3).addToList(r);
        AbstractResearchProvider.Research fortitude = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/fortitude"), CIVIL).setParentResearch(vitality).setTranslatedName("Fortitude").setIcon(Items.field_226638_pX_).addBuildingRequirement("cook", 5).addItemCost(Items.field_151153_ao, 32).addEffect(ResearchConstants.SATLIMIT, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/indefatigability"), CIVIL).setParentResearch(fortitude).setTranslatedName("Indefatigability").setIcon(Items.field_151062_by).addItemCost(Items.field_151153_ao, 64).addEffect(ResearchConstants.SATLIMIT, 5).addToList(r);
        AbstractResearchProvider.Research keen = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/keen"), CIVIL).setTranslatedName("Keen").setSortOrder(2).setIcon(ModBlocks.blockHutLibrary.func_199767_j()).addBuildingRequirement("home", 3).addItemCost(Items.field_151122_aG, 3).addEffect(ModBuildings.library.getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research outpost = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/outpost"), CIVIL).setParentResearch(keen).setTranslatedName("Outpost").setIcon(ModBlocks.blockHutHome.func_199767_j(), 50).addBuildingRequirement("home", 4).addItemCost(Items.field_151083_be, 64).addEffect(ResearchConstants.CITIZEN_CAP, 1).addToList(r);
        AbstractResearchProvider.Research hamlet = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/hamlet"), CIVIL).setParentResearch(outpost).setTranslatedName("Hamlet").setIcon(ModBlocks.blockHutHome.func_199767_j(), 75).addBuildingRequirement("home", 5).addItemCost(Items.field_151083_be, 128).addEffect(ResearchConstants.CITIZEN_CAP, 2).addToList(r);
        AbstractResearchProvider.Research village = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/village"), CIVIL).setParentResearch(hamlet).setTranslatedName("Village").setIcon(ModBlocks.blockHutHome.func_199767_j(), 100).addBuildingRequirement("townhall", 4).addItemCost(Items.field_151083_be, 256).addEffect(ResearchConstants.CITIZEN_CAP, 3).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/city"), CIVIL).setParentResearch(village).setTranslatedName("City").setIcon(ModBlocks.blockHutHome.func_199767_j(), 200).addBuildingRequirement("townhall", 5).addItemCost(Items.field_151083_be, 512).addEffect(ResearchConstants.CITIZEN_CAP, 4).addToList(r);
        AbstractResearchProvider.Research diligent = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/diligent"), CIVIL).setParentResearch(keen).setTranslatedName("Diligent").setSortOrder(2).setIcon(Items.field_151062_by).addBuildingRequirement("library", 2).addItemCost(Items.field_151122_aG, 6).addEffect(ResearchConstants.LEVELING, 1).addToList(r);
        AbstractResearchProvider.Research studious = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/studious"), CIVIL).setParentResearch(diligent).setTranslatedName("Studious").setIcon(Items.field_151062_by, 2).addBuildingRequirement("library", 3).addItemCost(Items.field_151122_aG, 12).addEffect(ResearchConstants.LEVELING, 2).addToList(r);
        AbstractResearchProvider.Research scholarly = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/scholarly"), CIVIL).setParentResearch(studious).setTranslatedName("Scholarly").setTranslatedSubtitle("Homework for the next decade... check!").setIcon(Items.field_151062_by, 3).addBuildingRequirement("library", 4).addItemCost(Items.field_151122_aG, 24).addEffect(ResearchConstants.LEVELING, 3).addToList(r);
        AbstractResearchProvider.Research reflective = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/reflective"), CIVIL).setParentResearch(scholarly).setTranslatedName("Reflective").setTranslatedSubtitle("Let me think about that for a moment.").setIcon(Items.field_151062_by, 4).addBuildingRequirement("library", 5).addItemCost(Items.field_151122_aG, 48).addEffect(ResearchConstants.LEVELING, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/academic"), CIVIL).setParentResearch(reflective).setTranslatedName("Academic").setTranslatedSubtitle("Think about what you thought when you thought of what you will think now.").setIcon(Items.field_151062_by, 5).addItemCost(Items.field_151122_aG, 128).addEffect(ResearchConstants.LEVELING, 5).addToList(r);
        AbstractResearchProvider.Research rails = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/rails"), CIVIL).setParentResearch(keen).setTranslatedName("Rails").setTranslatedSubtitle("Research is progressing right on track.").setSortOrder(3).setIcon(Items.field_221668_av).addBuildingRequirement("deliveryman", 3).addItemCost(Items.field_221742_cg, 64).addEffect(ResearchConstants.RAILS, 1).addToList(r);
        AbstractResearchProvider.Research nimble = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/nimble"), CIVIL).setParentResearch(rails).setTranslatedName("Nimble").setTranslatedSubtitle("Not that we get time to exercise. It must be the morning commute.").setIcon(new ResourceLocation("minecolonies:textures/icons/research/speed1.png")).addBuildingRequirement("townhall", 3).addItemCost(Items.field_179556_br, 1).addEffect(ResearchConstants.WALKING, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/vines"), CIVIL).setParentResearch(keen).setTranslatedName("Aaaiooooiooo").setTranslatedSubtitle("Me Tarzan, you Jane.").setSortOrder(4).setIcon(Items.field_221796_dh).addBuildingRequirement("home", 3).addItemCost(Items.field_221796_dh, 64).addEffect(ResearchConstants.VINES, 1).addToList(r);
        AbstractResearchProvider.Research agile = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/agile"), CIVIL).setParentResearch(nimble).setTranslatedName("Agile").setTranslatedSubtitle("So this is how it feels to be young again...").setIcon(new ResourceLocation("minecolonies:textures/icons/research/speed2.png")).addBuildingRequirement("townhall", 4).addItemCost(Items.field_179556_br, 10).addEffect(ResearchConstants.WALKING, 2).addToList(r);
        AbstractResearchProvider.Research swift = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/swift"), CIVIL).setParentResearch(agile).setTranslatedName("Swift").setTranslatedSubtitle("They'll never see me coming.").setIcon(new ResourceLocation("minecolonies:textures/icons/research/speed3.png")).addBuildingRequirement("townhall", 5).addItemCost(Items.field_179556_br, 32).addEffect(ResearchConstants.WALKING, 3).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/athlete"), CIVIL).setParentResearch(swift).setTranslatedName("Athlete").setTranslatedSubtitle("Try thinking as fast as your feet now!").setIcon(new ResourceLocation("minecolonies:textures/icons/research/speed4.png")).addItemCost(Items.field_179556_br, 64).addEffect(ResearchConstants.WALKING, 4).addToList(r);
        AbstractResearchProvider.Research firstAid = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/firstaid"), CIVIL).setTranslatedName("First Aid").setTranslatedSubtitle("First aid, second hand.").setSortOrder(3).setIcon(new ResourceLocation("minecolonies:textures/icons/research/hp1.png")).addBuildingRequirement("townhall", 1).addItemCost(Items.field_221807_eN, 8).addEffect(ResearchConstants.HEALTH_BOOST, 1).addToList(r);
        AbstractResearchProvider.Research firstAid2 = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/firstaid2"), CIVIL).setParentResearch(firstAid).setTranslatedName("First Aid II").setTranslatedSubtitle("Second Aid?").setIcon(new ResourceLocation("minecolonies:textures/icons/research/hp2.png")).addBuildingRequirement("townhall", 2).addItemCost(Items.field_221807_eN, 16).addEffect(ResearchConstants.HEALTH_BOOST, 2).addToList(r);
        AbstractResearchProvider.Research lifesaver = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/lifesaver"), CIVIL).setParentResearch(firstAid2).setTranslatedName("Lifesaver").setIcon(new ResourceLocation("minecolonies:textures/icons/research/hp3.png")).addBuildingRequirement("townhall", 3).addItemCost(Items.field_221807_eN, 32).addEffect(ResearchConstants.HEALTH_BOOST, 3).addToList(r);
        AbstractResearchProvider.Research lifesaver2 = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/lifesaver2"), CIVIL).setParentResearch(lifesaver).setTranslatedName("Lifesaver II").setIcon(new ResourceLocation("minecolonies:textures/icons/research/hp4.png")).addBuildingRequirement("townhall", 4).addItemCost(Items.field_221807_eN, 64).addEffect(ResearchConstants.HEALTH_BOOST, 4).addToList(r);
        AbstractResearchProvider.Research guardianAngel = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/guardianangel"), CIVIL).setParentResearch(lifesaver2).setTranslatedName("Guardian Angel").setIcon(new ResourceLocation("minecolonies:textures/icons/research/hp5.png")).addBuildingRequirement("townhall", 5).addItemCost(Items.field_221807_eN, 128).addEffect(ResearchConstants.HEALTH_BOOST, 5).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/guardianangel2"), CIVIL).setParentResearch(guardianAngel).setTranslatedName("Guardian Angel II").setIcon(new ResourceLocation("minecolonies:textures/icons/research/hp6.png")).addItemCost(Items.field_221807_eN, 256).addEffect(ResearchConstants.HEALTH_BOOST, 6).addToList(r);
        AbstractResearchProvider.Research circus = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/circus"), CIVIL).setParentResearch(firstAid).setTranslatedName("Circus").setSortOrder(2).setIcon(new ResourceLocation("minecolonies:textures/icons/research/happy1.png")).addBuildingRequirement("cook", 2).addItemCost(Items.field_222070_lD, 1).addEffect(ResearchConstants.HAPPINESS, 1).addToList(r);
        AbstractResearchProvider.Research festival = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/festival"), CIVIL).setParentResearch(circus).setTranslatedName("Festival").setTranslatedSubtitle("We Researchers may not be there, so don't look for us.").setIcon(new ResourceLocation("minecolonies:textures/icons/research/happy2.png")).addBuildingRequirement("cook", 3).addItemCost(Items.field_222070_lD, 9).addEffect(ResearchConstants.HAPPINESS, 2).addToList(r);
        AbstractResearchProvider.Research spectacle = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/spectacle"), CIVIL).setParentResearch(festival).setTranslatedName("Spectacle").setIcon(new ResourceLocation("minecolonies:textures/icons/research/happy3.png")).addBuildingRequirement("cook", 4).addItemCost(Items.field_222070_lD, 18).addEffect(ResearchConstants.HAPPINESS, 3).addToList(r);
        AbstractResearchProvider.Research opera = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/opera"), CIVIL).setParentResearch(spectacle).setTranslatedName("Opera").setTranslatedSubtitle("Ear plugs not included.").setIcon(new ResourceLocation("minecolonies:textures/icons/research/happy4.png")).addBuildingRequirement("cook", 5).addItemCost(Items.field_222070_lD, 27).addEffect(ResearchConstants.HAPPINESS, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/theater"), CIVIL).setParentResearch(opera).setTranslatedName("Theater").setTranslatedSubtitle("Oh don't be so dramatic!").setIcon(new ResourceLocation("minecolonies:textures/icons/research/happy5.png")).addItemCost(Items.field_196100_at, 16).addEffect(ResearchConstants.HAPPINESS, 5).addToList(r);
        AbstractResearchProvider.Research night_owl = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/nightowl"), CIVIL).setParentResearch(circus).setTranslatedName("Night Owl").setTranslatedSubtitle("Overtime penalty rates need not apply.").setSortOrder(2).setIcon(Items.field_151113_aN, 1).addBuildingRequirement("library", 2).addItemCost(Items.field_151150_bK, 25).addEffect(ResearchConstants.WORK_LONGER, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/nightowl2"), CIVIL).setParentResearch(night_owl).setTranslatedName("Night Owl II").setTranslatedSubtitle("Got any coffee?").setSortOrder(2).setIcon(Items.field_151113_aN, 2).addBuildingRequirement("townhall", 3).addItemCost(Items.field_151150_bK, 75).addEffect(ResearchConstants.WORK_LONGER, 2).addToList(r);
        AbstractResearchProvider.Research gourmand = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/gourmand"), CIVIL).setParentResearch(firstAid).setTranslatedName("Gourmand").setSortOrder(3).setIcon(new ResourceLocation("minecolonies:textures/icons/research/saturation1.png")).addBuildingRequirement("cook", 2).addItemCost(Items.field_151106_aX, 32).addEffect(ResearchConstants.SATURATION, 1).addToList(r);
        AbstractResearchProvider.Research gorger = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/gorger"), CIVIL).setParentResearch(gourmand).setTranslatedName("Gorger").setTranslatedSubtitle("MORE!???").setIcon(new ResourceLocation("minecolonies:textures/icons/research/saturation2.png")).addBuildingRequirement("cook", 3).addItemCost(Items.field_151106_aX, 64).addEffect(ResearchConstants.SATURATION, 2).addToList(r);
        AbstractResearchProvider.Research stuffer = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/stuffer"), CIVIL).setParentResearch(gorger).setTranslatedName("Stuffer").setIcon(new ResourceLocation("minecolonies:textures/icons/research/saturation3.png")).addBuildingRequirement("cook", 4).addItemCost(Items.field_151106_aX, 128).addEffect(ResearchConstants.SATURATION, 3).addToList(r);
        AbstractResearchProvider.Research epicure = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/epicure"), CIVIL).setParentResearch(stuffer).setTranslatedName("Epicure").setIcon(new ResourceLocation("minecolonies:textures/icons/research/saturation4.png")).addBuildingRequirement("cook", 5).addItemCost(Items.field_151106_aX, 256).addEffect(ResearchConstants.SATURATION, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/glutton"), CIVIL).setParentResearch(epicure).setTranslatedName("Glutton").setTranslatedSubtitle("I think I'm finally satisfied... so what's for next course?").setIcon(new ResourceLocation("minecolonies:textures/icons/research/saturation5.png")).addItemCost(Items.field_151106_aX, 512).addEffect(ResearchConstants.SATURATION, 5).addToList(r);
        AbstractResearchProvider.Research higherLearning = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/higherlearning"), CIVIL).setTranslatedName("Higher Learning").setTranslatedSubtitle("Well, we had to find something to occupy them.").setSortOrder(4).setOnlyChild().setIcon(ModBlocks.blockHutSchool.func_199767_j()).addBuildingRequirement("home", 3).addItemCost(Items.field_151122_aG, 3).addEffect(ModBuildings.school.getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research moreBooks = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/morebooks"), CIVIL).setParentResearch(higherLearning).setTranslatedName("More Books").setTranslatedSubtitle("Of course I'm right, I read it in a book!").setIcon(new ResourceLocation("minecolonies:textures/icons/research/xpgain1.png")).addBuildingRequirement("school", 1).addItemCost(Items.field_151122_aG, 6).addEffect(ResearchConstants.TEACHING, 1).addToList(r);
        AbstractResearchProvider.Research bookworm = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/bookworm"), CIVIL).setParentResearch(moreBooks).setTranslatedName("Bookworm").setTranslatedSubtitle("We all know the early bird gets the book!").setIcon(new ResourceLocation("minecolonies:textures/icons/research/xpgain2.png")).addBuildingRequirement("school", 3).addItemCost(Items.field_221651_bN, 6).addEffect(ResearchConstants.TEACHING, 2).addToList(r);
        AbstractResearchProvider.Research bachelor = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/bachelor"), CIVIL).setParentResearch(bookworm).setTranslatedName("Bachelor").setTranslatedSubtitle("They now look like they know a lot, whether they do or not.").setIcon(new ResourceLocation("minecolonies:textures/icons/research/xpgain3.png")).addBuildingRequirement("library", 3).addItemCost(Items.field_221651_bN, 12).addEffect(ResearchConstants.TEACHING, 3).addToList(r);
        AbstractResearchProvider.Research master = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/master"), CIVIL).setParentResearch(bachelor).setTranslatedName("Master").setTranslatedSubtitle("At least they get a fancy title this time.").setIcon(new ResourceLocation("minecolonies:textures/icons/research/xpgain4.png")).addBuildingRequirement("library", 5).addItemCost(Items.field_221651_bN, 32).addEffect(ResearchConstants.TEACHING, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/phd"), CIVIL).setParentResearch(master).setTranslatedName("PhD").setTranslatedSubtitle("Not that sort of doctor.").setIcon(new ResourceLocation("minecolonies:textures/icons/research/xpgain5.png")).addItemCost(Items.field_221651_bN, 64).addEffect(ResearchConstants.TEACHING, 5).addToList(r);
        AbstractResearchProvider.Research nurture = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/nurture"), CIVIL).setParentResearch(higherLearning).setTranslatedName("Nurture").setTranslatedSubtitle("It's just part of our nature now.").setSortOrder(2).setIcon(new ResourceLocation("minecolonies:textures/icons/research/childgrowth1.png")).addBuildingRequirement("school", 1).addItemCost(Items.field_151077_bg, 32).addEffect(ResearchConstants.GROWTH, 1).addToList(r);
        AbstractResearchProvider.Research hormones = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/hormones"), CIVIL).setParentResearch(nurture).setTranslatedName("Hormones").setTranslatedSubtitle("These are safe, right?").setIcon(new ResourceLocation("minecolonies:textures/icons/research/childgrowth2.png")).addBuildingRequirement("school", 3).addItemCost(Items.field_151077_bg, 64).addEffect(ResearchConstants.GROWTH, 2).addToList(r);
        AbstractResearchProvider.Research puberty = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/puberty"), CIVIL).setParentResearch(hormones).setTranslatedName("Puberty").setTranslatedSubtitle("My voice sounds weird...").setIcon(new ResourceLocation("minecolonies:textures/icons/research/childgrowth3.png")).addBuildingRequirement("library", 3).addItemCost(Items.field_151077_bg, 128).addEffect(ResearchConstants.GROWTH, 3).addToList(r);
        AbstractResearchProvider.Research growth = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/growth"), CIVIL).setParentResearch(puberty).setTranslatedName("Growth").setIcon(new ResourceLocation("minecolonies:textures/icons/research/childgrowth4.png")).addBuildingRequirement("library", 5).addItemCost(Items.field_151077_bg, 256).addEffect(ResearchConstants.GROWTH, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/beanstalk"), CIVIL).setParentResearch(growth).setTranslatedName("Beanstalk").setTranslatedSubtitle("That's one heck of a growth spurt!").setIcon(new ResourceLocation("minecolonies:textures/icons/research/childgrowth5.png")).addItemCost(Items.field_151077_bg, 512).addEffect(ResearchConstants.GROWTH, 5).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/ambition"), CIVIL).setTranslatedName("Ambition").setSortOrder(5).setIcon(ModBlocks.blockHutMysticalSite.func_199767_j()).addItemCost(Items.field_151045_i, 1).addEffect(ModBuildings.mysticalSite.getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research remembrance = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/remembrance"), CIVIL).setTranslatedName("Remembrance").setSortOrder(6).setIcon(ModBlocks.blockHutGraveyard.func_199767_j()).addEffect(ModBuildings.graveyard.getBuildingBlock(), 1).addBuildingRequirement("townhall", 2).addItemCost(Items.field_151103_aS, 8).setTranslatedSubtitle("Our fallen shall not be forgotten!").addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/undertakeremergency"), CIVIL).setParentResearch(remembrance).setTranslatedName("Undertaker Emergency").setSortOrder(3).setIcon(ModBlocks.blockHutGraveyard.func_199767_j()).addBuildingRequirement("graveyard", 2).addItemCost(Items.field_151167_ab, 1).addEffect(ResearchConstants.UNDERTAKER_RUN, 1).addToList(r);
        AbstractResearchProvider.Research resurrectChance1 = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/resurrectchance1"), CIVIL).setParentResearch(remembrance).setTranslatedName("Resurrection Chance I").setTranslatedSubtitle("Use the right words").setSortOrder(1).setIcon(ModBlocks.blockHutGraveyard.func_199767_j()).addBuildingRequirement("graveyard", 3).addItemCost(Items.field_151073_bk, 1).addEffect(ResearchConstants.RESURRECT_CHANCE, 1).addToList(r);
        AbstractResearchProvider.Research resurrectChance2 = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/resurrectchance2"), CIVIL).setParentResearch(resurrectChance1).setTranslatedName("Resurrection Chance II").setTranslatedSubtitle("Dance around and wave your hands").setSortOrder(1).setIcon(ModBlocks.blockHutGraveyard.func_199767_j()).addBuildingRequirement("graveyard", 5).addItemCost(Items.field_185161_cS, 16).addEffect(ResearchConstants.RESURRECT_CHANCE, 2).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/raisingthedead"), CIVIL).setParentResearch(resurrectChance2).setTranslatedName("Raising The Dead").setTranslatedSubtitle("Magic totems are for more than just looks").setSortOrder(1).setIcon(Items.field_190929_cY.func_199767_j()).addBuildingRequirement("graveyard", 5).addItemCost(Items.field_190929_cY, 1).addEffect(ResearchConstants.USE_TOTEM, 1).addToList(r);
        AbstractResearchProvider.Research decayBonus1 = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/gravedecaybonus1"), CIVIL).setParentResearch(remembrance).setTranslatedName("Grave Decay I").setTranslatedSubtitle("Dig deeper before death").setSortOrder(2).setIcon(ModBlocks.blockGrave.func_199767_j()).addBuildingRequirement("graveyard", 3).addItemCost(Items.field_151078_bh, 64).addEffect(ResearchConstants.GRAVE_DECAY_BONUS, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "civilian/gravedecaybonus2"), CIVIL).setParentResearch(decayBonus1).setTranslatedName("Grave Decay II").setTranslatedSubtitle("I don't want to leave yet!").setSortOrder(2).setIcon(ModBlocks.blockGrave.func_199767_j()).addBuildingRequirement("graveyard", 5).addItemCost(Items.field_221960_gl, 8).addEffect(ResearchConstants.GRAVE_DECAY_BONUS, 2).addToList(r);
        return r;
    }

    public Collection<AbstractResearchProvider.Research> getCombatResearch(Collection<AbstractResearchProvider.Research> r) {
        AbstractResearchProvider.Research accuracy = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/accuracy"), COMBAT).setTranslatedName("Accuracy").setOnlyChild().setIcon(Items.field_196150_bz).addBuildingRequirement("guardtower", 1).addItemCost(Items.field_151042_j, 16).addEffect(ResearchConstants.SLEEP_LESS, 1).addToList(r);
        AbstractResearchProvider.Research quickDraw = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/quickdraw"), COMBAT).setParentResearch(accuracy).setTranslatedName("Quick Draw").setIcon(Items.field_151041_m).addBuildingRequirement("barracks", 3).addItemCost(Items.field_221698_bk, 2).addEffect(ResearchConstants.MELEE_DAMAGE, 1).addToList(r);
        AbstractResearchProvider.Research powerAttack = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/powerattack"), COMBAT).setParentResearch(quickDraw).setTranslatedName("Power Attack").setIcon(Items.field_151052_q).addBuildingRequirement("combatacademy", 3).addItemCost(Items.field_221698_bk, 4).addEffect(ResearchConstants.MELEE_DAMAGE, 2).addToList(r);
        AbstractResearchProvider.Research cleave = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/cleave"), COMBAT).setParentResearch(powerAttack).setTranslatedName("Cleave").setIcon(Items.field_151040_l).addBuildingRequirement("guardtower", 10).addItemCost(Items.field_221698_bk, 8).addEffect(ResearchConstants.MELEE_DAMAGE, 3).addToList(r);
        AbstractResearchProvider.Research mightyCleave = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/mightycleave"), COMBAT).setParentResearch(cleave).setTranslatedName("Mighty Cleave").setIcon(Items.field_151010_B).addBuildingRequirement("barracks", 5).addItemCost(Items.field_221698_bk, 16).addEffect(ResearchConstants.MELEE_DAMAGE, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/savagestrike"), COMBAT).setParentResearch(mightyCleave).setTranslatedName("Savage Strike").setIcon(Items.field_151048_u).addItemCost(Items.field_221698_bk, 32).addEffect(ResearchConstants.MELEE_DAMAGE, 5).addToList(r);
        AbstractResearchProvider.Research preciseShot = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/preciseshot"), COMBAT).setParentResearch(accuracy).setTranslatedName("Precise Shot").setSortOrder(2).setIcon(Items.field_151032_g).addBuildingRequirement("barracks", 3).addItemCost(Items.field_151145_ak, 16).addEffect(ResearchConstants.ARCHER_DAMAGE, 1).addToList(r);
        AbstractResearchProvider.Research penetratingShot = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/penetratingshot"), COMBAT).setParentResearch(preciseShot).setTranslatedName("Penetrating Shot").setIcon(Items.field_151031_f).addBuildingRequirement("archery", 3).addItemCost(Items.field_151145_ak, 32).addEffect(ResearchConstants.ARCHER_DAMAGE, 2).addToList(r);
        AbstractResearchProvider.Research piercingShot = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/piercingshot"), COMBAT).setParentResearch(penetratingShot).setTranslatedName("Piercing Shot").setIcon(Items.field_222114_py).addBuildingRequirement("guardtower", 10).addItemCost(Items.field_151145_ak, 64).addEffect(ResearchConstants.ARCHER_DAMAGE, 3).addToList(r);
        AbstractResearchProvider.Research woundingShot = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/woundingshot"), COMBAT).setParentResearch(piercingShot).setTranslatedName("Wounding Shot").setIcon(ModItems.firearrow).addBuildingRequirement("barracks", 5).addItemCost(Items.field_151145_ak, 128).addEffect(ResearchConstants.ARCHER_DAMAGE, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/deadlyaim"), COMBAT).setParentResearch(woundingShot).setTranslatedName("Deadly Aim").setTranslatedSubtitle("Just don't aim at me!").setIcon(Items.field_185167_i).addItemCost(Items.field_151145_ak, 256).addEffect(ResearchConstants.ARCHER_DAMAGE, 5).addToList(r);
        AbstractResearchProvider.Research tacticTraining = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/tactictraining"), COMBAT).setTranslatedName("Tactic Training").setSortOrder(2).setIcon(ModBlocks.blockHutBarracksTower.func_199767_j()).addBuildingRequirement("guardtower", 3).addItemCost(Items.field_221698_bk, 3).addEffect(ModBuildings.barracks.getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research improvedSwords = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/improvedswords"), COMBAT).setParentResearch(tacticTraining).setTranslatedName("Improved Swords").setTranslatedSubtitle("Pointy end goes into the zombie.").setIcon(ModBlocks.blockHutCombatAcademy.func_199767_j()).addBuildingRequirement("barracks", 3).addItemCost(Items.field_221698_bk, 6).addEffect(ModBuildings.combatAcademy.getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research squireTraining = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/squiretraining"), COMBAT).setParentResearch(improvedSwords).setTranslatedName("Squire Training").setTranslatedSubtitle("First lesson: how to mop the floors.").setIcon(Items.field_151042_j).addBuildingRequirement("combatacademy", 3).addItemCost(Items.field_185159_cQ, 4).addEffect(ResearchConstants.BLOCK_ATTACKS, 1).addToList(r);
        AbstractResearchProvider.Research knightTraining = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/knighttraining"), COMBAT).setParentResearch(squireTraining).setTranslatedName("Knight Training").setIcon(Items.field_222100_pG).addBuildingRequirement("combatacademy", 4).addItemCost(Items.field_185159_cQ, 8).addEffect(ResearchConstants.BLOCK_ATTACKS, 2).addToList(r);
        AbstractResearchProvider.Research captainTraining = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/captaintraining"), COMBAT).setParentResearch(knightTraining).setTranslatedName("Captain Training").setIcon(Items.field_221790_de).addBuildingRequirement("combatacademy", 5).addItemCost(Items.field_185159_cQ, 16).addEffect(ResearchConstants.BLOCK_ATTACKS, 3).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/captainoftheguard"), COMBAT).setParentResearch(captainTraining).setTranslatedName("Captain of the Guard").setIcon(Items.field_221698_bk).addItemCost(Items.field_185159_cQ, 27).addEffect(ResearchConstants.BLOCK_ATTACKS, 4).addToList(r);
        AbstractResearchProvider.Research improvedBows = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/improvedbows"), COMBAT).setParentResearch(tacticTraining).setTranslatedName("Improved Bows").setTranslatedSubtitle("How far back can this bend before snapping?").setSortOrder(2).setIcon(ModBlocks.blockHutArchery.func_199767_j()).addBuildingRequirement("barracks", 3).addItemCost(Items.field_221698_bk, 6).addEffect(ModBuildings.archery.getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research trickShot = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/trickshot"), COMBAT).setParentResearch(improvedBows).setTranslatedName("Trick Shot").setIcon(Items.field_151032_g).addBuildingRequirement("archery", 3).addItemCost(Items.field_151031_f, 5).addEffect(ResearchConstants.DOUBLE_ARROWS, 1).addToList(r);
        AbstractResearchProvider.Research multiShot = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/multishot"), COMBAT).setParentResearch(trickShot).setTranslatedName("Multishot").setTranslatedSubtitle("Known side effects include double vision double vision.").setIcon(Items.field_185167_i).addBuildingRequirement("archery", 4).addItemCost(Items.field_151031_f, 9).addEffect(ResearchConstants.DOUBLE_ARROWS, 2).addToList(r);
        AbstractResearchProvider.Research rapidShot = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/rapidshot"), COMBAT).setParentResearch(multiShot).setTranslatedName("Rapid Shot").setTranslatedSubtitle("Please leave the bow with more than you brought in.").setIcon(ModItems.firearrow).addBuildingRequirement("archery", 5).addItemCost(Items.field_151031_f, 18).addEffect(ResearchConstants.DOUBLE_ARROWS, 3).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/masterbowman"), COMBAT).setParentResearch(rapidShot).setTranslatedName("Master Bowman").setIcon(Items.field_151072_bj).addItemCost(Items.field_151031_f, 27).addEffect(ResearchConstants.DOUBLE_ARROWS, 4).addToList(r);
        AbstractResearchProvider.Research avoidance = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/avoidance"), COMBAT).setTranslatedName("Avoidance").setSortOrder(3).setOnlyChild().setIcon(Items.field_185159_cQ).addBuildingRequirement("guardtower", 3).addItemCost(Items.field_221698_bk, 3).addEffect(ResearchConstants.SHIELD_USAGE, 1).addToList(r);
        AbstractResearchProvider.Research parry = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/parry"), COMBAT).setParentResearch(avoidance).setTranslatedName("Parry").setIcon(Items.field_151027_R).addBuildingRequirement("smeltery", 1).addItemCost(Items.field_151042_j, 16).addEffect(ResearchConstants.MELEE_ARMOR, 1).addToList(r);
        AbstractResearchProvider.Research riposte = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/riposte"), COMBAT).setParentResearch(parry).setTranslatedName("Riposte").setTranslatedSubtitle("Oh yeah? Well, I, uh, um...").setIcon(Items.field_151030_Z).addBuildingRequirement("combatacademy", 1).addItemCost(Items.field_151042_j, 32).addEffect(ResearchConstants.MELEE_ARMOR, 2).addToList(r);
        AbstractResearchProvider.Research duelist = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/duelist"), COMBAT).setParentResearch(riposte).setTranslatedName("Duelist").setIcon(Items.field_151023_V).addBuildingRequirement("smeltery", 3).addItemCost(Items.field_151042_j, 64).addEffect(ResearchConstants.MELEE_ARMOR, 3).addToList(r);
        AbstractResearchProvider.Research provost = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/provost"), COMBAT).setParentResearch(duelist).setTranslatedName("Provost").setIcon(Items.field_151171_ah).addBuildingRequirement("combatacademy", 5).addItemCost(Items.field_151045_i, 16).addEffect(ResearchConstants.MELEE_ARMOR, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/masterswordsman"), COMBAT).setParentResearch(provost).setTranslatedName("Master Swordsman").setIcon(Items.field_151163_ad).addItemCost(Items.field_151045_i, 64).addEffect(ResearchConstants.MELEE_ARMOR, 5).addToList(r);
        AbstractResearchProvider.Research dodge = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/dodge"), COMBAT).setParentResearch(avoidance).setTranslatedName("Dodge").setTranslatedSubtitle("If you can dodge a hammer...").setSortOrder(2).setIcon(ModItems.pirateBoots_2.func_199767_j()).addBuildingRequirement("smeltery", 1).addItemCost(Items.field_151116_aA, 16).addEffect(ResearchConstants.ARCHER_ARMOR, 1).addToList(r);
        AbstractResearchProvider.Research improvedDodge = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/improveddodge"), COMBAT).setParentResearch(dodge).setTranslatedName("Improved Dodge").setTranslatedSubtitle("Dip").setIcon(ModItems.pirateBoots_1).addBuildingRequirement("archery", 1).addItemCost(Items.field_151116_aA, 32).addEffect(ResearchConstants.ARCHER_ARMOR, 2).addToList(r);
        AbstractResearchProvider.Research evasion = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/evasion"), COMBAT).setParentResearch(improvedDodge).setTranslatedName("Evasion").setTranslatedSubtitle("\"Duck!\" \"No, that's a goose.\"").setIcon(Items.field_151167_ab).addBuildingRequirement("smeltery", 3).addItemCost(Items.field_151116_aA, 64).addEffect(ResearchConstants.ARCHER_ARMOR, 3).addToList(r);
        AbstractResearchProvider.Research improvedEvasion = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/improvedevasion"), COMBAT).setParentResearch(evasion).setTranslatedName("Improved Evasion").setTranslatedSubtitle("Dive").setIcon(Items.field_151151_aj).addBuildingRequirement("archery", 5).addItemCost(Items.field_151045_i, 16).addEffect(ResearchConstants.ARCHER_ARMOR, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/agilearcher"), COMBAT).setParentResearch(improvedEvasion).setTranslatedName("Agile Archer").setTranslatedSubtitle("Dodge... Again!").setIcon(Items.field_151175_af).addItemCost(Items.field_151045_i, 64).addEffect(ResearchConstants.ARCHER_ARMOR, 5).addToList(r);
        AbstractResearchProvider.Research improvedLeather = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/improvedleather"), COMBAT).setTranslatedName("Improved Leather").setTranslatedSubtitle("Becoming more like the real thing every day.").setSortOrder(4).setIcon(Items.field_151024_Q).addBuildingRequirement("townhall", 1).addItemCost(Items.field_151116_aA, 32).addEffect(ResearchConstants.ARMOR_DURABILITY, 1).addToList(r);
        AbstractResearchProvider.Research boiledLeather = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/boiledleather"), COMBAT).setParentResearch(improvedLeather).setTranslatedName("Boiled Leather").setTranslatedSubtitle("Extra leathery!").setIcon(Items.field_203179_ao).addBuildingRequirement("townhall", 2).addItemCost(Items.field_151116_aA, 64).addEffect(ResearchConstants.ARMOR_DURABILITY, 2).addToList(r);
        AbstractResearchProvider.Research ironSkin = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/ironskin"), COMBAT).setParentResearch(boiledLeather).setTranslatedName("Iron Skin").setIcon(Items.field_151020_U).addBuildingRequirement("townhall", 3).addItemCost(Items.field_151042_j, 16).addEffect(ResearchConstants.ARMOR_DURABILITY, 3).addToList(r);
        AbstractResearchProvider.Research ironArmor = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/ironarmor"), COMBAT).setParentResearch(ironSkin).setTranslatedName("Iron Armor").setIcon(Items.field_151028_Y).addBuildingRequirement("townhall", 4).addItemCost(Items.field_151042_j, 32).addEffect(ResearchConstants.ARMOR_DURABILITY, 4).addToList(r);
        AbstractResearchProvider.Research steelArmor = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/steelarmor"), COMBAT).setParentResearch(ironArmor).setTranslatedName("Steel Armor").setSortOrder(1).setIcon(Items.field_151169_ag).addBuildingRequirement("townhall", 5).addItemCost(Items.field_151042_j, 64).addEffect(ResearchConstants.ARMOR_DURABILITY, 5).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/platearmor"), COMBAT).setParentResearch(ironArmor).setTranslatedName("Plate Armor").setSortOrder(2).setIcon(ModItems.plateArmorHelmet).addMandatoryBuildingRequirement("blacksmith", 4).addItemCost(Items.field_151042_j, 32).addEffect(ResearchConstants.PLATE_ARMOR, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/diamondskin"), COMBAT).setParentResearch(steelArmor).setTranslatedName("Diamond Skin").setIcon(Items.field_151161_ac).addItemCost(Items.field_151045_i, 64).addEffect(ResearchConstants.ARMOR_DURABILITY, 6).addToList(r);
        AbstractResearchProvider.Research regeneration = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/regeneration"), COMBAT).setParentResearch(improvedLeather).setTranslatedName("Regeneration").setSortOrder(2).setOnlyChild().setIcon(Items.field_151060_bw).addBuildingRequirement("guardtower", 2).addItemCost(Items.field_151166_bC, 1).addEffect(ResearchConstants.RETREAT, 1).addToList(r);
        AbstractResearchProvider.Research feint = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/feint"), COMBAT).setParentResearch(regeneration).setTranslatedName("Feint").setIcon(Items.field_151021_T).addBuildingRequirement("guardtower", 4).addItemCost(Items.field_151166_bC, 8).addEffect(ResearchConstants.FLEEING_DAMAGE, 1).addToList(r);
        AbstractResearchProvider.Research fear = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/fear"), COMBAT).setParentResearch(feint).setTranslatedName("Fear").setIcon(Items.field_151167_ab).addBuildingRequirement("guardtower", 8).addItemCost(Items.field_151166_bC, 16).addEffect(ResearchConstants.FLEEING_DAMAGE, 2).addToList(r);
        AbstractResearchProvider.Research retreat = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/retreat"), COMBAT).setParentResearch(fear).setTranslatedName("Retreat").setTranslatedSubtitle("For strategic purposes, I assure you.").setIcon(Items.field_151151_aj).addBuildingRequirement("guardtower", 12).addItemCost(Items.field_151166_bC, 32).addEffect(ResearchConstants.FLEEING_DAMAGE, 3).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/fullretreat"), COMBAT).setParentResearch(retreat).setTranslatedName("Full Retreat").setIcon(Items.field_151175_af).addItemCost(Items.field_151166_bC, 64).addEffect(ResearchConstants.FLEEING_DAMAGE, 4).addToList(r);
        AbstractResearchProvider.Research avoid = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/avoid"), COMBAT).setParentResearch(regeneration).setTranslatedName("Avoid").setSortOrder(2).setIcon(Items.field_151008_G).addBuildingRequirement("guardtower", 4).addItemCost(Items.field_151166_bC, 8).addEffect(ResearchConstants.FLEEING_SPEED, 1).addToList(r);
        AbstractResearchProvider.Research evade = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/evade"), COMBAT).setParentResearch(avoid).setTranslatedName("Evade").setIcon(Items.field_151008_G, 2).addBuildingRequirement("guardtower", 8).addItemCost(Items.field_151166_bC, 16).addEffect(ResearchConstants.FLEEING_SPEED, 2).addToList(r);
        AbstractResearchProvider.Research flee = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/flee"), COMBAT).setParentResearch(evade).setTranslatedName("Flee").setTranslatedSubtitle("Sometimes it's better just to run.").setIcon(Items.field_151008_G, 3).addBuildingRequirement("guardtower", 12).addItemCost(Items.field_151166_bC, 32).addEffect(ResearchConstants.FLEEING_SPEED, 3).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/hotfoot"), COMBAT).setParentResearch(flee).setTranslatedName("Hotfoot").setIcon(Items.field_151076_bf).addItemCost(Items.field_151166_bC, 64).addEffect(ResearchConstants.FLEEING_SPEED, 4).addToList(r);
        AbstractResearchProvider.Research taunt = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/taunt"), COMBAT).setTranslatedName("Taunt").setTranslatedSubtitle("Your mother was a hamster and your father smelt of elderberries!").setSortOrder(5).setIcon(Items.field_234729_dO_).addBuildingRequirement("guardtower", 1).addItemCost(Items.field_151078_bh, 8).addItemCost(Items.field_151103_aS, 8).addItemCost(Items.field_151070_bp, 8).addEffect(ResearchConstants.KNIGHT_TAUNT, 1).addToList(r);
        AbstractResearchProvider.Research arrowUse = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/arrowuse"), COMBAT).setParentResearch(taunt).setTranslatedName("Consume Arrows").setTranslatedSubtitle("They work better with ammo.").setIcon(Items.field_151032_g).addBuildingRequirement("guardtower", 2).addItemCost(Items.field_151032_g, 64).addEffect(ResearchConstants.ARCHER_USE_ARROWS, 1).addToList(r);
        AbstractResearchProvider.Research arrowPierce = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/arrowpierce"), COMBAT).setParentResearch(arrowUse).setTranslatedName("Arrow Piercing").setIcon(Items.field_151134_bR).addBuildingRequirement("archery", 1).addItemCost(Items.field_151032_g, 64).addItemCost(Items.field_151137_ax, 64).addEffect(ResearchConstants.ARROW_PIERCE, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "combat/whirlwind"), COMBAT).setParentResearch(arrowPierce).setTranslatedName("Whirlwind").setIcon(ModItems.scimitar).addBuildingRequirement("barracks", 4).addItemCost(Items.field_151137_ax, 64).addItemCost(Items.field_151043_k, 64).addItemCost(Items.field_196128_bn, 128).addEffect(ResearchConstants.KNIGHT_WHIRLWIND, 1).addToList(r);
        return r;
    }

    public Collection<AbstractResearchProvider.Research> getTechnologyResearch(Collection<AbstractResearchProvider.Research> r) {
        AbstractResearchProvider.Research biodegradable = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/biodegradable"), TECH).setTranslatedName("Biodegradable").setTranslatedSubtitle("Where science meets dirt.").setIcon(ModBlocks.blockHutComposter.func_199767_j()).addBuildingRequirement("farmer", 3).addItemCost(Items.field_196106_bc, 64).addEffect(ModBuildings.composter.getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research podzolChance = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/podzolchance"), TECH).setParentResearch(biodegradable).setTranslatedName("Podzol Chance").setTranslatedSubtitle("Eww, sticky!").setIcon(Items.field_221584_l).addBuildingRequirement("composter", 2).addItemCost(Items.field_221584_l, 8).addEffect(ResearchConstants.PODZOL_CHANCE, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/podzolchance2"), TECH).setParentResearch(podzolChance).setTranslatedName("Podzol Chance II").setTranslatedSubtitle("Much easier than Silk Touch.").setIcon(Items.field_221584_l).addBuildingRequirement("composter", 3).addItemCost(Items.field_221584_l, 32).addEffect(ResearchConstants.PODZOL_CHANCE, 2).addToList(r);
        AbstractResearchProvider.Research flowerPower = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/flowerpower"), TECH).setParentResearch(biodegradable).setTranslatedName("Flower Power").setIcon(ModBlocks.blockHutFlorist.func_199767_j()).addBuildingRequirement("composter", 3).addItemCost(ModItems.compost, 64).addEffect(ModBuildings.florist.getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research rainbowHeaven = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/rainbowheaven"), TECH).setParentResearch(flowerPower).setTranslatedName("Rainbow Heaven").setTranslatedSubtitle("Now in color! And 3D!").setIcon(ModBlocks.blockHutComposter.func_199767_j()).addBuildingRequirement("florist", 3).addItemCost(Items.field_221620_aV, 64).addEffect(ModBuildings.dyer.getBuildingBlock(), 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/honeypot"), TECH).setParentResearch(rainbowHeaven).setTranslatedName("Honey Pot").setTranslatedSubtitle("Wasn't going to eat it. Just going to taste it.").setIcon(Items.field_226635_pU_.func_199767_j()).addBuildingRequirement("beekeeper", 3).addItemCost(Items.field_226637_pW_, 16).addEffect(ResearchConstants.BEEKEEP_2, 1).addToList(r);
        AbstractResearchProvider.Research letItGrow = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/letitgrow"), TECH).setParentResearch(biodegradable).setTranslatedName("Let It Grow").setTranslatedSubtitle("Just one tiny seed is all we really need.").setSortOrder(2).setIcon(ModBlocks.blockHutPlantation.func_199767_j()).addBuildingRequirement("farmer", 3).addItemCost(ModItems.compost, 16).addEffect(ModBuildings.plantation.getBuildingBlock(), 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/doubletrouble"), TECH).setParentResearch(letItGrow).setTranslatedName("Double Trouble").setTranslatedSubtitle("Double Trouble").setIcon(Items.field_222079_lj).addBuildingRequirement("plantation", 3).addItemCost(Items.field_222068_kQ, 64).addItemCost(Items.field_222065_kN, 64).addItemCost(Items.field_221774_cw, 64).addEffect(ResearchConstants.PLANT_2, 1).addToList(r);
        AbstractResearchProvider.Research bonemeal = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/bonemeal"), TECH).setParentResearch(biodegradable).setTranslatedName("Bonemeal").setTranslatedSubtitle("And to think this stuff feeds our plants...").setSortOrder(3).setIcon(Items.field_151014_N).addBuildingRequirement("miner", 3).addItemCost(Items.field_151014_N, 64).addEffect(ResearchConstants.FARMING, 1).addToList(r);
        AbstractResearchProvider.Research dung = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/dung"), TECH).setParentResearch(bonemeal).setTranslatedName("Dung").setTranslatedSubtitle("Fresh or not, here it comes!").setIcon(Items.field_196106_bc).addBuildingRequirement("miner", 4).addItemCost(Items.field_151014_N, 128).addEffect(ResearchConstants.FARMING, 2).addToList(r);
        AbstractResearchProvider.Research compost = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/compost"), TECH).setParentResearch(dung).setTranslatedName("Compost").setIcon(Items.field_151103_aS).addBuildingRequirement("miner", 5).addItemCost(Items.field_151014_N, 256).addEffect(ResearchConstants.FARMING, 3).addToList(r);
        AbstractResearchProvider.Research fertilizer = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/fertilizer"), TECH).setParentResearch(compost).setTranslatedName("Fertilizer").setTranslatedSubtitle("Ah, that's the stuff!").setIcon(Items.field_221964_gn).addBuildingRequirement("smeltery", 3).addItemCost(Items.field_151014_N, 512).addEffect(ResearchConstants.FARMING, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/magiccompost"), TECH).setParentResearch(fertilizer).setTranslatedName("Magic Compost").setIcon(ModBlocks.blockBarrel.func_199767_j()).addItemCost(Items.field_151014_N, 2048).addEffect(ResearchConstants.FARMING, 5).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/morescrolls"), TECH).setTranslatedName("More Scrolls").setSortOrder(2).setIcon(ModItems.scrollHighLight).addBuildingRequirement("enchanter", 3).addItemCost(Items.field_151121_aF, 64).addItemCost(ModItems.ancientTome, 1).addItemCost(Items.field_196128_bn, 64).addEffect(new ResourceLocation("minecolonies:effects/morescrollsunlock"), 1).addToList(r);
        AbstractResearchProvider.Research stoneCake = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/stonecake"), TECH).setTranslatedName("Stone Cake").setTranslatedSubtitle("Don't break a tooth!").setSortOrder(3).setIcon(ModBlocks.blockHutStonemason.func_199767_j()).addBuildingRequirement("miner", 3).addItemCost(Items.field_221782_da, 64).addEffect(ModBuildings.stoneMason.getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research rockingRoll = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/rockingroll"), TECH).setParentResearch(stoneCake).setTranslatedName("Rocking Roll").setIcon(ModBlocks.blockHutCrusher.func_199767_j()).addBuildingRequirement("stonemason", 1).addItemCost(Items.field_221574_b, 64).addEffect(ModBuildings.crusher.getBuildingBlock(), 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/gildedhammer"), TECH).setParentResearch(rockingRoll).setTranslatedName("Gilded Hammer").setTranslatedSubtitle("When in doubt, cover in shiny stuff.").setIcon(Items.field_221696_bj).addBuildingRequirement("crusher", 3).addItemCost(Items.field_221550_C, 64).addItemCost(Items.field_221548_A, 64).addItemCost(Items.field_221776_cx, 64).addEffect(ResearchConstants.CRUSHING_11, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/pavetheroad"), TECH).setParentResearch(rockingRoll).setTranslatedName("Pave the Road").setTranslatedSubtitle("Not something you want to get mixed up in.").setSortOrder(2).setIcon(ModBlocks.blockHutConcreteMixer.func_199767_j()).addBuildingRequirement("crusher", 1).addItemCost(Items.field_221931_gX, 32).addEffect(ModBuildings.concreteMixer.getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research woodwork = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/woodwork"), TECH).setTranslatedName("Woodwork").setTranslatedSubtitle("Where oh where would a wood worker work if a wood worker would work wood?").setSortOrder(4).setIcon(ModBlocks.blockHutSawmill.func_199767_j()).addBuildingRequirement("lumberjack", 3).addItemCost(Items.field_221586_n, 64).addEffect(ModBuildings.sawmill.getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research stringWork = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/stringwork"), TECH).setParentResearch(woodwork).setTranslatedName("Stringwork").setIcon(ModBlocks.blockHutFletcher.func_199767_j()).addBuildingRequirement("sawmill", 1).addItemCost(Items.field_151007_F, 16).addEffect(ModBuildings.fletcher.getBuildingBlock(), 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/hotboots"), TECH).setParentResearch(stringWork).setTranslatedName("Hot Boots").setTranslatedSubtitle("Warmer on the outside.").setIcon(Items.field_222113_pS).addBuildingRequirement("fletcher", 1).addItemCost(Items.field_151116_aA, 32).addItemCost(Items.field_151042_j, 16).addEffect(ResearchConstants.FIRE_RES, 1).addToList(r);
        AbstractResearchProvider.Research sieving = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/sieving"), TECH).setParentResearch(woodwork).setTranslatedName("Sieving").setTranslatedSubtitle("How did that get in there?").setSortOrder(2).setIcon(ModBlocks.blockHutSifter.func_199767_j()).addBuildingRequirement("fisherman", 3).addItemCost(Items.field_151007_F, 64).addEffect(ModBuildings.sifter.getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research space = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/space"), TECH).setParentResearch(sieving).setTranslatedName("Space").setTranslatedSubtitle("Antidisinterdimensionalitarianism!").setIcon(Items.field_221675_bZ).addBuildingRequirement("miner", 3).addItemCost(ModBlocks.blockRack.func_199767_j(), 16).addEffect(ResearchConstants.MINIMUM_STOCK, 1).addToList(r);
        AbstractResearchProvider.Research capacity = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/capacity"), TECH).setParentResearch(space).setTranslatedName("Capacity").setTranslatedSubtitle("Don't ask how we fit it all.").setIcon(Items.field_151108_aI).addBuildingRequirement("miner", 4).addItemCost(ModBlocks.blockRack.func_199767_j(), 32).addEffect(ResearchConstants.MINIMUM_STOCK, 2).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/fullstock"), TECH).setParentResearch(capacity).setTranslatedName("Full Stock!").setTranslatedSubtitle("We might be able to squeeze in one more.").setIcon(Items.field_221735_dD).addBuildingRequirement("miner", 5).addItemCost(ModBlocks.blockRack.func_199767_j(), 64).addEffect(ResearchConstants.MINIMUM_STOCK, 3).addToList(r);
        AbstractResearchProvider.Research memoryAid = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/memoryaid"), TECH).setParentResearch(woodwork).setTranslatedName("Memory Aid").setTranslatedSubtitle("It's the thought that counts.").setSortOrder(3).setIcon(Items.field_151121_aF).addBuildingRequirement("sawmill", 1).addItemCost(Items.field_151121_aF, 32).addEffect(ResearchConstants.RECIPES, 1).addToList(r);
        AbstractResearchProvider.Research cheatSheet = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/cheatsheet"), TECH).setParentResearch(memoryAid).setTranslatedName("Cheat Sheet").setTranslatedSubtitle("So THAT's what I should be making!").setIcon(Items.field_151122_aG).addBuildingRequirement("sawmill", 2).addItemCost(Items.field_151121_aF, 64).addEffect(ResearchConstants.RECIPES, 2).setSortOrder(1).addToList(r);
        AbstractResearchProvider.Research recipeBook = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/recipebook"), TECH).setParentResearch(cheatSheet).setTranslatedName("Recipe Book").setIcon(Items.field_151134_bR).addBuildingRequirement("sawmill", 3).addItemCost(Items.field_151121_aF, 128).addEffect(ResearchConstants.RECIPES, 3).addToList(r);
        AbstractResearchProvider.Research rtm = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/rtm"), TECH).setParentResearch(recipeBook).setTranslatedName("RTM").setTranslatedSubtitle("I saw some information on this somewhere...").setIcon(Items.field_221651_bN).addBuildingRequirement("sawmill", 4).addItemCost(Items.field_151121_aF, 256).addEffect(ResearchConstants.RECIPES, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/rainman"), TECH).setParentResearch(rtm).setTranslatedName("Rainman").setTranslatedSubtitle("Raindrops are falling on my head...").setIcon(Items.field_185155_bH).addItemCost(Items.field_203796_aM, 27).addEffect(ResearchConstants.WORKING_IN_RAIN, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/warehousemaster"), TECH).setParentResearch(memoryAid).setTranslatedName("Warehouse Master").setTranslatedSubtitle("So many items to choose from!").setIcon(ModBlocks.blockRack.func_199767_j()).addBuildingRequirement("sawmill", 3).addItemCost(ModBlocks.blockRack.func_199767_j(), 3).addEffect(ResearchConstants.RECIPE_MODE, 1).setSortOrder(2).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/buildermodes"), TECH).setParentResearch(memoryAid).setTranslatedName("Builder Modes").setTranslatedSubtitle("Possibility Overload!").setIcon(ModBlocks.blockHutBuilder.func_199767_j()).addBuildingRequirement("builder", 3).addItemCost(Items.field_151056_x, 1).addEffect(ResearchConstants.BUILDER_MODE, 1).setSortOrder(3).addToList(r);
        AbstractResearchProvider.Research deepPockets = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/deeppockets"), TECH).setParentResearch(cheatSheet).setTranslatedName("Deep Pockets").setSortOrder(2).setIcon(Items.field_221984_gx).addBuildingRequirement("library", 4).addItemCost(Items.field_151166_bC, 64).addEffect(ResearchConstants.CITIZEN_INV_SLOTS, 1).addToList(r);
        AbstractResearchProvider.Research loaded = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/loaded"), TECH).setParentResearch(deepPockets).setTranslatedName("Loaded").setIcon(Items.field_221895_gF).addBuildingRequirement("library", 5).addItemCost(Items.field_151166_bC, 128).addEffect(ResearchConstants.CITIZEN_INV_SLOTS, 2).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/heavilyloaded"), TECH).setParentResearch(loaded).setTranslatedName("Heavily Loaded").setIcon(Items.field_221889_gC).setNoReset().addItemCost(Items.field_151166_bC, 256).addEffect(ResearchConstants.CITIZEN_INV_SLOTS, 3).addToList(r);
        AbstractResearchProvider.Research hot = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/hot"), TECH).setTranslatedName("Hot!").setSortOrder(5).setIcon(ModBlocks.blockHutSmeltery.func_199767_j()).addBuildingRequirement("miner", 2).addItemCost(Items.field_151129_at, 4).addEffect(ModBuildings.smeltery.getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research isThisRedstone = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/isthisredstone"), TECH).setParentResearch(hot).setTranslatedName("Is This Redstone?").setIcon(Items.field_151137_ax).addItemCost(Items.field_151137_ax, 128).addEffect(ResearchConstants.BLOCK_BREAK_SPEED, 1).addToList(r);
        AbstractResearchProvider.Research redstonePowered = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/redstonepowered"), TECH).setParentResearch(isThisRedstone).setTranslatedName("Redstone Powered").setTranslatedSubtitle("Like magic, but SCIENCE!").setIcon(Items.field_221764_cr).addItemCost(Items.field_151137_ax, 256).addEffect(ResearchConstants.BLOCK_BREAK_SPEED, 2).addToList(r);
        AbstractResearchProvider.Research heavyMachinery = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/heavymachinery"), TECH).setParentResearch(redstonePowered).setTranslatedName("Heavy Machinery").setIcon(Items.field_221858_em).addItemCost(Items.field_151137_ax, 512).addEffect(ResearchConstants.BLOCK_BREAK_SPEED, 3).addToList(r);
        AbstractResearchProvider.Research whatIsThisSpeed = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/whatisthisspeed"), TECH).setParentResearch(heavyMachinery).setTranslatedName("What Is This Speed?").setTranslatedSubtitle("We stopped trying to calculate it after a while.").setIcon(Items.field_222029_iU).addItemCost(Items.field_151137_ax, 1024).addEffect(ResearchConstants.BLOCK_BREAK_SPEED, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/lightning"), TECH).setParentResearch(whatIsThisSpeed).setTranslatedName("Lightning").setTranslatedSubtitle("BAM! And the block is gone!").setIcon(Items.field_222027_iT).addItemCost(Items.field_151137_ax, 2048).addEffect(ResearchConstants.BLOCK_BREAK_SPEED, 5).addToList(r);
        AbstractResearchProvider.Research theFlintstones = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/theflintstones"), TECH).setParentResearch(hot).setTranslatedName("The Flintstones").setTranslatedSubtitle("Yabba Dabba Doo!").setIcon(ModBlocks.blockHutStoneSmeltery.func_199767_j()).addBuildingRequirement("smeltery", 3).addItemCost(Items.field_221723_cX, 64).addEffect(ModBuildings.stoneSmelter.getBuildingBlock(), 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/knowtheend"), TECH).setParentResearch(theFlintstones).setTranslatedName("Know the End").setTranslatedSubtitle("Unlock the secrets of the most mysterious dimension.").setIcon(ModItems.chorusBread).addBuildingRequirement("baker", 3).addItemCost(Items.field_185161_cS, 64).addEffect(new ResourceLocation("minecolonies:effects/knowledgeoftheendunlock"), 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/thoselungs"), TECH).setParentResearch(hot).setTranslatedName("Those Lungs!").setTranslatedSubtitle("You'll definitely be needing those in some form.").setIcon(ModBlocks.blockHutGlassblower.func_199767_j()).addBuildingRequirement("smeltery", 3).addItemCost(Items.field_221650_am, 64).addEffect(ModBuildings.glassblower.getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research hittingIron = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/hittingiron"), TECH).setTranslatedName("Hitting Iron!").setTranslatedSubtitle("We're still ironing out the details.").setIcon(ModBlocks.blockHutBlacksmith.func_199767_j()).addBuildingRequirement("miner", 3).addItemCost(Items.field_221844_ef, 1).addEffect(ModBuildings.blacksmith.getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research strong = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/strong"), TECH).setParentResearch(hittingIron).setTranslatedName("Strong").setIcon(Items.field_151039_o).addBuildingRequirement("blacksmith", 1).addItemCost(Items.field_151045_i, 8).addEffect(ResearchConstants.TOOL_DURABILITY, 1).addToList(r);
        AbstractResearchProvider.Research hardened = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/hardened"), TECH).setParentResearch(strong).setTranslatedName("Hardened").setIcon(Items.field_151050_s).addBuildingRequirement("blacksmith", 2).addItemCost(Items.field_151045_i, 16).addEffect(ResearchConstants.TOOL_DURABILITY, 2).addToList(r);
        AbstractResearchProvider.Research reinforced = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/reinforced"), TECH).setParentResearch(hardened).setTranslatedName("Reinforced").setIcon(Items.field_151035_b).addBuildingRequirement("blacksmith", 3).addItemCost(Items.field_151045_i, 32).addEffect(ResearchConstants.TOOL_DURABILITY, 3).addToList(r);
        AbstractResearchProvider.Research steelBracing = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/steelbracing"), TECH).setParentResearch(reinforced).setTranslatedName("Steel Bracing").setIcon(Items.field_151005_D).addBuildingRequirement("blacksmith", 5).addItemCost(Items.field_151045_i, 64).addEffect(ResearchConstants.TOOL_DURABILITY, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/diamondcoated"), TECH).setParentResearch(steelBracing).setTranslatedName("Diamond Coated").setIcon(Items.field_151046_w).addItemCost(Items.field_151045_i, 128).addEffect(ResearchConstants.TOOL_DURABILITY, 5).addToList(r);
        AbstractResearchProvider.Research ability = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/ability"), TECH).setParentResearch(hittingIron).setTranslatedName("Ability").setIcon(Items.field_151114_aO).addBuildingRequirement("miner", 1).addItemCost(Items.field_151042_j, 64).addEffect(ResearchConstants.BLOCK_PLACE_SPEED, 1).addToList(r);
        AbstractResearchProvider.Research skills = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/skills"), TECH).setParentResearch(ability).setTranslatedName("Skills").setTranslatedSubtitle("Everything in its place.").setIcon(Items.field_221695_cJ).addBuildingRequirement("miner", 2).addItemCost(Items.field_151042_j, 128).addEffect(ResearchConstants.BLOCK_PLACE_SPEED, 2).addToList(r);
        AbstractResearchProvider.Research tools = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/tools"), TECH).setParentResearch(skills).setTranslatedName("Tools").setTranslatedSubtitle("Like breaking stuff, but in reverse!").setIcon(Items.field_221729_dA).addBuildingRequirement("blacksmith", 4).addItemCost(Items.field_151042_j, 256).addEffect(ResearchConstants.BLOCK_PLACE_SPEED, 3).addToList(r);
        AbstractResearchProvider.Research seemsAutomatic = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/seemsautomatic"), TECH).setParentResearch(tools).setTranslatedName("Seems Automatic").setTranslatedSubtitle("It all happened so fast...").setIcon(Items.field_151065_br).addBuildingRequirement("blacksmith", 5).addItemCost(Items.field_151042_j, 512).addEffect(ResearchConstants.BLOCK_PLACE_SPEED, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/madness"), TECH).setParentResearch(seemsAutomatic).setTranslatedName("Madness!").setIcon(Items.field_185166_h).addItemCost(Items.field_151042_j, 1024).addEffect(ResearchConstants.BLOCK_PLACE_SPEED, 5).addToList(r);
        AbstractResearchProvider.Research veinminer = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/veinminer"), TECH).setParentResearch(hittingIron).setTranslatedName("Veinminer").setIcon(Items.field_221698_bk).addBuildingRequirement("miner", 1).addItemCost(Items.field_221552_E, 32).addEffect(ResearchConstants.MORE_ORES, 1).addToList(r);
        AbstractResearchProvider.Research goodVeins = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/goodveins"), TECH).setParentResearch(veinminer).setTranslatedName("Good Veins").setIcon(Items.field_221896_ff).addBuildingRequirement("miner", 2).addItemCost(Items.field_221552_E, 64).addEffect(ResearchConstants.MORE_ORES, 2).addToList(r);
        AbstractResearchProvider.Research richVeins = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/richveins"), TECH).setParentResearch(goodVeins).setTranslatedName("Rich Veins").setIcon(Items.field_221696_bj).addBuildingRequirement("blacksmith", 4).addItemCost(Items.field_221551_D, 32).addEffect(ResearchConstants.MORE_ORES, 3).addToList(r);
        AbstractResearchProvider.Research amazingVeins = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/amazingveins"), TECH).setParentResearch(richVeins).setTranslatedName("Amazing Veins").setIcon(Items.field_221654_ao).addBuildingRequirement("blacksmith", 5).addItemCost(Items.field_221551_D, 64).addEffect(ResearchConstants.MORE_ORES, 4).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/motherlode"), TECH).setParentResearch(amazingVeins).setTranslatedName("Motherlode").setIcon(Items.field_221732_cb).addItemCost(Items.field_221730_ca, 64).addEffect(ResearchConstants.MORE_ORES, 5).addToList(r);
        AbstractResearchProvider.Research whatYaNeed = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/whatyaneed"), TECH).setParentResearch(hittingIron).setTranslatedName("What ya Need?").setTranslatedSubtitle("It's not a rhetorical question...").setIcon(ModBlocks.blockHutMechanic.func_199767_j()).addBuildingRequirement("blacksmith", 3).addItemCost(Items.field_151137_ax, 64).addEffect(ModBuildings.mechanic.getBuildingBlock(), 1).addToList(r);
        AbstractResearchProvider.Research enhanced_gates1 = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/enhanced_gates1"), TECH).setParentResearch(whatYaNeed).setTranslatedName("Enhanced Gates I").setIcon(ModItems.woodgate).addItemCost(ModItems.woodgate, 64).addItemCost(ModItems.ancientTome, 2).addItemCost(Items.field_221698_bk, 5).addEffect(ResearchConstants.MECHANIC_ENHANCED_GATES, 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "technology/enhanced_gates2"), TECH).setParentResearch(enhanced_gates1).setTranslatedName("Enhanced Gates II").setIcon(ModItems.irongate).addItemCost(ModItems.irongate, 64).addItemCost(ModItems.ancientTome, 2).addItemCost(Items.field_221655_bP, 32).addEffect(ResearchConstants.MECHANIC_ENHANCED_GATES, 2).addToList(r);
        return r;
    }

    public Collection<AbstractResearchProvider.Research> getAchievementResearch(Collection<AbstractResearchProvider.Research> r) {
        AbstractResearchProvider.Research stringmesh = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "unlockable/stringmesh"), UNLOCK).setTranslatedName("String Mesh").setIcon(ModItems.sifterMeshString).addMandatoryBuildingRequirement("sifter", 1).setHidden().setAutostart().setInstant().addEffect(new ResourceLocation("minecolonies", "effects/sifterstringunlock"), 1).addToList(r);
        AbstractResearchProvider.Research flintmesh = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "unlockable/flintmesh"), UNLOCK).setTranslatedName("Flint Mesh").setParentResearch(stringmesh).setIcon(ModItems.sifterMeshString).addMandatoryBuildingRequirement("sifter", 3).setHidden().setAutostart().setInstant().addEffect(new ResourceLocation("minecolonies", "effects/sifterflintunlock"), 1).addToList(r);
        AbstractResearchProvider.Research ironmesh = new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "unlockable/ironmesh"), UNLOCK).setTranslatedName("Iron Mesh").setParentResearch(flintmesh).setIcon(ModItems.sifterMeshString).addMandatoryBuildingRequirement("sifter", 4).setHidden().setAutostart().setInstant().addEffect(new ResourceLocation("minecolonies", "effects/sifterironunlock"), 1).addToList(r);
        new AbstractResearchProvider.Research(new ResourceLocation("minecolonies", "unlockable/diamondmesh"), UNLOCK).setTranslatedName("Diamond Mesh").setParentResearch(ironmesh).setIcon(ModItems.sifterMeshString).addMandatoryBuildingRequirement("sifter", 5).setHidden().setAutostart().setInstant().addEffect(new ResourceLocation("minecolonies", "effects/sifterdiamondunlock"), 1).addToList(r);
        return r;
    }
}

