/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.apiimp.initializer.ModTagsInitializer;
import com.minecolonies.coremod.colony.crafting.CustomRecipeManager;
import com.minecolonies.coremod.util.FurnaceRecipes;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import org.jetbrains.annotations.NotNull;

public class TagWorkAroundEventHandler {
    private static void loadRecipes(@NotNull RecipeManager recipeManager) {
        FurnaceRecipes.getInstance().loadRecipes(recipeManager);
        IMinecoloniesAPI.getInstance().getColonyManager().getCompatibilityManager().discover(recipeManager);
    }

    public static class TagFMLEventHandlers {
        @SubscribeEvent
        public static void onServerStarted(@NotNull FMLServerStartedEvent event) {
            MinecraftServer server = event.getServer();
            TagWorkAroundEventHandler.loadRecipes(server.func_199529_aN());
            CustomRecipeManager.getInstance().buildLootData(server.func_200249_aQ());
        }
    }

    public static class TagClientEventHandler {
        private static RecipeManager recipeManager;
        private static ITagCollectionSupplier tagManager;

        private static void maybeLoadRecipes() {
            if (recipeManager != null && tagManager != null) {
                if (!Minecraft.func_71410_x().func_71356_B()) {
                    TagWorkAroundEventHandler.loadRecipes(TagClientEventHandler.recipeManager);
                }
                recipeManager = null;
                tagManager = null;
            }
        }

        @SubscribeEvent
        public static void onRecipesUpdated(RecipesUpdatedEvent event) {
            recipeManager = event.getRecipeManager();
            TagClientEventHandler.maybeLoadRecipes();
        }

        @SubscribeEvent
        public static void onTagsUpdated(TagsUpdatedEvent.VanillaTagTypes event) {
            tagManager = event.getTagManager();
            TagClientEventHandler.maybeLoadRecipes();
        }

        @SubscribeEvent
        public static void onLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
            recipeManager = null;
            tagManager = null;
        }
    }

    public static class TagEventHandler {
        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onTagUpdate(TagsUpdatedEvent.VanillaTagTypes event) {
            ModTagsInitializer.init(event.getTagManager());
        }

        @SubscribeEvent
        public static void onDataPackSync(OnDatapackSyncEvent event) {
            CustomRecipeManager recipeManager = CustomRecipeManager.getInstance();
            if (event.getPlayer() == null) {
                MinecraftServer server = event.getPlayerList().func_72365_p();
                TagWorkAroundEventHandler.loadRecipes(server.func_199529_aN());
                recipeManager.buildLootData(server.func_200249_aQ());
                for (ServerPlayerEntity player : event.getPlayerList().func_181057_v()) {
                    recipeManager.sendCustomRecipeManagerPackets(player);
                }
            } else {
                recipeManager.sendCustomRecipeManagerPackets(event.getPlayer());
            }
        }
    }
}

